/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.problems;

import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.ProblemSolutionHint;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/intellij/problems/SuspiciousUntilBuild;", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "untilBuild", "", "additionalMessage", "(Ljava/lang/String;Ljava/lang/String;)V", "hint", "Lcom/jetbrains/plugin/structure/base/problems/ProblemSolutionHint;", "getHint", "()Lcom/jetbrains/plugin/structure/base/problems/ProblemSolutionHint;", "level", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem$Level;", "getLevel", "()Lcom/jetbrains/plugin/structure/base/problems/PluginProblem$Level;", "message", "getMessage", "()Ljava/lang/String;", "structure-intellij"})
public class SuspiciousUntilBuild
extends PluginProblem {
    @NotNull
    private final ProblemSolutionHint hint;
    private final String untilBuild;
    private final String additionalMessage;

    @Override
    @NotNull
    public ProblemSolutionHint getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    public String getMessage() {
        CharSequence charSequence = this.additionalMessage;
        return "The <until-build> '" + this.untilBuild + "' does not represent the actual build number. " + (String)(!StringsKt.isBlank(charSequence) ? this.additionalMessage + " " : "If you want your plugin to be compatible with all future IDE versions, you can remove this attribute. However, we highly recommend setting it to the latest available IDE version.");
    }

    @Override
    @NotNull
    public PluginProblem.Level getLevel() {
        return PluginProblem.Level.WARNING;
    }

    public SuspiciousUntilBuild(@NotNull String untilBuild, @NotNull String additionalMessage) {
        Intrinsics.checkNotNullParameter(untilBuild, "untilBuild");
        Intrinsics.checkNotNullParameter(additionalMessage, "additionalMessage");
        this.untilBuild = untilBuild;
        this.additionalMessage = additionalMessage;
        this.hint = new ProblemSolutionHint(null, "https://plugins.jetbrains.com/docs/intellij/build-number-ranges.html", 1, null);
    }

    public /* synthetic */ SuspiciousUntilBuild(String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            string3 = "";
        }
        this(string2, string3);
    }
}

