/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide.classes;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.CompositeResolver;
import com.jetbrains.plugin.structure.classes.resolvers.DirectoryResolver;
import com.jetbrains.plugin.structure.classes.resolvers.EmptyResolver;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.JarFileResolverKt;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.ide.IdeManagerImpl;
import com.jetbrains.plugin.structure.ide.InvalidIdeException;
import com.jetbrains.plugin.structure.ide.RepositoryLibrariesUtilKt;
import com.jetbrains.plugin.structure.ide.classes.IdeFileOrigin;
import com.jetbrains.plugin.structure.ide.classes.IdeResolverConfiguration;
import com.jetbrains.plugin.structure.ide.classes.resolver.ProductInfoClassResolver;
import com.jetbrains.plugin.structure.ide.layout.InvalidIdeLayoutException;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0002J \u0010\u0016\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/plugin/structure/ide/classes/IdeResolverCreator;", "", "()V", "createIdeResolver", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "configuration", "Lcom/jetbrains/plugin/structure/ide/classes/IdeResolverConfiguration;", "getIdeResolverFromCompiledSources", "idePath", "Ljava/nio/file/Path;", "getIdeResolverFromDistribution", "resolverConfiguration", "getJarsResolver", "libDirectory", "parentOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "getProductInfoClassResolver", "Lcom/jetbrains/plugin/structure/ide/classes/resolver/ProductInfoClassResolver;", "getRepositoryLibrariesResolver", "structure-ide-classes"})
@SourceDebugExtension(value={"SMAP\nIdeResolverCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeResolverCreator.kt\ncom/jetbrains/plugin/structure/ide/classes/IdeResolverCreator\n+ 2 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n79#2,2:111\n81#2,2:115\n83#2:119\n1855#3,2:113\n1855#3,2:117\n*E\n*S KotlinDebug\n*F\n+ 1 IdeResolverCreator.kt\ncom/jetbrains/plugin/structure/ide/classes/IdeResolverCreator\n*L\n86#1,2:111\n86#1,2:115\n86#1:119\n91#1,2:113\n86#1,2:117\n*E\n"})
public final class IdeResolverCreator {
    @NotNull
    public static final IdeResolverCreator INSTANCE;

    @JvmStatic
    @NotNull
    public static final Resolver createIdeResolver(@NotNull Ide ide2) {
        Intrinsics.checkNotNullParameter(ide2, "ide");
        return IdeResolverCreator.createIdeResolver(Resolver.ReadMode.FULL, ide2);
    }

    @JvmStatic
    @NotNull
    public static final Resolver createIdeResolver(@NotNull Resolver.ReadMode readMode, @NotNull Ide ide2) {
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        Intrinsics.checkNotNullParameter(ide2, "ide");
        return IdeResolverCreator.createIdeResolver(ide2, new IdeResolverConfiguration(readMode, null, 2, null));
    }

    @JvmStatic
    @NotNull
    public static final Resolver createIdeResolver(@NotNull Ide ide2, @NotNull IdeResolverConfiguration configuration) {
        Resolver resolver;
        Intrinsics.checkNotNullParameter(ide2, "ide");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Path path = ide2.getIdePath();
        Intrinsics.checkNotNullExpressionValue(path, "ide.idePath");
        Path idePath = path;
        if (IdeManagerImpl.Companion.isDistributionIde(idePath)) {
            resolver = INSTANCE.getIdeResolverFromDistribution(ide2, configuration);
        } else if (IdeManagerImpl.Companion.isCompiledCommunity(idePath) || IdeManagerImpl.Companion.isCompiledUltimate(idePath)) {
            resolver = INSTANCE.getIdeResolverFromCompiledSources(idePath, configuration.getReadMode(), ide2);
        } else {
            throw (Throwable)new InvalidIdeException(idePath, "Invalid IDE " + ide2 + " at " + idePath);
        }
        return resolver;
    }

    private final Resolver getJarsResolver(Path libDirectory, Resolver.ReadMode readMode, FileOrigin parentOrigin) {
        if (!FileUtilKt.isDirectory(libDirectory)) {
            return EmptyResolver.INSTANCE;
        }
        List<Path> jars = FileUtilKt.listJars(libDirectory);
        Path path = libDirectory.resolve("ant").resolve("lib");
        Intrinsics.checkNotNullExpressionValue(path, "libDirectory.resolve(\"ant\").resolve(\"lib\")");
        List<Path> antJars = FileUtilKt.listJars(path);
        Path path2 = libDirectory.resolve("modules");
        Intrinsics.checkNotNullExpressionValue(path2, "libDirectory.resolve(\"modules\")");
        List<Path> moduleJars = FileUtilKt.listJars(path2);
        return CompositeResolver.Companion.create((Iterable<? extends Resolver>)JarFileResolverKt.buildJarOrZipFileResolvers(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)jars, (Iterable)antJars), (Iterable)moduleJars), readMode, parentOrigin));
    }

    private final Resolver getIdeResolverFromDistribution(Ide ide2, IdeResolverConfiguration resolverConfiguration) {
        Resolver resolver;
        Ide $this$with = ide2;
        boolean bl = false;
        Path path = $this$with.getIdePath();
        Intrinsics.checkNotNullExpressionValue(path, "idePath");
        if (ProductInfoClassResolver.Companion.supports(path)) {
            resolver = INSTANCE.getProductInfoClassResolver(ide2, resolverConfiguration);
        } else {
            Path path2 = $this$with.getIdePath().resolve("lib");
            Intrinsics.checkNotNullExpressionValue(path2, "idePath.resolve(\"lib\")");
            resolver = INSTANCE.getJarsResolver(path2, resolverConfiguration.getReadMode(), new IdeFileOrigin.IdeLibDirectory(ide2));
        }
        return resolver;
    }

    private final ProductInfoClassResolver getProductInfoClassResolver(Ide ide2, IdeResolverConfiguration resolverConfiguration) {
        try {
            return ProductInfoClassResolver.Companion.of(ide2, resolverConfiguration);
        }
        catch (InvalidIdeLayoutException e) {
            Path path = ide2.getIdePath();
            Intrinsics.checkNotNullExpressionValue(path, "ide.idePath");
            throw (Throwable)new InvalidIdeException(path, e);
        }
    }

    private final Resolver getIdeResolverFromCompiledSources(Path idePath, Resolver.ReadMode readMode, Ide ide2) {
        ArrayList resolvers = new ArrayList();
        List $this$closeOnException$iv = resolvers;
        boolean $i$f$closeOnException = false;
        try {
            List it = $this$closeOnException$iv;
            boolean bl = false;
            Collection collection = resolvers;
            Path path = idePath.resolve("lib");
            Intrinsics.checkNotNullExpressionValue(path, "idePath.resolve(\"lib\")");
            Object object = INSTANCE.getJarsResolver(path, readMode, new IdeFileOrigin.SourceLibDirectory(ide2));
            collection.add(object);
            collection = resolvers;
            object = INSTANCE.getRepositoryLibrariesResolver(idePath, readMode, ide2);
            collection.add(object);
            Path path2 = IdeManagerImpl.Companion.getCompiledClassesRoot(idePath);
            Intrinsics.checkNotNull(path2);
            Path compiledClassesRoot = path2;
            Iterable $this$forEach$iv = FileUtilKt.listFiles(compiledClassesRoot);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path moduleRoot = (Path)element$iv;
                boolean bl2 = false;
                IdeFileOrigin.CompiledModule fileOrigin = new IdeFileOrigin.CompiledModule(ide2, FileUtilKt.getSimpleName(moduleRoot));
                Collection collection2 = resolvers;
                DirectoryResolver directoryResolver = new DirectoryResolver(moduleRoot, fileOrigin, readMode);
                collection2.add(directoryResolver);
            }
            if (IdeManagerImpl.Companion.isCompiledUltimate(idePath)) {
                object = resolvers;
                Path path3 = idePath.resolve("community").resolve("lib");
                Intrinsics.checkNotNullExpressionValue(path3, "idePath.resolve(\"community\").resolve(\"lib\")");
                Resolver resolver = INSTANCE.getJarsResolver(path3, readMode, new IdeFileOrigin.SourceLibDirectory(ide2));
                object.add(resolver);
            }
            return CompositeResolver.Companion.create(resolvers);
        }
        catch (Throwable e$iv) {
            Iterable $this$forEach$iv$iv = $this$closeOnException$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Closeable t$iv = (Closeable)element$iv$iv;
                boolean bl = false;
                Closeable closeable = t$iv;
                if (closeable == null) continue;
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e$iv;
        }
    }

    private final Resolver getRepositoryLibrariesResolver(Path idePath, Resolver.ReadMode readMode, Ide ide2) {
        List<Path> jars = RepositoryLibrariesUtilKt.getRepositoryLibrariesJars(idePath);
        return CompositeResolver.Companion.create((Iterable<? extends Resolver>)JarFileResolverKt.buildJarOrZipFileResolvers((Iterable<? extends Path>)jars, readMode, new IdeFileOrigin.RepositoryLibrary(ide2)));
    }

    private IdeResolverCreator() {
    }

    static {
        IdeResolverCreator ideResolverCreator;
        INSTANCE = ideResolverCreator = new IdeResolverCreator();
    }
}

