/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class ReplicatorInputStream
extends InputStream {
    private final BufferExposingByteArrayOutputStream myTarget;
    private final InputStream mySource;
    private int markedSize;

    public ReplicatorInputStream(@NotNull InputStream source2, @NotNull BufferExposingByteArrayOutputStream target) {
        if (source2 == null) {
            ReplicatorInputStream.$$$reportNull$$$0(0);
        }
        if (target == null) {
            ReplicatorInputStream.$$$reportNull$$$0(1);
        }
        this.mySource = source2;
        this.myTarget = target;
    }

    @Override
    public int read() throws IOException {
        int b = this.mySource.read();
        if (b == -1) {
            return -1;
        }
        this.myTarget.write(b);
        return b;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mySource.mark(readlimit);
        this.markedSize = this.myTarget.size();
    }

    @Override
    public boolean markSupported() {
        return this.mySource.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.mySource.reset();
        this.myTarget.backOff(this.myTarget.size() - this.markedSize);
        this.markedSize = 0;
    }

    @Override
    public int read(byte @NotNull [] b) throws IOException {
        if (b == null) {
            ReplicatorInputStream.$$$reportNull$$$0(2);
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        int count2;
        if (b == null) {
            ReplicatorInputStream.$$$reportNull$$$0(3);
        }
        if ((count2 = this.mySource.read(b, off, len)) < 0) {
            return count2;
        }
        this.myTarget.write(b, off, count2);
        return count2;
    }

    @Override
    public long skip(long n) throws IOException {
        int skipped = this.read(new byte[(int)n]);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        return this.mySource.available();
    }

    @Override
    public void close() throws IOException {
        this.mySource.close();
        this.myTarget.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/ReplicatorInputStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

