/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class WeakListener<Src, Listener>
implements InvocationHandler {
    private final WeakReference<Listener> myDelegate;
    private Src mySource;

    protected WeakListener(Src source2, Class<Listener> listenerInterface, Listener listenerImpl) {
        this.mySource = source2;
        this.myDelegate = new WeakReference<Listener>(listenerImpl);
        ClassLoader classLoader = listenerImpl.getClass().getClassLoader();
        Object proxy = Proxy.newProxyInstance(classLoader, new Class[]{listenerInterface}, (InvocationHandler)this);
        this.addListener(source2, proxy);
    }

    protected abstract void addListener(Src var1, Listener var2);

    protected abstract void removeListener(Src var1, Listener var2);

    @Override
    public final Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        Object listenerImplObject = this.myDelegate.get();
        if (listenerImplObject == null) {
            this.removeListener(this.mySource, proxy);
            this.mySource = null;
            return null;
        }
        return method.invoke(listenerImplObject, params);
    }
}

