/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.encoder.JsonEncoderBase;
import ch.qos.logback.core.util.DirectJson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;

public class JsonEncoder
extends JsonEncoderBase<ILoggingEvent> {
    public static final String TIMESTAMP_ATTR_NAME = "timestamp";
    public static final String LEVEL_ATTR_NAME = "level";
    public static final String MARKERS_ATTR_NAME = "tags";
    public static final String THREAD_ATTR_NAME = "thread";
    public static final String MDC_ATTR_NAME = "mdc";
    public static final String LOGGER_ATTR_NAME = "logger";
    public static final String FORMATTED_MESSAGE_ATTR_NAME = "message";
    public static final String MESSAGE_ATTR_NAME = "raw-message";
    public static final String EXCEPTION_ATTR_NAME = "exception";
    public static final String CONTEXT_ATTR_NAME = "context";
    protected boolean includeLevel = true;
    protected boolean includeThreadName = true;
    protected boolean includeMDC = true;
    protected boolean includeLoggerName = true;
    protected boolean includeFormattedMessage = true;
    protected boolean includeMessage;
    protected boolean includeException = true;
    protected boolean includeContextName = true;
    private final List<JsonEncoderBase.Emitter<ILoggingEvent>> emitters = new ArrayList<JsonEncoderBase.Emitter<ILoggingEvent>>();

    public void writeMessage(DirectJson jsonWriter, ILoggingEvent event) {
        jsonWriter.writeStringValue(MESSAGE_ATTR_NAME, event.getMessage());
    }

    public void writeFormattedMessage(DirectJson jsonWriter, ILoggingEvent event) {
        jsonWriter.writeStringValue(FORMATTED_MESSAGE_ATTR_NAME, event.getFormattedMessage());
    }

    public void writeLogger(DirectJson jsonWriter, ILoggingEvent event) {
        jsonWriter.writeStringValue(LOGGER_ATTR_NAME, event.getLoggerName());
    }

    public void writeThreadName(DirectJson jsonWriter, ILoggingEvent event) {
        jsonWriter.writeStringValue(THREAD_ATTR_NAME, event.getThreadName());
    }

    public void writeLevel(DirectJson jsonWriter, ILoggingEvent event) {
        jsonWriter.writeStringValue(LEVEL_ATTR_NAME, event.getLevel().levelStr);
    }

    public void writeMarkers(DirectJson jsonWriter, ILoggingEvent event) {
        List<Marker> markers = event.getMarkerList();
        if (!markers.isEmpty()) {
            jsonWriter.openArray(MARKERS_ATTR_NAME);
            for (Marker marker : markers) {
                jsonWriter.writeString(marker.getName());
                jsonWriter.writeSep();
            }
            jsonWriter.closeArray();
            jsonWriter.writeSep();
        }
    }

    public void writeMdc(DirectJson jsonWriter, ILoggingEvent event) {
        Map<String, String> mdc = event.getMDCPropertyMap();
        if (!mdc.isEmpty()) {
            jsonWriter.openObject(MDC_ATTR_NAME);
            for (Map.Entry<String, String> entry : mdc.entrySet()) {
                jsonWriter.writeStringValue(entry.getKey(), entry.getValue());
            }
            jsonWriter.closeObject();
            jsonWriter.writeSep();
        }
    }

    private void buildEmitterList() {
        this.emitters.clear();
        if (this.includeLevel) {
            this.emitters.add(this::writeLevel);
        }
        if (this.includeMDC) {
            this.emitters.add(this::writeMdc);
        }
        if (this.includeMessage) {
            this.emitters.add(this::writeMessage);
        }
        if (this.includeFormattedMessage) {
            this.emitters.add(this::writeFormattedMessage);
        }
        if (this.includeThreadName) {
            this.emitters.add(this::writeThreadName);
        }
        if (this.includeLoggerName) {
            this.emitters.add(this::writeLogger);
        }
    }

    @Override
    public byte[] encode(ILoggingEvent event) {
        if (this.emitters.isEmpty()) {
            this.buildEmitterList();
        }
        DirectJson jsonWriter = new DirectJson();
        jsonWriter.openObject();
        for (JsonEncoderBase.Emitter<ILoggingEvent> emitter : this.emitters) {
            emitter.write(jsonWriter, event);
        }
        jsonWriter.closeObject();
        return jsonWriter.flush();
    }
}

