/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.service.impl;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.plugin.JpsPluginManager;
import org.jetbrains.jps.service.JpsServiceManager;

public final class JpsServiceManagerImpl
extends JpsServiceManager {
    private final ConcurrentMap<Class<?>, Object> myServices = new ConcurrentHashMap(16, 0.75f, 1);
    private final Map<Class<?>, List<?>> myExtensions = new HashMap();
    private final AtomicInteger myModificationStamp = new AtomicInteger(0);
    private JpsPluginManager myPluginManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getService(Class<T> serviceClass) {
        Object service = this.myServices.get(serviceClass);
        if (service == null) {
            ConcurrentMap<Class<?>, Object> concurrentMap = this.myServices;
            synchronized (concurrentMap) {
                service = this.myServices.get(serviceClass);
                if (service == null) {
                    Iterator<T> iterator2 = ServiceLoader.load(serviceClass, serviceClass.getClassLoader()).iterator();
                    if (!iterator2.hasNext()) {
                        throw new ServiceConfigurationError("Implementation for " + serviceClass + " not found");
                    }
                    T loadedService = iterator2.next();
                    if (iterator2.hasNext()) {
                        throw new ServiceConfigurationError("More than one implementation for " + serviceClass + " found: " + loadedService.getClass() + " and " + iterator2.next().getClass());
                    }
                    service = this.myServices.putIfAbsent(serviceClass, loadedService);
                    if (service == null) {
                        service = loadedService;
                    }
                }
            }
        }
        return (T)service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Iterable<T> getExtensions(Class<T> extensionClass) {
        Map<Class<?>, List<?>> map2 = this.myExtensions;
        synchronized (map2) {
            List<?> cached;
            List<?> list = cached = this.cleanupExtensionCache() ? null : this.myExtensions.get(extensionClass);
            if (cached == null) {
                cached = new ArrayList<T>(this.loadExtensions(extensionClass));
                this.myExtensions.put(extensionClass, cached);
            }
            return cached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public boolean cleanupExtensionCache() {
        Map<Class<?>, List<?>> map2 = this.myExtensions;
        synchronized (map2) {
            int stamp;
            JpsPluginManager manager = this.myPluginManager;
            if (manager != null && this.myModificationStamp.getAndSet(stamp = manager.getModificationStamp()) != stamp) {
                this.myExtensions.clear();
                return true;
            }
            return false;
        }
    }

    @NotNull
    private <T> Collection<T> loadExtensions(Class<T> extensionClass) {
        JpsPluginManager pluginManager = this.myPluginManager;
        if (pluginManager == null || !pluginManager.isFullyLoaded()) {
            Iterator<JpsPluginManager> managers = ServiceLoader.load(JpsPluginManager.class, JpsPluginManager.class.getClassLoader()).iterator();
            if (managers.hasNext()) {
                try {
                    pluginManager = managers.next();
                }
                catch (ServiceConfigurationError e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)cause;
                    }
                    throw e;
                }
                if (managers.hasNext()) {
                    throw new ServiceConfigurationError("More than one implementation of " + JpsPluginManager.class + " found: " + pluginManager.getClass() + " and " + managers.next().getClass());
                }
            } else {
                pluginManager = new SingleClassLoaderPluginManager();
            }
            this.myPluginManager = pluginManager;
        }
        Collection<T> collection = pluginManager.loadExtensions(extensionClass);
        if (collection == null) {
            JpsServiceManagerImpl.$$$reportNull$$$0(0);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/service/impl/JpsServiceManagerImpl", "loadExtensions"));
    }

    private static final class SingleClassLoaderPluginManager
    extends JpsPluginManager {
        private SingleClassLoaderPluginManager() {
        }

        @Override
        @NotNull
        public <T> Collection<T> loadExtensions(@NotNull Class<T> extensionClass) {
            if (extensionClass == null) {
                SingleClassLoaderPluginManager.$$$reportNull$$$0(0);
            }
            ServiceLoader<T> loader = ServiceLoader.load(extensionClass, extensionClass.getClassLoader());
            ArrayList<T> arrayList = ContainerUtil.newArrayList(loader);
            if (arrayList == null) {
                SingleClassLoaderPluginManager.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        @Override
        public boolean isFullyLoaded() {
            return true;
        }

        @Override
        public int getModificationStamp() {
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensionClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/service/impl/JpsServiceManagerImpl$SingleClassLoaderPluginManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/service/impl/JpsServiceManagerImpl$SingleClassLoaderPluginManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadExtensions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "loadExtensions";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

