/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.runConfigurations;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfigurationType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsRunConfigurationPropertiesSerializer;
import org.jetbrains.jps.model.serialization.runConfigurations.JpsUnknownRunConfigurationType;

public final class JpsRunConfigurationSerializer {
    private static final Logger LOG = Logger.getInstance(JpsRunConfigurationSerializer.class);

    public static void loadRunConfigurations(@NotNull JpsProject project, @Nullable Element runManagerTag) {
        List<Element> elements;
        if (project == null) {
            JpsRunConfigurationSerializer.$$$reportNull$$$0(0);
        }
        if ((elements = JDOMUtil.getChildren(runManagerTag, "configuration")).isEmpty()) {
            return;
        }
        HashMap serializers = new HashMap();
        for (JpsModelSerializerExtension extension : JpsModelSerializerExtension.getExtensions()) {
            for (JpsRunConfigurationPropertiesSerializer<?> jpsRunConfigurationPropertiesSerializer : extension.getRunConfigurationPropertiesSerializers()) {
                serializers.put(jpsRunConfigurationPropertiesSerializer.getTypeId(), jpsRunConfigurationPropertiesSerializer);
            }
        }
        for (Element configurationTag : elements) {
            if (Boolean.parseBoolean(configurationTag.getAttributeValue("default"))) continue;
            String typeId = configurationTag.getAttributeValue("type");
            JpsRunConfigurationPropertiesSerializer jpsRunConfigurationPropertiesSerializer = (JpsRunConfigurationPropertiesSerializer)serializers.get(typeId);
            String name = configurationTag.getAttributeValue("name");
            if (jpsRunConfigurationPropertiesSerializer != null) {
                JpsRunConfigurationSerializer.loadRunConfiguration(name, configurationTag, jpsRunConfigurationPropertiesSerializer, project);
                continue;
            }
            if (name == null) {
                LOG.info("Run configuration '" + JDOMUtil.write(configurationTag) + "' wasn't loaded because 'name' attribute is missing");
                continue;
            }
            if (typeId != null) {
                project.addRunConfiguration(name, new JpsUnknownRunConfigurationType(typeId), JpsElementFactory.getInstance().createDummyElement());
                continue;
            }
            LOG.info("Run configuration '" + name + "' wasn't loaded because 'type' attribute is missing");
        }
    }

    private static <P extends JpsElement> void loadRunConfiguration(String name, Element configurationTag, JpsRunConfigurationPropertiesSerializer<P> serializer, JpsProject project) {
        P properties2 = serializer.loadProperties(configurationTag);
        project.addRunConfiguration(name, (JpsRunConfigurationType)serializer.getType(), properties2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/runConfigurations/JpsRunConfigurationSerializer", "loadRunConfigurations"));
    }
}

