/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.internal;

import java.lang.reflect.Array;

public final class ArrayCopy {
    private ArrayCopy() {
    }

    public static final <E> E[] copyOf(E[] source2, int len) {
        Object[] dest = (Object[])Array.newInstance(source2.getClass().getComponentType(), len);
        System.arraycopy(source2, 0, dest, 0, len < source2.length ? len : source2.length);
        return dest;
    }

    public static final <E> E[] copyOfRange(E[] source2, int from, int to) {
        int len = to - from;
        if (len < 0) {
            throw new IllegalArgumentException("From(" + from + ") > To (" + to + ")");
        }
        Object[] dest = (Object[])Array.newInstance(source2.getClass().getComponentType(), len);
        int tocopy = from + len > source2.length ? source2.length - from : len;
        System.arraycopy(source2, from, dest, 0, tocopy);
        return dest;
    }

    public static final char[] copyOf(char[] source2, int len) {
        char[] dest = new char[len];
        System.arraycopy(source2, 0, dest, 0, len < source2.length ? len : source2.length);
        return dest;
    }

    public static final int[] copyOf(int[] source2, int len) {
        int[] dest = new int[len];
        System.arraycopy(source2, 0, dest, 0, len < source2.length ? len : source2.length);
        return dest;
    }

    public static final boolean[] copyOf(boolean[] source2, int len) {
        boolean[] dest = new boolean[len];
        System.arraycopy(source2, 0, dest, 0, len < source2.length ? len : source2.length);
        return dest;
    }
}

