/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.resolution;

import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.pluginverifier.verifiers.InheritanceUtilKt;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFileAsm;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodAsm;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodDescriptor;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodInClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0016\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007\u001a0\u0010\u001a\u001a\u0004\u0018\u00010\u0007*\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u001eH\u0002\u001a\u001a\u0010\u001f\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0012\u0010 \u001a\u00020\u000b*\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007\u001a\u0012\u0010 \u001a\u00020\u000b*\u00020!2\u0006\u0010\u0013\u001a\u00020\u0007\u001a\u000e\u0010\"\u001a\u00060\u0001j\u0002`\u0002*\u00020\u0007\u001a\u0018\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018\u001a,\u0010#\u001a\u00020&*\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020&0\u001e\u001a\u0012\u0010)\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`*\"\u0012\u0010\u0000\u001a\u00060\u0001j\u0002`\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t*\n\u0010+\"\u00020\u00012\u00020\u0001*\n\u0010,\"\u00020\u00012\u00020\u0001\u00a8\u0006-"}, d2={"JAVA_LANG_OBJECT", "", "Lcom/jetbrains/pluginverifier/verifiers/resolution/BinaryClassName;", "LOG", "Lorg/slf4j/Logger;", "visibilityRating", "", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "getVisibilityRating", "(Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;)I", "isCallOfSuperMethod", "", "callerMethod", "calledMethod", "instructionNode", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "nonStaticAndNonFinal", "anotherMethod", "sameName", "method", "sameOrBroaderVisibility", "sameOrCovariantReturnType", "possiblyParentMethod", "resolver", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "sameParameters", "findInSuperClass", "superClass", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFileAsm;", "isSuperClassMethod", "Lkotlin/Function2;", "isOverriding", "matches", "Lorg/objectweb/asm/tree/MethodInsnNode;", "returnType", "searchParentOverrides", "", "Lcom/jetbrains/pluginverifier/verifiers/resolution/MethodInClass;", "", "matchHandler", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "toBinaryClassName", "Lcom/jetbrains/pluginverifier/verifiers/resolution/FullyQualifiedClassName;", "BinaryClassName", "FullyQualifiedClassName", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nMethods.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Methods.kt\ncom/jetbrains/pluginverifier/verifiers/resolution/MethodsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1726#2,3:150\n*S KotlinDebug\n*F\n+ 1 Methods.kt\ncom/jetbrains/pluginverifier/verifiers/resolution/MethodsKt\n*L\n144#1:150,3\n*E\n"})
public final class MethodsKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";

    public static final boolean isOverriding(@NotNull Method $this$isOverriding, @NotNull Method possiblyParentMethod, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter($this$isOverriding, "<this>");
        Intrinsics.checkNotNullParameter(possiblyParentMethod, "possiblyParentMethod");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        return MethodsKt.sameName($this$isOverriding, possiblyParentMethod) && MethodsKt.nonStaticAndNonFinal(possiblyParentMethod) && MethodsKt.sameOrBroaderVisibility($this$isOverriding, possiblyParentMethod) && MethodsKt.sameParameters($this$isOverriding, possiblyParentMethod) && MethodsKt.sameOrCovariantReturnType($this$isOverriding, possiblyParentMethod, resolver);
    }

    private static final boolean nonStaticAndNonFinal(Method anotherMethod) {
        return !anotherMethod.isStatic() && !anotherMethod.isFinal();
    }

    private static final boolean sameName(Method method, Method anotherMethod) {
        return Intrinsics.areEqual(method.getName(), anotherMethod.getName());
    }

    private static final boolean sameOrBroaderVisibility(Method method, Method anotherMethod) {
        return MethodsKt.getVisibilityRating(method) >= MethodsKt.getVisibilityRating(anotherMethod);
    }

    private static final int getVisibilityRating(Method $this$visibilityRating) {
        return $this$visibilityRating.isPublic() ? 3 : ($this$visibilityRating.isProtected() ? 2 : ($this$visibilityRating.isPackagePrivate() ? 1 : ($this$visibilityRating.isPrivate() ? 0 : -1)));
    }

    @NotNull
    public static final List<MethodInClass> searchParentOverrides(@NotNull Method $this$searchParentOverrides, @NotNull Resolver resolver) {
        List list;
        Intrinsics.checkNotNullParameter($this$searchParentOverrides, "<this>");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        List $this$searchParentOverrides_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        MethodsKt.searchParentOverrides($this$searchParentOverrides, resolver, (Function2<? super ClassFile, ? super Method, Unit>)new Function2<ClassFile, Method, Unit>((List<MethodInClass>)$this$searchParentOverrides_u24lambda_u240){
            final /* synthetic */ List<MethodInClass> $this_apply;
            {
                this.$this_apply = $receiver;
                super(2);
            }

            public final void invoke(@NotNull ClassFile klass, @NotNull Method method) {
                Intrinsics.checkNotNullParameter(klass, "klass");
                Intrinsics.checkNotNullParameter(method, "method");
                if (!Intrinsics.areEqual(klass.getName(), "java/lang/Object")) {
                    this.$this_apply.add(new MethodInClass(method, klass));
                }
            }
        });
        return list;
    }

    public static final void searchParentOverrides(@NotNull Method $this$searchParentOverrides, @NotNull Resolver resolver, @NotNull Function2<? super ClassFile, ? super Method, Unit> matchHandler) {
        Intrinsics.checkNotNullParameter($this$searchParentOverrides, "<this>");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Intrinsics.checkNotNullParameter(matchHandler, "matchHandler");
        String string2 = $this$searchParentOverrides.getContainingClassFile().getSuperName();
        if (string2 == null) {
            return;
        }
        String superClassFqn = string2;
        ResolutionResult<ClassNode> resolvedClass;
        while ((resolvedClass = resolver.resolveClass(superClassFqn)) instanceof ResolutionResult.Found) {
            ClassFileAsm superClass = new ClassFileAsm((ClassNode)((ResolutionResult.Found)resolvedClass).getValue(), ((ResolutionResult.Found)resolvedClass).getFileOrigin());
            Method overridableMethodInParent2 = MethodsKt.findInSuperClass($this$searchParentOverrides, superClass, (Function2<? super Method, ? super Method, Boolean>)new Function2<Method, Method, Boolean>(resolver){
                final /* synthetic */ Resolver $resolver;
                {
                    this.$resolver = $resolver;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull Method child, @NotNull Method parent) {
                    Intrinsics.checkNotNullParameter(child, "child");
                    Intrinsics.checkNotNullParameter(parent, "parent");
                    return MethodsKt.isOverriding(child, parent, this.$resolver);
                }
            });
            if (overridableMethodInParent2 != null) {
                Method overriddenMethod;
                boolean bl = false;
                matchHandler.invoke(superClass, overriddenMethod);
            }
            if (superClass.getSuperName() != null) continue;
            return;
        }
        return;
    }

    private static final Method findInSuperClass(Method $this$findInSuperClass, ClassFileAsm superClass, Function2<? super Method, ? super Method, Boolean> isSuperClassMethod) {
        Method method;
        List<MethodAsm> superClassMethodCandidates2 = SequencesKt.toList(SequencesKt.filter(superClass.getMethods(), (Function1)new Function1<MethodAsm, Boolean>(isSuperClassMethod, $this$findInSuperClass){
            final /* synthetic */ Function2<Method, Method, Boolean> $isSuperClassMethod;
            final /* synthetic */ Method $this_findInSuperClass;
            {
                this.$isSuperClassMethod = $isSuperClassMethod;
                this.$this_findInSuperClass = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MethodAsm superMethod) {
                Intrinsics.checkNotNullParameter(superMethod, "superMethod");
                return this.$isSuperClassMethod.invoke(this.$this_findInSuperClass, superMethod);
            }
        }));
        if (superClassMethodCandidates2.isEmpty()) {
            method = null;
        } else if (superClassMethodCandidates2.size() == 1) {
            method = CollectionsKt.first(superClassMethodCandidates2);
        } else {
            LOG.debug("Too many candidates for discovering overridden method in superclass for " + $this$findInSuperClass.getName());
            method = null;
        }
        return method;
    }

    public static final boolean isCallOfSuperMethod(@NotNull Method callerMethod, @NotNull Method calledMethod, @NotNull AbstractInsnNode instructionNode) {
        Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
        Intrinsics.checkNotNullParameter(calledMethod, "calledMethod");
        Intrinsics.checkNotNullParameter(instructionNode, "instructionNode");
        return Intrinsics.areEqual(callerMethod.getName(), calledMethod.getName()) && Intrinsics.areEqual(callerMethod.getDescriptor(), calledMethod.getDescriptor()) && instructionNode.getOpcode() == 183;
    }

    public static final boolean matches(@NotNull Method $this$matches, @NotNull Method method) {
        Intrinsics.checkNotNullParameter($this$matches, "<this>");
        Intrinsics.checkNotNullParameter(method, "method");
        return Intrinsics.areEqual(new MethodDescriptor($this$matches.getName(), $this$matches.getDescriptor()), new MethodDescriptor(method.getName(), method.getDescriptor()));
    }

    public static final boolean matches(@NotNull MethodInsnNode $this$matches, @NotNull Method method) {
        Intrinsics.checkNotNullParameter($this$matches, "<this>");
        Intrinsics.checkNotNullParameter(method, "method");
        String string2 = $this$matches.name;
        Intrinsics.checkNotNullExpressionValue(string2, "name");
        String string3 = $this$matches.desc;
        Intrinsics.checkNotNullExpressionValue(string3, "desc");
        return Intrinsics.areEqual(new MethodDescriptor(string2, string3), new MethodDescriptor(method.getName(), method.getDescriptor()));
    }

    @NotNull
    public static final String returnType(@NotNull Method $this$returnType) {
        Intrinsics.checkNotNullParameter($this$returnType, "<this>");
        Type type2 = Type.getReturnType($this$returnType.getDescriptor());
        Intrinsics.checkNotNullExpressionValue(type2, "getReturnType(this.descriptor)");
        Type returnType = type2;
        String string2 = returnType.getClassName();
        Intrinsics.checkNotNullExpressionValue(string2, "returnType.className");
        return MethodsKt.toBinaryClassName(string2);
    }

    public static final boolean sameOrCovariantReturnType(@NotNull Method method, @NotNull Method possiblyParentMethod, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(possiblyParentMethod, "possiblyParentMethod");
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        String returnType = MethodsKt.returnType(method);
        String possibleParentReturnType = MethodsKt.returnType(possiblyParentMethod);
        return InheritanceUtilKt.isSubclassOrSelf(resolver, returnType, possibleParentReturnType);
    }

    public static final boolean sameParameters(@NotNull Method method, @NotNull Method anotherMethod) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(method, "method");
            Intrinsics.checkNotNullParameter(anotherMethod, "anotherMethod");
            Type[] typeArray = Type.getArgumentTypes(method.getDescriptor());
            Intrinsics.checkNotNullExpressionValue(typeArray, "getArgumentTypes(method.descriptor)");
            Type[] argTypes = typeArray;
            Type[] typeArray2 = Type.getArgumentTypes(anotherMethod.getDescriptor());
            Intrinsics.checkNotNullExpressionValue(typeArray2, "getArgumentTypes(anotherMethod.descriptor)");
            Type[] anotherArgTypes = typeArray2;
            if (argTypes.length != anotherArgTypes.length) {
                return false;
            }
            Iterable $this$all$iv = ArraysKt.getIndices(argTypes);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int index = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (Intrinsics.areEqual(argTypes[index], anotherArgTypes[index])) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public static final String toBinaryClassName(@NotNull String $this$toBinaryClassName) {
        Intrinsics.checkNotNullParameter($this$toBinaryClassName, "<this>");
        return StringsKt.replace$default($this$toBinaryClassName, '.', '/', false, 4, null);
    }

    static {
        Logger logger = LoggerFactory.getLogger(Method.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(Method::class.java)");
        LOG = logger;
    }
}

