/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.resolution;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.results.access.AccessType;
import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.modifiers.Modifiers;
import com.jetbrains.pluginverifier.verifiers.BytecodeUtilKt;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00150\f*\u00020\u0005H\u0002R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00150\u00150\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u0014\u0010!\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010 R\u0014\u0010\"\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010 R\u0014\u0010$\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010 R\u0014\u0010%\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010 R\u0014\u0010&\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010 R\u0014\u0010'\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010 R\u0014\u0010(\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010 R\u0014\u0010)\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010 R\u0014\u0010*\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010 R\u0014\u0010+\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010 R\u0014\u0010,\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010 R\u0014\u0010-\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010 R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u000fR\u0014\u00101\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u001a\u00105\u001a\b\u0012\u0004\u0012\u0002060\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u000fR\u0014\u00108\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010\u0017R\u0016\u0010:\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010\u0017R\"\u0010<\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010=0=0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u000f\u00a8\u0006@"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/resolution/MethodAsm;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "containingClassFile", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "asmNode", "Lorg/objectweb/asm/tree/MethodNode;", "(Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;Lorg/objectweb/asm/tree/MethodNode;)V", "accessType", "Lcom/jetbrains/pluginverifier/results/access/AccessType;", "getAccessType", "()Lcom/jetbrains/pluginverifier/results/access/AccessType;", "annotations", "", "Lorg/objectweb/asm/tree/AnnotationNode;", "getAnnotations", "()Ljava/util/List;", "getAsmNode", "()Lorg/objectweb/asm/tree/MethodNode;", "getContainingClassFile", "()Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "descriptor", "", "getDescriptor", "()Ljava/lang/String;", "exceptions", "kotlin.jvm.PlatformType", "getExceptions", "instructions", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "getInstructions", "isAbstract", "", "()Z", "isBridgeMethod", "isClassInitializer", "isConstructor", "isDeprecated", "isFinal", "isNative", "isPackagePrivate", "isPrivate", "isProtected", "isPublic", "isStatic", "isSynthetic", "isVararg", "localVariables", "Lorg/objectweb/asm/tree/LocalVariableNode;", "getLocalVariables", "location", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "getLocation", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "methodParameters", "Lcom/jetbrains/pluginverifier/verifiers/resolution/MethodParameter;", "getMethodParameters", "name", "getName", "signature", "getSignature", "tryCatchBlocks", "Lorg/objectweb/asm/tree/TryCatchBlockNode;", "getTryCatchBlocks", "getParameterNames", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nMethodAsm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MethodAsm.kt\ncom/jetbrains/pluginverifier/verifiers/resolution/MethodAsm\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,144:1\n1549#2:145\n1620#2,3:146\n1559#2:152\n1590#2,4:153\n1559#2:157\n1590#2,4:158\n1549#2:162\n1620#2,3:163\n1045#2:166\n1726#2,3:167\n1549#2:170\n1620#2,3:171\n1549#2:174\n1620#2,3:175\n1#3:149\n18#4:150\n26#5:151\n*S KotlinDebug\n*F\n+ 1 MethodAsm.kt\ncom/jetbrains/pluginverifier/verifiers/resolution/MethodAsm\n*L\n24#1:145\n24#1:146,3\n54#1:152\n54#1:153,4\n61#1:157\n61#1:158,4\n67#1:162\n67#1:163,3\n127#1:166\n135#1:167,3\n137#1:170\n137#1:171,3\n141#1:174\n141#1:175,3\n50#1:150\n50#1:151\n*E\n"})
public final class MethodAsm
implements Method {
    @NotNull
    private final ClassFile containingClassFile;
    @NotNull
    private final MethodNode asmNode;

    public MethodAsm(@NotNull ClassFile containingClassFile, @NotNull MethodNode asmNode) {
        Intrinsics.checkNotNullParameter(containingClassFile, "containingClassFile");
        Intrinsics.checkNotNullParameter(asmNode, "asmNode");
        this.containingClassFile = containingClassFile;
        this.asmNode = asmNode;
    }

    @Override
    @NotNull
    public ClassFile getContainingClassFile() {
        return this.containingClassFile;
    }

    @NotNull
    public final MethodNode getAsmNode() {
        return this.asmNode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MethodLocation getLocation() {
        String string2;
        Collection<String> collection;
        String $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.getMethodParameters();
        String string3 = this.getDescriptor();
        String string4 = this.getName();
        ClassLocation classLocation = this.getContainingClassFile().getLocation();
        boolean $i$f$map = false;
        void var3_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv = iterator2.next();
            MethodParameter methodParameter = (MethodParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        ClassLocation classLocation2 = classLocation;
        String string5 = string4;
        String string6 = string3;
        Collection<String> collection2 = collection;
        String string7 = this.getSignature();
        if (string7 != null) {
            void it;
            String string8;
            $this$mapTo$iv$iv = string8 = string7;
            collection = collection2;
            string3 = string6;
            string4 = string5;
            classLocation = classLocation2;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            classLocation2 = classLocation;
            string5 = string4;
            string6 = string3;
            collection2 = collection;
            string2 = bl2 ? string8 : null;
        } else {
            string2 = null;
        }
        Modifiers modifiers = new Modifiers(this.asmNode.access);
        String string9 = string2;
        Collection<String> collection3 = collection2;
        String string10 = string6;
        String string11 = string5;
        ClassLocation classLocation3 = classLocation2;
        return new MethodLocation(classLocation3, string11, string10, (List<String>)collection3, string9, modifiers);
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.asmNode.name;
        Intrinsics.checkNotNullExpressionValue(string2, "asmNode.name");
        return string2;
    }

    @Override
    @NotNull
    public String getDescriptor() {
        String string2 = this.asmNode.desc;
        Intrinsics.checkNotNullExpressionValue(string2, "asmNode.desc");
        return string2;
    }

    @Override
    @NotNull
    public AccessType getAccessType() {
        return BytecodeUtilKt.getAccessType(this.asmNode.access);
    }

    @Override
    @Nullable
    public String getSignature() {
        return this.asmNode.signature;
    }

    @Override
    @NotNull
    public List<AnnotationNode> getAnnotations() {
        List<AnnotationNode> list = this.asmNode.invisibleAnnotations;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Collection collection = list;
        List<AnnotationNode> list2 = this.asmNode.visibleAnnotations;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus(collection, (Iterable)list2);
    }

    @Override
    @NotNull
    public List<LocalVariableNode> getLocalVariables() {
        List<LocalVariableNode> list = this.asmNode.localVariables;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<MethodParameter> getMethodParameters() {
        void $this$mapTo$iv$iv;
        boolean $i$f$mapIndexed;
        Iterable $this$mapIndexed$iv;
        List<String> parameterNames = this.getParameterNames(this.asmNode);
        List<AnnotationNode>[] $this$orEmpty$iv = this.asmNode.invisibleParameterAnnotations;
        boolean $i$f$orEmpty = false;
        List<AnnotationNode>[] listArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            boolean $i$f$emptyArray = false;
            listArray = new List[]{};
        }
        List<AnnotationNode>[] parameterAnnotations = listArray;
        if (parameterNames.size() == parameterAnnotations.length) {
            void $this$mapIndexedTo$iv$iv;
            $this$mapIndexed$iv = parameterNames;
            $i$f$mapIndexed = false;
            Iterable $i$f$emptyArray = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void parameterName;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string2 = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                List<AnnotationNode> list = parameterAnnotations[index];
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                collection.add(new MethodParameter((String)parameterName, list));
            }
            return (List)destination$iv$iv;
        }
        if (Intrinsics.areEqual(this.getName(), "<init>") && this.getContainingClassFile().isInnerClass() && parameterNames.size() == parameterAnnotations.length + 1) {
            $this$mapIndexed$iv = parameterNames;
            $i$f$mapIndexed = false;
            Iterable $this$mapIndexedTo$iv$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
                List<AnnotationNode> list;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String parameterName = (String)item$iv$iv2;
                int index = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string3 = parameterName;
                List<AnnotationNode>[] listArray2 = parameterAnnotations;
                int n3 = index - 1;
                if (n3 >= 0 && n3 <= ArraysKt.getLastIndex(listArray2)) {
                    list = listArray2[n3];
                } else {
                    int n4 = n3;
                    String string4 = string3;
                    boolean bl2 = false;
                    list = CollectionsKt.emptyList();
                    string3 = string4;
                }
                List<AnnotationNode> list2 = list;
                if (list == null) {
                    list2 = CollectionsKt.emptyList();
                }
                List<AnnotationNode> list3 = list2;
                String string5 = string3;
                collection.add(new MethodParameter(string5, list3));
            }
            return (List)destination$iv$iv;
        }
        Iterable $this$map$iv = parameterNames;
        boolean $i$f$map = false;
        Iterable $this$mapIndexedTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void parameterName;
            String item$iv$iv2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new MethodParameter((String)parameterName, CollectionsKt.emptyList()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<String> getExceptions() {
        List<String> list = this.asmNode.exceptions;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<TryCatchBlockNode> getTryCatchBlocks() {
        List<TryCatchBlockNode> list = this.asmNode.tryCatchBlocks;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<AbstractInsnNode> getInstructions() {
        Iterator iterator2 = this.asmNode.instructions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "asmNode.instructions.iterator()");
        return LanguageUtilsKt.toList(iterator2);
    }

    @Override
    public boolean isAbstract() {
        return (this.asmNode.access & 0x400) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.asmNode.access & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.asmNode.access & 0x10) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.asmNode.access & 1) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.asmNode.access & 4) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.asmNode.access & 2) != 0;
    }

    @Override
    public boolean isPackagePrivate() {
        return (this.asmNode.access & 1) == 0 && (this.asmNode.access & 4) == 0 && (this.asmNode.access & 2) == 0;
    }

    @Override
    public boolean isDeprecated() {
        return (this.asmNode.access & 0x20000) != 0;
    }

    @Override
    public boolean isVararg() {
        return (this.asmNode.access & 0x80) != 0;
    }

    @Override
    public boolean isConstructor() {
        return Intrinsics.areEqual(this.asmNode.name, "<init>");
    }

    @Override
    public boolean isClassInitializer() {
        return Intrinsics.areEqual(this.asmNode.name, "<clinit>");
    }

    @Override
    public boolean isNative() {
        return (this.asmNode.access & 0x100) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.asmNode.access & 0x1000) != 0;
    }

    @Override
    public boolean isBridgeMethod() {
        return (this.asmNode.access & 0x40) != 0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getParameterNames(MethodNode $this$getParameterNames) {
        void $this$mapTo$iv$iv;
        int n;
        Type[] descriptorArguments = Type.getArgumentTypes($this$getParameterNames.desc);
        int descriptorArgumentsNumber = descriptorArguments.length;
        if ($this$getParameterNames.localVariables != null) {
            List parameters2;
            List<LocalVariableNode> list = $this$getParameterNames.localVariables;
            Intrinsics.checkNotNullExpressionValue(list, "localVariables");
            Iterable $this$sortedBy$iv = list;
            boolean $i$f$sortedBy = false;
            List allLocalVars = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    LocalVariableNode it = (LocalVariableNode)a;
                    boolean bl = false;
                    it = (LocalVariableNode)b;
                    Comparable comparable = Integer.valueOf(it.index);
                    bl = false;
                    return ComparisonsKt.compareValues(comparable, it.index);
                }
            });
            List list2 = parameters2 = ($this$getParameterNames.access & 8) != 0 ? CollectionsKt.take(allLocalVars, descriptorArgumentsNumber) : CollectionsKt.take(CollectionsKt.drop(allLocalVars, 1), descriptorArgumentsNumber);
            if (parameters2.size() == descriptorArgumentsNumber) {
                Object object;
                boolean bl;
                block8: {
                    Iterable $this$all$iv = CollectionsKt.getIndices(parameters2);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        object = $this$all$iv.iterator();
                        while (object.hasNext()) {
                            int element$iv;
                            int index = element$iv = ((IntIterator)object).nextInt();
                            n = 0;
                            Type type2 = descriptorArguments[index];
                            if (Intrinsics.areEqual(((LocalVariableNode)parameters2.get((int)index)).desc, type2 != null ? type2.getDescriptor() : null)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv2 = parameters2;
                    boolean $i$f$map = false;
                    object = $this$map$iv2;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it;
                        LocalVariableNode localVariableNode = (LocalVariableNode)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(it.name);
                    }
                    return (List)destination$iv$iv;
                }
            }
        }
        Iterable $this$map$iv = RangesKt.until(0, descriptorArgumentsNumber);
        boolean $i$f$map = false;
        Iterable $this$map$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("arg" + (int)it);
        }
        return (List)destination$iv$iv;
    }
}

