/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.experimental;

import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import com.jetbrains.pluginverifier.results.reference.FieldReference;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import com.jetbrains.pluginverifier.usages.FilteringApiUsageProcessor;
import com.jetbrains.pluginverifier.usages.SameOriginApiUsageFilter;
import com.jetbrains.pluginverifier.usages.experimental.ExperimentalApiRegistrar;
import com.jetbrains.pluginverifier.usages.experimental.ExperimentalApiUsageKt;
import com.jetbrains.pluginverifier.usages.experimental.ExperimentalClassUsage;
import com.jetbrains.pluginverifier.usages.experimental.ExperimentalFieldUsage;
import com.jetbrains.pluginverifier.usages.experimental.ExperimentalMethodUsage;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFileMember;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassUsageType;
import com.jetbrains.pluginverifier.verifiers.resolution.Field;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J(\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J0\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/pluginverifier/usages/experimental/ExperimentalApiUsageProcessor;", "Lcom/jetbrains/pluginverifier/usages/FilteringApiUsageProcessor;", "experimentalApiRegistrar", "Lcom/jetbrains/pluginverifier/usages/experimental/ExperimentalApiRegistrar;", "(Lcom/jetbrains/pluginverifier/usages/experimental/ExperimentalApiRegistrar;)V", "doProcessClassReference", "", "classReference", "Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "resolvedClass", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "referrer", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFileMember;", "classUsageType", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassUsageType;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "doProcessFieldAccess", "fieldReference", "Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "resolvedField", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Field;", "callerMethod", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "doProcessMethodInvocation", "invokedMethodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "invokedMethod", "invocationInstruction", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "isExperimental", "", "resolvedMember", "usageLocation", "Lcom/jetbrains/pluginverifier/results/location/Location;", "verifier-intellij"})
public final class ExperimentalApiUsageProcessor
extends FilteringApiUsageProcessor {
    @NotNull
    private final ExperimentalApiRegistrar experimentalApiRegistrar;

    public ExperimentalApiUsageProcessor(@NotNull ExperimentalApiRegistrar experimentalApiRegistrar) {
        Intrinsics.checkNotNullParameter(experimentalApiRegistrar, "experimentalApiRegistrar");
        super(new SameOriginApiUsageFilter());
        this.experimentalApiRegistrar = experimentalApiRegistrar;
    }

    private final boolean isExperimental(ClassFileMember resolvedMember, VerificationContext context, Location usageLocation) {
        return ExperimentalApiUsageKt.isExperimentalApi(resolvedMember, context.getClassResolver(), usageLocation);
    }

    @Override
    protected void doProcessClassReference(@NotNull ClassReference classReference, @NotNull ClassFile resolvedClass, @NotNull ClassFileMember referrer, @NotNull ClassUsageType classUsageType, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(classReference, "classReference");
        Intrinsics.checkNotNullParameter(resolvedClass, "resolvedClass");
        Intrinsics.checkNotNullParameter(referrer, "referrer");
        Intrinsics.checkNotNullParameter((Object)classUsageType, "classUsageType");
        Intrinsics.checkNotNullParameter(context, "context");
        Location usageLocation = referrer.getLocation();
        if (this.isExperimental(resolvedClass, context, usageLocation)) {
            this.experimentalApiRegistrar.registerExperimentalApiUsage(new ExperimentalClassUsage(classReference, resolvedClass.getLocation(), usageLocation));
        }
    }

    @Override
    protected void doProcessMethodInvocation(@NotNull MethodReference invokedMethodReference, @NotNull Method invokedMethod, @NotNull AbstractInsnNode invocationInstruction, @NotNull Method callerMethod, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(invokedMethodReference, "invokedMethodReference");
        Intrinsics.checkNotNullParameter(invokedMethod, "invokedMethod");
        Intrinsics.checkNotNullParameter(invocationInstruction, "invocationInstruction");
        Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
        Intrinsics.checkNotNullParameter(context, "context");
        MethodLocation usageLocation = callerMethod.getLocation();
        if (this.isExperimental(invokedMethod, context, usageLocation)) {
            this.experimentalApiRegistrar.registerExperimentalApiUsage(new ExperimentalMethodUsage(invokedMethodReference, invokedMethod.getLocation(), usageLocation));
        }
    }

    @Override
    protected void doProcessFieldAccess(@NotNull FieldReference fieldReference, @NotNull Field resolvedField, @NotNull Method callerMethod, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(fieldReference, "fieldReference");
        Intrinsics.checkNotNullParameter(resolvedField, "resolvedField");
        Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
        Intrinsics.checkNotNullParameter(context, "context");
        MethodLocation usageLocation = callerMethod.getLocation();
        if (this.isExperimental(resolvedField, context, usageLocation)) {
            this.experimentalApiRegistrar.registerExperimentalApiUsage(new ExperimentalFieldUsage(fieldReference, resolvedField.getLocation(), callerMethod.getLocation()));
        }
    }
}

