/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0014\u0010\u0013\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/InvokeInterfaceOnPrivateMethodProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "methodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "resolvedMethod", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "caller", "(Lcom/jetbrains/pluginverifier/results/reference/MethodReference;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;)V", "getCaller", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "getMethodReference", "()Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "problemType", "getProblemType", "getResolvedMethod", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class InvokeInterfaceOnPrivateMethodProblem
extends CompatibilityProblem {
    @NotNull
    private final MethodReference methodReference;
    @NotNull
    private final MethodLocation resolvedMethod;
    @NotNull
    private final MethodLocation caller;

    public InvokeInterfaceOnPrivateMethodProblem(@NotNull MethodReference methodReference, @NotNull MethodLocation resolvedMethod, @NotNull MethodLocation caller2) {
        Intrinsics.checkNotNullParameter(methodReference, "methodReference");
        Intrinsics.checkNotNullParameter(resolvedMethod, "resolvedMethod");
        Intrinsics.checkNotNullParameter(caller2, "caller");
        this.methodReference = methodReference;
        this.resolvedMethod = resolvedMethod;
        this.caller = caller2;
    }

    @NotNull
    public final MethodReference getMethodReference() {
        return this.methodReference;
    }

    @NotNull
    public final MethodLocation getResolvedMethod() {
        return this.resolvedMethod;
    }

    @NotNull
    public final MethodLocation getCaller() {
        return this.caller;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Illegal private method invocation";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.resolvedMethod};
        return FormatUtilsKt.formatMessage("Attempt to execute an *invokeinterface* instruction on a private method {0}", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        Object[] objectArray = new Object[]{this.caller, this.resolvedMethod};
        return FormatUtilsKt.formatMessage("Method {0} contains an *invokeinterface* instruction referencing a private method {1}. This can lead to **IncompatibleClassChangeError** exception at runtime.", objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof InvokeInterfaceOnPrivateMethodProblem && Intrinsics.areEqual(this.methodReference, ((InvokeInterfaceOnPrivateMethodProblem)other).methodReference) && Intrinsics.areEqual(this.resolvedMethod, ((InvokeInterfaceOnPrivateMethodProblem)other).resolvedMethod) && Intrinsics.areEqual(this.caller, ((InvokeInterfaceOnPrivateMethodProblem)other).caller);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.methodReference, this.resolvedMethod, this.caller};
        return Objects.hash(objectArray);
    }
}

