/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.hierarchy.ClassHierarchy;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.presentation.FieldTypeOption;
import com.jetbrains.pluginverifier.results.presentation.HierarchicalProblemsDescription;
import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterNameOption;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterTypeOption;
import com.jetbrains.pluginverifier.results.presentation.MethodReturnTypeOption;
import com.jetbrains.pluginverifier.results.presentation.ReferencesPresentationKt;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.FieldReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0010R\u0014\u0010\u0019\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/FieldNotFoundProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "unresolvedField", "Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "accessor", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "fieldOwnerHierarchy", "Lcom/jetbrains/pluginverifier/results/hierarchy/ClassHierarchy;", "instruction", "Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "(Lcom/jetbrains/pluginverifier/results/reference/FieldReference;Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/hierarchy/ClassHierarchy;Lcom/jetbrains/pluginverifier/results/instruction/Instruction;)V", "getAccessor", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "descriptionMainPart", "", "getDescriptionMainPart", "()Ljava/lang/String;", "getFieldOwnerHierarchy", "()Lcom/jetbrains/pluginverifier/results/hierarchy/ClassHierarchy;", "fullDescription", "getFullDescription", "getInstruction", "()Lcom/jetbrains/pluginverifier/results/instruction/Instruction;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "getUnresolvedField", "()Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class FieldNotFoundProblem
extends CompatibilityProblem {
    @NotNull
    private final FieldReference unresolvedField;
    @NotNull
    private final MethodLocation accessor;
    @NotNull
    private final ClassHierarchy fieldOwnerHierarchy;
    @NotNull
    private final Instruction instruction;

    public FieldNotFoundProblem(@NotNull FieldReference unresolvedField, @NotNull MethodLocation accessor, @NotNull ClassHierarchy fieldOwnerHierarchy, @NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter(unresolvedField, "unresolvedField");
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        Intrinsics.checkNotNullParameter(fieldOwnerHierarchy, "fieldOwnerHierarchy");
        Intrinsics.checkNotNullParameter((Object)instruction, "instruction");
        this.unresolvedField = unresolvedField;
        this.accessor = accessor;
        this.fieldOwnerHierarchy = fieldOwnerHierarchy;
        this.instruction = instruction;
    }

    @NotNull
    public final FieldReference getUnresolvedField() {
        return this.unresolvedField;
    }

    @NotNull
    public final MethodLocation getAccessor() {
        return this.accessor;
    }

    @NotNull
    public final ClassHierarchy getFieldOwnerHierarchy() {
        return this.fieldOwnerHierarchy;
    }

    @NotNull
    public final Instruction getInstruction() {
        return this.instruction;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Field not found";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.unresolvedField};
        return FormatUtilsKt.formatMessage("Access to unresolved field {0}", objectArray);
    }

    private final String getDescriptionMainPart() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_descriptionMainPart__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Object[] objectArray = new Object[]{LocationsPresentationKt.formatMethodLocation(this.accessor, HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.FULL_PARAM_CLASS_NAME, MethodReturnTypeOption.FULL_RETURN_TYPE_CLASS_NAME, MethodParameterNameOption.WITH_PARAM_NAMES_IF_AVAILABLE), this.instruction, ReferencesPresentationKt.formatFieldReference(this.unresolvedField, HostClassOption.FULL_HOST_NAME, FieldTypeOption.FULL_TYPE)};
        $this$_get_descriptionMainPart__u24lambda_u240.append(FormatUtilsKt.formatMessage("Method {0} contains a *{1}* instruction referencing an unresolved field {2}. ", objectArray));
        $this$_get_descriptionMainPart__u24lambda_u240.append("This can lead to **NoSuchFieldError** exception at runtime.");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Override
    @NotNull
    public String getFullDescription() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_fullDescription__u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_fullDescription__u24lambda_u241.append(this.getDescriptionMainPart());
        boolean canBeDeclaredInSuperInterface = this.instruction == Instruction.GET_STATIC || this.instruction == Instruction.PUT_STATIC;
        String hint = HierarchicalProblemsDescription.INSTANCE.presentableElementMightHaveBeenDeclaredInSuperTypes("field", this.fieldOwnerHierarchy, true, canBeDeclaredInSuperInterface);
        if (((CharSequence)hint).length() > 0) {
            Intrinsics.checkNotNullExpressionValue($this$_get_fullDescription__u24lambda_u241.append('\n'), "append('\\n')");
            $this$_get_fullDescription__u24lambda_u241.append(hint);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof FieldNotFoundProblem && Intrinsics.areEqual(this.unresolvedField, ((FieldNotFoundProblem)other).unresolvedField) && Intrinsics.areEqual(this.accessor, ((FieldNotFoundProblem)other).accessor) && this.instruction == ((FieldNotFoundProblem)other).instruction;
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.unresolvedField, this.accessor, this.instruction};
        return Objects.hash(objectArray);
    }
}

