/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/ClassNotFoundProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "unresolved", "Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "usage", "Lcom/jetbrains/pluginverifier/results/location/Location;", "(Lcom/jetbrains/pluginverifier/results/reference/ClassReference;Lcom/jetbrains/pluginverifier/results/location/Location;)V", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "getUnresolved", "()Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "getUsage", "()Lcom/jetbrains/pluginverifier/results/location/Location;", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class ClassNotFoundProblem
extends CompatibilityProblem {
    @NotNull
    private final ClassReference unresolved;
    @NotNull
    private final Location usage;

    public ClassNotFoundProblem(@NotNull ClassReference unresolved, @NotNull Location usage2) {
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        Intrinsics.checkNotNullParameter(usage2, "usage");
        this.unresolved = unresolved;
        this.usage = usage2;
    }

    @NotNull
    public final ClassReference getUnresolved() {
        return this.unresolved;
    }

    @NotNull
    public final Location getUsage() {
        return this.usage;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Class not found";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        Object[] objectArray = new Object[]{this.unresolved};
        return FormatUtilsKt.formatMessage("Access to unresolved class {0}", objectArray);
    }

    @Override
    @NotNull
    public String getFullDescription() {
        String elementType = StringsKt.capitalize(this.usage.getElementType().getPresentableName());
        Object[] objectArray = new Object[]{elementType, this.usage, this.unresolved};
        return FormatUtilsKt.formatMessage("{0} {1} references an unresolved class {2}. This can lead to **NoSuchClassError** exception at runtime.", objectArray);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof ClassNotFoundProblem && Intrinsics.areEqual(this.unresolved, ((ClassNotFoundProblem)other).unresolved) && Intrinsics.areEqual(this.usage, ((ClassNotFoundProblem)other).usage);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.unresolved, this.usage};
        return Objects.hash(objectArray);
    }
}

