/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.repositories.marketplace;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.repository.repositories.marketplace.MarketplaceRepository;
import com.jetbrains.pluginverifier.repository.repositories.marketplace.UpdateInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginManager;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryFactory;
import org.jetbrains.intellij.pluginRepository.model.IntellijUpdateMetadata;
import org.jetbrains.intellij.pluginRepository.model.PluginBean;
import org.jetbrains.intellij.pluginRepository.model.PluginUpdateBean;
import org.jetbrains.intellij.pluginRepository.model.UpdateBean;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\r\u0018\u0000 62\u00020\u0001:\u00016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\u0006\u0010\"\u001a\u00020#H\u0016J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0010J\u001a\u0010%\u001a\u0004\u0018\u00010\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J\u001a\u0010&\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bH\u0002J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u001a\u001a\u00020\u0010J\u0010\u0010(\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001f\u001a\u00020\bJ,\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0*2\u0018\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00070\u001cJ \u0010,\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0*2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\b0\u001cJ\u0017\u0010.\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010/J \u00100\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\u0006\u00101\u001a\u00020\u00102\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0014\u00102\u001a\u0004\u0018\u00010\u00032\b\u00103\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u00104\u001a\u00020\u0010H\u0016J\u0010\u00105\u001a\u0004\u0018\u00010#*\u0004\u0018\u00010\u0010H\u0002R4\u0010\u0005\u001a(\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\bj\u0002`\t\u0012\b\u0012\u00060\bj\u0002`\n0\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository;", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "repositoryURL", "Ljava/net/URL;", "(Ljava/net/URL;)V", "metadataCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lkotlin/Pair;", "", "Lorg/jetbrains/intellij/pluginRepository/model/PluginId;", "Lorg/jetbrains/intellij/pluginRepository/model/UpdateId;", "Ljava/util/Optional;", "Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/UpdateInfo;", "pluginRepositoryInstance", "Lorg/jetbrains/intellij/pluginRepository/PluginRepository;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "getRepositoryURL", "()Ljava/net/URL;", "updateIdToPluginIdMapping", "Ljava/util/concurrent/ConcurrentHashMap;", "createAndCacheUpdateInfo", "metadata", "Lorg/jetbrains/intellij/pluginRepository/model/IntellijUpdateMetadata;", "pluginId", "getAllVersionsOfPlugin", "", "getBrowserUrl", "getCachedInfo", "updateId", "getDownloadUrl", "getLastCompatiblePlugins", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "channel", "getLastCompatibleVersionOfPlugin", "getOrRequestInfo", "getPluginChannels", "getPluginInfoByUpdateId", "getPluginInfosForManyPluginIdsAndUpdateIds", "", "pluginAndUpdateIds", "getPluginInfosForManyUpdateIds", "updateIds", "getPluginIntIdByUpdateId", "(I)Ljava/lang/Integer;", "getPluginsDeclaringModule", "moduleId", "parseSourceCodeUrl", "url", "toString", "prepareIdeVersion", "Companion", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nMarketplaceRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketplaceRepository.kt\ncom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n1549#2:200\n1620#2,3:201\n1549#2:204\n1620#2,3:205\n1549#2:208\n1620#2,3:209\n1208#2,2:213\n1238#2,4:215\n1#3:212\n*S KotlinDebug\n*F\n+ 1 MarketplaceRepository.kt\ncom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository\n*L\n43#1:200\n43#1:201,3\n56#1:204\n56#1:205,3\n64#1:208\n64#1:209,3\n151#1:213,2\n151#1:215,4\n*E\n"})
public final class MarketplaceRepository
implements PluginRepository {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final URL repositoryURL;
    @NotNull
    private final org.jetbrains.intellij.pluginRepository.PluginRepository pluginRepositoryInstance;
    @NotNull
    private final ConcurrentHashMap<Integer, Integer> updateIdToPluginIdMapping;
    @NotNull
    private final LoadingCache<Pair<Integer, Integer>, Optional<UpdateInfo>> metadataCache;
    @NotNull
    private static final URL DEFAULT_URL = new URL("https://plugins.jetbrains.com");
    private static final int MAX_AVAILABLE_PLUGINS_IN_REPOSITORY = 10000;

    public MarketplaceRepository(@NotNull URL repositoryURL) {
        Intrinsics.checkNotNullParameter(repositoryURL, "repositoryURL");
        this.repositoryURL = repositoryURL;
        String string2 = this.repositoryURL.toExternalForm();
        Intrinsics.checkNotNullExpressionValue(string2, "repositoryURL.toExternalForm()");
        this.pluginRepositoryInstance = PluginRepositoryFactory.create$default(string2, null, null, 6, null);
        this.updateIdToPluginIdMapping = new ConcurrentHashMap();
        LoadingCache<Object, Optional> loadingCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build(arg_0 -> MarketplaceRepository.metadataCache$lambda$0(metadataCache.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(loadingCache, "newBuilder()\n    .expire\u2026   Optional.empty()\n    }");
        this.metadataCache = loadingCache;
    }

    public /* synthetic */ MarketplaceRepository(URL uRL, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uRL = DEFAULT_URL;
        }
        this(uRL);
    }

    @NotNull
    public final URL getRepositoryURL() {
        return this.repositoryURL;
    }

    @NotNull
    public List<UpdateInfo> getLastCompatiblePlugins(@NotNull IdeVersion ideVersion) {
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        return this.getLastCompatiblePlugins(ideVersion, "");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<UpdateInfo> getLastCompatiblePlugins(@NotNull IdeVersion ideVersion, @NotNull String channel) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        Intrinsics.checkNotNullParameter(channel, "channel");
        PluginManager pluginManager = this.pluginRepositoryInstance.getPluginManager();
        String string2 = ideVersion.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "ideVersion.asString()");
        List pluginsXmlIds = PluginManager.DefaultImpls.getCompatiblePluginsXmlIds$default(pluginManager, string2, 10000, 0, null, 8, null);
        String string3 = ideVersion.asString();
        Intrinsics.checkNotNullExpressionValue(string3, "ideVersion.asString()");
        List updates = PluginManager.DefaultImpls.searchCompatibleUpdates$default(pluginManager, pluginsXmlIds, string3, channel, null, 8, null);
        Iterable $this$map$iv = updates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UpdateBean updateBean = (UpdateBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getPluginId(), it.getId()));
        }
        List pluginIdAndUpdateIds = (List)destination$iv$iv;
        return CollectionsKt.toList((Iterable)this.getPluginInfosForManyPluginIdsAndUpdateIds(pluginIdAndUpdateIds).values());
    }

    @Override
    @Nullable
    public UpdateInfo getLastCompatibleVersionOfPlugin(@NotNull IdeVersion ideVersion, @NotNull String pluginId) {
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        PluginManager pluginManager = this.pluginRepositoryInstance.getPluginManager();
        List<String> list = CollectionsKt.listOf(pluginId);
        String string2 = ideVersion.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "ideVersion.asString()");
        List compatibleUpdates = PluginManager.DefaultImpls.searchCompatibleUpdates$default(pluginManager, list, string2, null, null, 12, null);
        UpdateBean updateBean = (UpdateBean)CollectionsKt.firstOrNull(compatibleUpdates);
        if (updateBean == null) {
            return null;
        }
        UpdateBean compatibleUpdate = updateBean;
        return this.getOrRequestInfo(compatibleUpdate.getPluginId(), compatibleUpdate.getId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<UpdateInfo> getAllVersionsOfPlugin(@NotNull String pluginId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        PluginBean pluginBean = PluginManager.DefaultImpls.getPluginByXmlId$default(this.pluginRepositoryInstance.getPluginManager(), pluginId, null, 2, null);
        if (pluginBean == null) {
            return CollectionsKt.emptyList();
        }
        PluginBean pluginBean2 = pluginBean;
        List<UpdateBean> pluginVersions = this.pluginRepositoryInstance.getPluginManager().getPluginVersions(pluginBean2.getId());
        Iterable $this$map$iv = pluginVersions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UpdateBean updateBean = (UpdateBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(pluginBean2.getId(), it.getId()));
        }
        List pluginIdAndUpdateIds = (List)destination$iv$iv;
        return CollectionsKt.toList((Iterable)this.getPluginInfosForManyPluginIdsAndUpdateIds(pluginIdAndUpdateIds).values());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<UpdateInfo> getPluginsDeclaringModule(@NotNull String moduleId, @Nullable IdeVersion ideVersion) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(moduleId, "moduleId");
        PluginManager pluginManager = this.pluginRepositoryInstance.getPluginManager();
        IdeVersion ideVersion2 = ideVersion;
        String string2 = ideVersion2 != null ? ideVersion2.asString() : null;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string2;
        List plugins = PluginManager.DefaultImpls.searchCompatibleUpdates$default(pluginManager, null, string3, null, moduleId, 5, null);
        Iterable $this$map$iv = plugins;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UpdateBean updateBean = (UpdateBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getPluginId(), it.getId()));
        }
        List pluginIdAndUpdateIds = (List)destination$iv$iv;
        return CollectionsKt.toList((Iterable)this.getPluginInfosForManyPluginIdsAndUpdateIds(pluginIdAndUpdateIds).values());
    }

    private final UpdateInfo createAndCacheUpdateInfo(IntellijUpdateMetadata metadata2, int pluginId) {
        UpdateInfo updateInfo2 = new UpdateInfo(metadata2.getXmlId(), metadata2.getName(), metadata2.getVersion(), this.prepareIdeVersion(metadata2.getSince()), this.prepareIdeVersion(metadata2.getUntil()), metadata2.getVendor(), this.parseSourceCodeUrl(metadata2.getSourceCodeUrl()), this.getDownloadUrl(metadata2.getId()), metadata2.getId(), this.getBrowserUrl(pluginId), metadata2.getTags(), pluginId);
        Integer n = pluginId;
        ((Map)this.updateIdToPluginIdMapping).put(updateInfo2.getUpdateId(), n);
        this.metadataCache.put(TuplesKt.to(updateInfo2.getPluginIntId(), updateInfo2.getUpdateId()), Optional.of(updateInfo2));
        return updateInfo2;
    }

    private final Integer getPluginIntIdByUpdateId(int updateId) {
        Integer n = this.updateIdToPluginIdMapping.get(updateId);
        if (n != null) {
            Integer it = n;
            boolean bl = false;
            return it;
        }
        PluginUpdateBean pluginUpdateBean = this.pluginRepositoryInstance.getPluginUpdateManager().getUpdateById(updateId);
        if (pluginUpdateBean == null) {
            return null;
        }
        PluginUpdateBean pluginUpdateBean2 = pluginUpdateBean;
        int pluginId = pluginUpdateBean2.getPluginId();
        Integer n2 = updateId;
        Integer n3 = pluginId;
        ((Map)this.updateIdToPluginIdMapping).put(n2, n3);
        return pluginId;
    }

    @Nullable
    public final UpdateInfo getPluginInfoByUpdateId(int updateId) {
        Integer n = this.getPluginIntIdByUpdateId(updateId);
        if (n == null) {
            return null;
        }
        int pluginId = n;
        return this.getOrRequestInfo(pluginId, updateId);
    }

    private final UpdateInfo getCachedInfo(int pluginId, int updateId) {
        Optional<UpdateInfo> optional = this.metadataCache.get(TuplesKt.to(pluginId, updateId));
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    private final UpdateInfo getOrRequestInfo(int pluginId, int updateId) {
        UpdateInfo cachedInfo = this.getCachedInfo(pluginId, updateId);
        if (cachedInfo != null) {
            return cachedInfo;
        }
        IntellijUpdateMetadata intellijUpdateMetadata = this.pluginRepositoryInstance.getPluginUpdateManager().getIntellijUpdateMetadata(pluginId, updateId);
        if (intellijUpdateMetadata == null) {
            return null;
        }
        IntellijUpdateMetadata updateMetadata = intellijUpdateMetadata;
        return this.createAndCacheUpdateInfo(updateMetadata, pluginId);
    }

    @NotNull
    public final Map<Integer, UpdateInfo> getPluginInfosForManyUpdateIds(@NotNull List<Integer> updateIds) {
        Intrinsics.checkNotNullParameter(updateIds, "updateIds");
        ArrayList pluginAndUpdateIds = new ArrayList();
        Iterator<Integer> iterator2 = updateIds.iterator();
        while (iterator2.hasNext()) {
            int updateId = ((Number)iterator2.next()).intValue();
            Integer pluginId = this.getPluginIntIdByUpdateId(updateId);
            if (pluginId == null) continue;
            ((Collection)pluginAndUpdateIds).add(TuplesKt.to(pluginId, updateId));
        }
        return this.getPluginInfosForManyPluginIdsAndUpdateIds(pluginAndUpdateIds);
    }

    @NotNull
    public final List<String> getPluginChannels(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        PluginBean pluginBean = PluginManager.DefaultImpls.getPluginByXmlId$default(this.pluginRepositoryInstance.getPluginManager(), pluginId, null, 2, null);
        if (pluginBean == null) {
            return CollectionsKt.emptyList();
        }
        PluginBean pluginBean2 = pluginBean;
        return this.pluginRepositoryInstance.getPluginManager().getPluginChannels(pluginBean2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Integer, UpdateInfo> getPluginInfosForManyPluginIdsAndUpdateIds(@NotNull List<Pair<Integer, Integer>> pluginAndUpdateIds) {
        Intrinsics.checkNotNullParameter(pluginAndUpdateIds, "pluginAndUpdateIds");
        ArrayList toRequest = new ArrayList();
        HashMap result2 = new HashMap();
        for (Pair<Integer, Integer> pair : pluginAndUpdateIds) {
            int updateId;
            int pluginId = ((Number)pair.component1()).intValue();
            UpdateInfo cachedInfo = this.getCachedInfo(pluginId, updateId = ((Number)pair.component2()).intValue());
            if (cachedInfo != null) {
                Integer n = updateId;
                ((Map)result2).put(n, cachedInfo);
                continue;
            }
            ((Collection)toRequest).add(TuplesKt.to(pluginId, updateId));
        }
        if (!((Collection)toRequest).isEmpty()) {
            void $this$associateByTo$iv$iv;
            Map<Integer, IntellijUpdateMetadata> metadataBatch = this.pluginRepositoryInstance.getPluginUpdateManager().getIntellijUpdateMetadataBatch(toRequest);
            Iterable $this$associateBy$iv = toRequest;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Pair pair = (Pair)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Pair it = (Pair)element$iv$iv;
                Integer n = ((Number)it.getSecond()).intValue();
                boolean bl2 = false;
                Integer n2 = ((Number)it.getFirst()).intValue();
                map2.put(n, n2);
            }
            Map updateIdToPluginId = destination$iv$iv;
            for (Map.Entry<Integer, IntellijUpdateMetadata> entry : metadataBatch.entrySet()) {
                int updateId = ((Number)entry.getKey()).intValue();
                IntellijUpdateMetadata metadata2 = entry.getValue();
                int pluginId = ((Number)MapsKt.getValue(updateIdToPluginId, updateId)).intValue();
                Integer n = updateId;
                ((Map)result2).put(n, this.createAndCacheUpdateInfo(metadata2, pluginId));
            }
        }
        return result2;
    }

    private final URL getBrowserUrl(int pluginId) {
        String string2 = this.repositoryURL.toExternalForm();
        Intrinsics.checkNotNullExpressionValue(string2, "repositoryURL.toExternalForm()");
        char[] cArray = new char[]{'/'};
        return new URL(StringsKt.trimEnd(string2, cArray) + "/plugin/" + pluginId);
    }

    private final URL getDownloadUrl(int updateId) {
        String string2 = this.repositoryURL.toExternalForm();
        Intrinsics.checkNotNullExpressionValue(string2, "repositoryURL.toExternalForm()");
        char[] cArray = new char[]{'/'};
        return new URL(StringsKt.trimEnd(string2, cArray) + "/plugin/download/?noStatistic=true&updateId=" + updateId);
    }

    private final IdeVersion prepareIdeVersion(String $this$prepareIdeVersion) {
        return $this$prepareIdeVersion == null || Intrinsics.areEqual($this$prepareIdeVersion, "") || Intrinsics.areEqual($this$prepareIdeVersion, "0.0") ? null : IdeVersion.createIdeVersionIfValid($this$prepareIdeVersion);
    }

    private final URL parseSourceCodeUrl(String url) {
        Object object = url;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            return null;
        }
        try {
            object = new URL(url);
        }
        catch (MalformedURLException e) {
            object = null;
        }
        return object;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "JetBrains Marketplace " + this.repositoryURL.toExternalForm();
    }

    @NotNull
    public String toString() {
        return this.getPresentableName();
    }

    private static final Optional metadataCache$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    public MarketplaceRepository() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository$Companion;", "", "()V", "DEFAULT_URL", "Ljava/net/URL;", "MAX_AVAILABLE_PLUGINS_IN_REPOSITORY", "", "verifier-repository"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

