/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.files;

import com.jetbrains.pluginverifier.repository.cleanup.SpaceAmount;
import com.jetbrains.pluginverifier.repository.files.FileInfo;
import com.jetbrains.pluginverifier.repository.files.SpaceWeight;
import com.jetbrains.pluginverifier.repository.resources.ResourceLock;
import java.nio.file.Path;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/pluginverifier/repository/files/FileLock;", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceLock;", "Ljava/nio/file/Path;", "Lcom/jetbrains/pluginverifier/repository/files/SpaceWeight;", "lockTime", "Ljava/time/Instant;", "file", "fileSize", "Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "(Ljava/time/Instant;Ljava/nio/file/Path;Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;)V", "getFile", "()Ljava/nio/file/Path;", "verifier-repository"})
public abstract class FileLock
extends ResourceLock<Path, SpaceWeight> {
    @NotNull
    private final Path file;

    public FileLock(@NotNull Instant lockTime, @NotNull Path file2, @NotNull SpaceAmount fileSize) {
        Intrinsics.checkNotNullParameter(lockTime, "lockTime");
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(fileSize, "fileSize");
        super(lockTime, new FileInfo(file2, fileSize));
        this.file = file2;
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }
}

