/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.reporting;

import com.jetbrains.plugin.structure.base.telemetry.PluginTelemetry;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.PluginVerificationResult;
import com.jetbrains.pluginverifier.PluginVerificationTarget;
import com.jetbrains.pluginverifier.reporting.DirectoryBasedPluginVerificationReportage;
import com.jetbrains.pluginverifier.reporting.DirectoryBasedPluginVerificationReportageKt;
import com.jetbrains.pluginverifier.reporting.PluginVerificationReportage;
import com.jetbrains.pluginverifier.reporting.PluginVerificationReportageAggregator;
import com.jetbrains.pluginverifier.reporting.Reporter;
import com.jetbrains.pluginverifier.reporting.common.FileReporter;
import com.jetbrains.pluginverifier.reporting.common.LogReporter;
import com.jetbrains.pluginverifier.reporting.ignoring.AllIgnoredProblemsReporter;
import com.jetbrains.pluginverifier.reporting.ignoring.IgnoredPluginsReporter;
import com.jetbrains.pluginverifier.reporting.ignoring.IgnoredProblemsReporter;
import com.jetbrains.pluginverifier.reporting.ignoring.PluginIgnoredEvent;
import com.jetbrains.pluginverifier.reporting.ignoring.ProblemIgnoredEvent;
import com.jetbrains.pluginverifier.reporting.telemetry.TelemetryAggregator;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.repositories.marketplace.UpdateInfo;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import java.io.Closeable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\u0018\u0010 \u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0016JB\u0010#\u001a\u00020\u0017\"\u0004\b\u0000\u0010$2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H$0(2\u0014\b\u0002\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H$\u0012\u0004\u0012\u00020\u00120\u0007H\u0002J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,H\u0016J&\u0010-\u001a\u00020\u0017\"\u0004\b\u0000\u0010$*\b\u0012\u0004\u0012\u0002H$0.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H$0(H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/pluginverifier/reporting/DirectoryBasedPluginVerificationReportage;", "Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;", "pluginVerificationReportageResultAggregator", "Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportageAggregator;", "telemetryAggregator", "Lcom/jetbrains/pluginverifier/reporting/telemetry/TelemetryAggregator;", "targetDirectoryProvider", "Lkotlin/Function1;", "Lcom/jetbrains/pluginverifier/PluginVerificationTarget;", "Ljava/nio/file/Path;", "(Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportageAggregator;Lcom/jetbrains/pluginverifier/reporting/telemetry/TelemetryAggregator;Lkotlin/jvm/functions/Function1;)V", "allIgnoredProblemsReporter", "Lcom/jetbrains/pluginverifier/reporting/ignoring/AllIgnoredProblemsReporter;", "ignoredPluginsReporters", "", "Lcom/jetbrains/pluginverifier/reporting/ignoring/IgnoredPluginsReporter;", "messageReporters", "Lcom/jetbrains/pluginverifier/reporting/common/LogReporter;", "", "verificationLogger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "close", "", "createPluginVerificationDirectory", "pluginInfo", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "logPluginVerificationIgnored", "verificationTarget", "reason", "logVerificationStage", "stageMessage", "reportTelemetry", "telemetry", "Lcom/jetbrains/plugin/structure/base/telemetry/PluginTelemetry;", "reportVerificationDetails", "T", "directory", "fileName", "content", "", "lineProvider", "reportVerificationResult", "pluginVerificationResult", "Lcom/jetbrains/pluginverifier/PluginVerificationResult;", "useReporter", "Lcom/jetbrains/pluginverifier/reporting/Reporter;", "ts", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nDirectoryBasedPluginVerificationReportage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryBasedPluginVerificationReportage.kt\ncom/jetbrains/pluginverifier/reporting/DirectoryBasedPluginVerificationReportage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,176:1\n1855#2,2:177\n1855#2,2:179\n1855#2,2:181\n1855#2,2:183\n1855#2,2:186\n1855#2,2:192\n1#3:185\n125#4:188\n152#4,3:189\n*S KotlinDebug\n*F\n+ 1 DirectoryBasedPluginVerificationReportage.kt\ncom/jetbrains/pluginverifier/reporting/DirectoryBasedPluginVerificationReportage\n*L\n70#1:177,2\n71#1:179,2\n76#1:181,2\n84#1:183,2\n113#1:186,2\n139#1:192,2\n138#1:188\n138#1:189,3\n*E\n"})
public final class DirectoryBasedPluginVerificationReportage
implements PluginVerificationReportage {
    @NotNull
    private final PluginVerificationReportageAggregator pluginVerificationReportageResultAggregator;
    @NotNull
    private final TelemetryAggregator telemetryAggregator;
    @NotNull
    private final Function1<PluginVerificationTarget, Path> targetDirectoryProvider;
    private final Logger verificationLogger;
    @NotNull
    private final List<LogReporter<String>> messageReporters;
    @NotNull
    private final List<IgnoredPluginsReporter> ignoredPluginsReporters;
    @NotNull
    private final AllIgnoredProblemsReporter allIgnoredProblemsReporter;

    public DirectoryBasedPluginVerificationReportage(@NotNull PluginVerificationReportageAggregator pluginVerificationReportageResultAggregator, @NotNull TelemetryAggregator telemetryAggregator, @NotNull Function1<? super PluginVerificationTarget, ? extends Path> targetDirectoryProvider) {
        Intrinsics.checkNotNullParameter(pluginVerificationReportageResultAggregator, "pluginVerificationReportageResultAggregator");
        Intrinsics.checkNotNullParameter(telemetryAggregator, "telemetryAggregator");
        Intrinsics.checkNotNullParameter(targetDirectoryProvider, "targetDirectoryProvider");
        this.pluginVerificationReportageResultAggregator = pluginVerificationReportageResultAggregator;
        this.telemetryAggregator = telemetryAggregator;
        this.targetDirectoryProvider = targetDirectoryProvider;
        Logger logger = this.verificationLogger = LoggerFactory.getLogger("verification");
        Intrinsics.checkNotNullExpressionValue(logger, "verificationLogger");
        this.messageReporters = CollectionsKt.listOf(new LogReporter(logger));
        this.ignoredPluginsReporters = CollectionsKt.listOf(new IgnoredPluginsReporter(this.targetDirectoryProvider));
        this.allIgnoredProblemsReporter = new AllIgnoredProblemsReporter(this.targetDirectoryProvider);
    }

    public /* synthetic */ DirectoryBasedPluginVerificationReportage(PluginVerificationReportageAggregator pluginVerificationReportageAggregator, TelemetryAggregator telemetryAggregator, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pluginVerificationReportageAggregator = DirectoryBasedPluginVerificationReportage::_init_$lambda$0;
        }
        if ((n & 2) != 0) {
            telemetryAggregator = new TelemetryAggregator();
        }
        this(pluginVerificationReportageAggregator, telemetryAggregator, function1);
    }

    @Override
    public void close() {
        Reporter it;
        Iterable $this$forEach$iv = this.messageReporters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (LogReporter)element$iv;
            boolean bl = false;
            LanguageUtilsKt.closeLogged((Closeable)it);
        }
        $this$forEach$iv = this.ignoredPluginsReporters;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IgnoredPluginsReporter)element$iv;
            boolean bl = false;
            LanguageUtilsKt.closeLogged((Closeable)it);
        }
        LanguageUtilsKt.closeLogged((Closeable)this.allIgnoredProblemsReporter);
    }

    @Override
    public void logVerificationStage(@NotNull String stageMessage) {
        Intrinsics.checkNotNullParameter(stageMessage, "stageMessage");
        Iterable $this$forEach$iv = this.messageReporters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogReporter it = (LogReporter)element$iv;
            boolean bl = false;
            it.report(stageMessage);
        }
    }

    @Override
    public void logPluginVerificationIgnored(@NotNull PluginInfo pluginInfo, @NotNull PluginVerificationTarget verificationTarget, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(verificationTarget, "verificationTarget");
        Intrinsics.checkNotNullParameter(reason, "reason");
        Iterable $this$forEach$iv = this.ignoredPluginsReporters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IgnoredPluginsReporter it = (IgnoredPluginsReporter)element$iv;
            boolean bl = false;
            it.report(new PluginIgnoredEvent(pluginInfo, verificationTarget, reason));
        }
    }

    @Override
    public void reportTelemetry(@NotNull PluginInfo pluginInfo, @NotNull PluginTelemetry telemetry) {
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(telemetry, "telemetry");
        this.telemetryAggregator.reportTelemetry(pluginInfo, telemetry);
    }

    private final Path createPluginVerificationDirectory(PluginInfo pluginInfo) {
        Path path;
        String pluginId = FileUtilKt.replaceInvalidFileNameCharacters(pluginInfo.getPluginId());
        if (pluginInfo instanceof UpdateInfo) {
            String version = FileUtilKt.replaceInvalidFileNameCharacters(pluginInfo.getVersion() + " (#" + ((UpdateInfo)pluginInfo).getUpdateId() + ")");
            String[] stringArray = new String[]{version};
            Path path2 = Paths.get(pluginId, stringArray);
            Intrinsics.checkNotNullExpressionValue(path2, "{\n        val version = \u2026luginId, version)\n      }");
            path = path2;
        } else {
            String[] stringArray = new String[]{FileUtilKt.replaceInvalidFileNameCharacters(pluginInfo.getVersion())};
            Path path3 = Paths.get(pluginId, stringArray);
            path = path3;
            Intrinsics.checkNotNullExpressionValue(path3, "get(pluginId, pluginInfo\u2026alidFileNameCharacters())");
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void useReporter(Reporter<? super T> $this$useReporter, Iterable<? extends T> ts) {
        Closeable closeable = $this$useReporter;
        Throwable throwable = null;
        try {
            Reporter it = (Reporter)closeable;
            boolean bl = false;
            Iterable<T> $this$forEach$iv = ts;
            boolean $i$f$forEach = false;
            Iterator<T> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                T element$iv;
                T t2 = element$iv = iterator2.next();
                boolean bl2 = false;
                $this$useReporter.report(t2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void reportVerificationResult(@NotNull PluginVerificationResult pluginVerificationResult) {
        Intrinsics.checkNotNullParameter(pluginVerificationResult, "pluginVerificationResult");
        PluginVerificationResult $this$reportVerificationResult_u24lambda_u249 = pluginVerificationResult;
        boolean bl = false;
        Path verificationTargetDirectory = this.targetDirectoryProvider.invoke($this$reportVerificationResult_u24lambda_u249.getVerificationTarget());
        Path directory = verificationTargetDirectory.resolve("plugins").resolve(this.createPluginVerificationDirectory($this$reportVerificationResult_u24lambda_u249.getPlugin()));
        Intrinsics.checkNotNullExpressionValue(directory, "directory");
        this.reportVerificationDetails(directory, "verification-verdict.txt", (Iterable)CollectionsKt.listOf(pluginVerificationResult), reportVerificationResult.1.1.INSTANCE);
        PluginVerificationResult pluginVerificationResult2 = $this$reportVerificationResult_u24lambda_u249;
        if (pluginVerificationResult2 instanceof PluginVerificationResult.Verified) {
            void $this$mapTo$iv$iv;
            DirectoryBasedPluginVerificationReportage.reportVerificationDetails$default(this, directory, "compatibility-warnings.txt", ((PluginVerificationResult.Verified)$this$reportVerificationResult_u24lambda_u249).getCompatibilityWarnings(), null, 8, null);
            DirectoryBasedPluginVerificationReportage.reportVerificationDetails$default(this, directory, "compatibility-problems.txt", ((PluginVerificationResult.Verified)$this$reportVerificationResult_u24lambda_u249).getCompatibilityProblems(), null, 8, null);
            this.reportVerificationDetails(directory, "dependencies.txt", (Iterable)CollectionsKt.listOf(((PluginVerificationResult.Verified)$this$reportVerificationResult_u24lambda_u249).getDependenciesGraph()), reportVerificationResult.1.2.INSTANCE);
            DirectoryBasedPluginVerificationReportage.reportVerificationDetails$default(this, directory, "deprecated-usages.txt", ((PluginVerificationResult.Verified)$this$reportVerificationResult_u24lambda_u249).getDeprecatedUsages(), null, 8, null);
            DirectoryBasedPluginVerificationReportage.reportVerificationDetails$default(this, directory, "experimental-api-usages.txt", ((PluginVerificationResult.Verified)$this$reportVerificationResult_u24lambda_u249).getExperimentalApiUsages(), null, 8, null);
            DirectoryBasedPluginVerificationReportage.reportVerificationDetails$default(this, directory, "internal-api-usages.txt", ((PluginVerificationResult.Verified)$this$reportVerificationResult_u24lambda_u249).getInternalApiUsages(), null, 8, null);
            DirectoryBasedPluginVerificationReportage.reportVerificationDetails$default(this, directory, "override-only-usages.txt", ((PluginVerificationResult.Verified)$this$reportVerificationResult_u24lambda_u249).getOverrideOnlyMethodUsages(), null, 8, null);
            DirectoryBasedPluginVerificationReportage.reportVerificationDetails$default(this, directory, "non-extendable-api-usages.txt", ((PluginVerificationResult.Verified)$this$reportVerificationResult_u24lambda_u249).getNonExtendableApiUsages(), null, 8, null);
            DirectoryBasedPluginVerificationReportage.reportVerificationDetails$default(this, directory, "plugin-structure-warnings.txt", ((PluginVerificationResult.Verified)$this$reportVerificationResult_u24lambda_u249).getPluginStructureWarnings(), null, 8, null);
            this.reportVerificationDetails(directory, "telemetry.txt", DirectoryBasedPluginVerificationReportageKt.access$orEmpty(DirectoryBasedPluginVerificationReportageKt.access$withPluginIdAndVersion(this.telemetryAggregator.get($this$reportVerificationResult_u24lambda_u249.getPlugin()), (PluginVerificationResult.Verified)$this$reportVerificationResult_u24lambda_u249)), reportVerificationResult.1.3.INSTANCE);
            Map<CompatibilityProblem, String> $this$map$iv = ((PluginVerificationResult.Verified)$this$reportVerificationResult_u24lambda_u249).getIgnoredProblems();
            boolean $i$f$map = false;
            Map<CompatibilityProblem, String> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new ProblemIgnoredEvent($this$reportVerificationResult_u24lambda_u249.getPlugin(), $this$reportVerificationResult_u24lambda_u249.getVerificationTarget(), (CompatibilityProblem)it.getKey(), (String)it.getValue()));
            }
            List problemIgnoredEvents = (List)destination$iv$iv;
            Iterable $this$forEach$iv = problemIgnoredEvents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProblemIgnoredEvent it = (ProblemIgnoredEvent)element$iv;
                boolean bl3 = false;
                this.allIgnoredProblemsReporter.report(it);
            }
            this.useReporter(new IgnoredProblemsReporter(directory, $this$reportVerificationResult_u24lambda_u249.getVerificationTarget()), problemIgnoredEvents);
            this.pluginVerificationReportageResultAggregator.handleVerificationResult($this$reportVerificationResult_u24lambda_u249, verificationTargetDirectory);
        } else if (pluginVerificationResult2 instanceof PluginVerificationResult.InvalidPlugin) {
            DirectoryBasedPluginVerificationReportage.reportVerificationDetails$default(this, directory, "invalid-plugin.txt", ((PluginVerificationResult.InvalidPlugin)$this$reportVerificationResult_u24lambda_u249).getPluginStructureErrors(), null, 8, null);
            this.pluginVerificationReportageResultAggregator.handleVerificationResult($this$reportVerificationResult_u24lambda_u249, verificationTargetDirectory);
        } else if (!(pluginVerificationResult2 instanceof PluginVerificationResult.NotFound) && !(pluginVerificationResult2 instanceof PluginVerificationResult.FailedToDownload)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final <T> void reportVerificationDetails(Path directory, String fileName, Iterable<? extends T> content, Function1<? super T, String> lineProvider) {
        Path path = directory.resolve(fileName);
        Intrinsics.checkNotNullExpressionValue(path, "directory.resolve(fileName)");
        this.useReporter((Reporter)new FileReporter<T>(path, lineProvider), content);
    }

    static /* synthetic */ void reportVerificationDetails$default(DirectoryBasedPluginVerificationReportage directoryBasedPluginVerificationReportage, Path path, String string2, Iterable iterable, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = reportVerificationDetails.1.INSTANCE;
        }
        directoryBasedPluginVerificationReportage.reportVerificationDetails(path, string2, iterable, function1);
    }

    private static final void _init_$lambda$0(PluginVerificationResult pluginVerificationResult, Path path) {
        Intrinsics.checkNotNullParameter(pluginVerificationResult, "<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter(path, "<anonymous parameter 1>");
    }
}

