/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.platform;

import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfo;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfoParseException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfoParser;", "", "()V", "jackson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "parse", "Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfo;", "inputStream", "Ljava/io/InputStream;", "streamLocation", "", "productInfoJsonUrl", "Ljava/net/URL;", "productInfoJsonPath", "Ljava/nio/file/Path;", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nProductInfoParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductInfoParser.kt\ncom/jetbrains/plugin/structure/intellij/platform/ProductInfoParser\n+ 2 Extensions.kt\ncom/fasterxml/jackson/module/kotlin/ExtensionsKt\n*L\n1#1,43:1\n52#2:44\n43#2:45\n*E\n*S KotlinDebug\n*F\n+ 1 ProductInfoParser.kt\ncom/jetbrains/plugin/structure/intellij/platform/ProductInfoParser\n*L\n30#1:44\n30#1:45\n*E\n"})
public final class ProductInfoParser {
    private final ObjectMapper jackson = new ObjectMapper();

    @NotNull
    public final ProductInfo parse(@NotNull Path productInfoJsonPath) throws ProductInfoParseException {
        Intrinsics.checkNotNullParameter(productInfoJsonPath, "productInfoJsonPath");
        return this.parse(FileUtilKt.inputStream(productInfoJsonPath), ((Object)productInfoJsonPath).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ProductInfo parse(@NotNull URL productInfoJsonUrl) throws ProductInfoParseException {
        ProductInfo productInfo;
        Intrinsics.checkNotNullParameter(productInfoJsonUrl, "productInfoJsonUrl");
        Closeable closeable = productInfoJsonUrl.openStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            InputStream inputStream2 = it;
            Intrinsics.checkNotNullExpressionValue(inputStream2, "it");
            String string2 = productInfoJsonUrl.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "productInfoJsonUrl.toString()");
            productInfo = this.parse(inputStream2, string2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return productInfo;
    }

    @NotNull
    public final ProductInfo parse(@NotNull InputStream inputStream2, @NotNull String streamLocation) throws ProductInfoParseException {
        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
        Intrinsics.checkNotNullParameter(streamLocation, "streamLocation");
        try {
            ObjectMapper $this$readValue$iv = this.jackson;
            boolean $i$f$readValue = false;
            boolean $i$f$jacksonTypeRef = false;
            return (ProductInfo)$this$readValue$iv.readValue(inputStream2, (TypeReference)new TypeReference<ProductInfo>(){});
        }
        catch (Exception e) {
            Exception exception = e;
            if (exception instanceof StreamReadException || exception instanceof DatabindException || exception instanceof IOException) {
                throw (Throwable)new ProductInfoParseException("Cannot load 'product-info.json' from [" + streamLocation + "]", e);
            }
            throw (Throwable)e;
        }
    }
}

