/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide.classes;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.CompositeResolver;
import com.jetbrains.plugin.structure.classes.resolvers.DirectoryResolver;
import com.jetbrains.plugin.structure.classes.resolvers.EmptyResolver;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.JarFileResolverKt;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.ide.IdeManagerImpl;
import com.jetbrains.plugin.structure.ide.InvalidIdeException;
import com.jetbrains.plugin.structure.ide.RepositoryLibrariesUtilKt;
import com.jetbrains.plugin.structure.ide.classes.IdeFileOrigin;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/ide/classes/IdeResolverCreator;", "", "()V", "createIdeResolver", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "getIdeResolverFromCompiledSources", "idePath", "Ljava/nio/file/Path;", "getJarsResolver", "libDirectory", "parentOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "getRepositoryLibrariesResolver", "structure-ide-classes"})
@SourceDebugExtension(value={"SMAP\nIdeResolverCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeResolverCreator.kt\ncom/jetbrains/plugin/structure/ide/classes/IdeResolverCreator\n+ 2 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n79#2,2:90\n81#2,2:94\n83#2:98\n1855#3,2:92\n1855#3,2:96\n*E\n*S KotlinDebug\n*F\n+ 1 IdeResolverCreator.kt\ncom/jetbrains/plugin/structure/ide/classes/IdeResolverCreator\n*L\n65#1,2:90\n65#1,2:94\n65#1:98\n70#1,2:92\n65#1,2:96\n*E\n"})
public final class IdeResolverCreator {
    @NotNull
    public static final IdeResolverCreator INSTANCE;

    @JvmStatic
    @NotNull
    public static final Resolver createIdeResolver(@NotNull Ide ide) {
        Intrinsics.checkNotNullParameter(ide, "ide");
        return IdeResolverCreator.createIdeResolver(Resolver.ReadMode.FULL, ide);
    }

    @JvmStatic
    @NotNull
    public static final Resolver createIdeResolver(@NotNull Resolver.ReadMode readMode, @NotNull Ide ide) {
        Resolver resolver;
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        Intrinsics.checkNotNullParameter(ide, "ide");
        Path path = ide.getIdePath();
        Intrinsics.checkNotNullExpressionValue(path, "ide.idePath");
        Path idePath = path;
        if (IdeManagerImpl.Companion.isDistributionIde(idePath)) {
            Path path2 = idePath.resolve("lib");
            Intrinsics.checkNotNullExpressionValue(path2, "idePath.resolve(\"lib\")");
            resolver = INSTANCE.getJarsResolver(path2, readMode, new IdeFileOrigin.IdeLibDirectory(ide));
        } else if (IdeManagerImpl.Companion.isCompiledCommunity(idePath) || IdeManagerImpl.Companion.isCompiledUltimate(idePath)) {
            resolver = INSTANCE.getIdeResolverFromCompiledSources(idePath, readMode, ide);
        } else {
            throw (Throwable)new InvalidIdeException(idePath, "Invalid IDE " + ide + " at " + idePath);
        }
        return resolver;
    }

    private final Resolver getJarsResolver(Path libDirectory, Resolver.ReadMode readMode, FileOrigin parentOrigin) {
        if (!FileUtilKt.isDirectory(libDirectory)) {
            return EmptyResolver.INSTANCE;
        }
        List<Path> jars = FileUtilKt.listJars(libDirectory);
        Path path = libDirectory.resolve("ant").resolve("lib");
        Intrinsics.checkNotNullExpressionValue(path, "libDirectory.resolve(\"ant\").resolve(\"lib\")");
        List<Path> antJars = FileUtilKt.listJars(path);
        Path path2 = libDirectory.resolve("modules");
        Intrinsics.checkNotNullExpressionValue(path2, "libDirectory.resolve(\"modules\")");
        List<Path> moduleJars = FileUtilKt.listJars(path2);
        return CompositeResolver.Companion.create((Iterable<? extends Resolver>)JarFileResolverKt.buildJarOrZipFileResolvers(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)jars, (Iterable)antJars), (Iterable)moduleJars), readMode, parentOrigin));
    }

    private final Resolver getIdeResolverFromCompiledSources(Path idePath, Resolver.ReadMode readMode, Ide ide) {
        ArrayList resolvers = new ArrayList();
        List $this$closeOnException$iv = resolvers;
        boolean $i$f$closeOnException = false;
        try {
            List it = $this$closeOnException$iv;
            boolean bl = false;
            Collection collection = resolvers;
            Path path = idePath.resolve("lib");
            Intrinsics.checkNotNullExpressionValue(path, "idePath.resolve(\"lib\")");
            Object object = INSTANCE.getJarsResolver(path, readMode, new IdeFileOrigin.SourceLibDirectory(ide));
            collection.add(object);
            collection = resolvers;
            object = INSTANCE.getRepositoryLibrariesResolver(idePath, readMode, ide);
            collection.add(object);
            Path path2 = IdeManagerImpl.Companion.getCompiledClassesRoot(idePath);
            Intrinsics.checkNotNull(path2);
            Path compiledClassesRoot = path2;
            Iterable $this$forEach$iv = FileUtilKt.listFiles(compiledClassesRoot);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path moduleRoot = (Path)element$iv;
                boolean bl2 = false;
                IdeFileOrigin.CompiledModule fileOrigin = new IdeFileOrigin.CompiledModule(ide, FileUtilKt.getSimpleName(moduleRoot));
                Collection collection2 = resolvers;
                DirectoryResolver directoryResolver = new DirectoryResolver(moduleRoot, fileOrigin, readMode);
                collection2.add(directoryResolver);
            }
            if (IdeManagerImpl.Companion.isCompiledUltimate(idePath)) {
                object = resolvers;
                Path path3 = idePath.resolve("community").resolve("lib");
                Intrinsics.checkNotNullExpressionValue(path3, "idePath.resolve(\"community\").resolve(\"lib\")");
                Resolver resolver = INSTANCE.getJarsResolver(path3, readMode, new IdeFileOrigin.SourceLibDirectory(ide));
                object.add(resolver);
            }
            return CompositeResolver.Companion.create(resolvers);
        }
        catch (Throwable e$iv) {
            Iterable $this$forEach$iv$iv = $this$closeOnException$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Closeable t$iv = (Closeable)element$iv$iv;
                boolean bl = false;
                Closeable closeable = t$iv;
                if (closeable == null) continue;
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e$iv;
        }
    }

    private final Resolver getRepositoryLibrariesResolver(Path idePath, Resolver.ReadMode readMode, Ide ide) {
        List<Path> jars = RepositoryLibrariesUtilKt.getRepositoryLibrariesJars(idePath);
        return CompositeResolver.Companion.create((Iterable<? extends Resolver>)JarFileResolverKt.buildJarOrZipFileResolvers((Iterable<? extends Path>)jars, readMode, new IdeFileOrigin.RepositoryLibrary(ide)));
    }

    private IdeResolverCreator() {
    }

    static {
        IdeResolverCreator ideResolverCreator;
        INSTANCE = ideResolverCreator = new IdeResolverCreator();
    }
}

