/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationFail;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.ide.BuildTxtIdeVersionProvider;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.ide.IdeImpl;
import com.jetbrains.plugin.structure.ide.IdeManager;
import com.jetbrains.plugin.structure.ide.IdeVersionResolution;
import com.jetbrains.plugin.structure.ide.InvalidIdeException;
import com.jetbrains.plugin.structure.ide.ProductInfoBasedIdeManagerKt;
import com.jetbrains.plugin.structure.ide.layout.CorePluginManager;
import com.jetbrains.plugin.structure.ide.layout.LayoutComponentLoader;
import com.jetbrains.plugin.structure.ide.layout.LoadingResults;
import com.jetbrains.plugin.structure.ide.layout.ModuleFactory;
import com.jetbrains.plugin.structure.ide.layout.PluginFactory;
import com.jetbrains.plugin.structure.ide.layout.PluginWithArtifactPathResult;
import com.jetbrains.plugin.structure.ide.layout.ProductInfoClasspathProvider;
import com.jetbrains.plugin.structure.intellij.platform.BundledModulesManager;
import com.jetbrains.plugin.structure.intellij.platform.BundledModulesResolver;
import com.jetbrains.plugin.structure.intellij.platform.LayoutComponent;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfo;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfoParseException;
import com.jetbrains.plugin.structure.intellij.platform.ProductInfoParser;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.plugin.JarFilesResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.CompositeResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.NamedResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\b\b\u0002\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0018H\u0002J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010*\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010+\u001a\u00020%2\u0006\u0010\u000b\u001a\u00020\u0006J\f\u0010,\u001a\u00020%*\u00020\u0006H\u0002J\u001a\u0010-\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020)0.2\u0006\u0010\u0016\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006/"}, d2={"Lcom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager;", "Lcom/jetbrains/plugin/structure/ide/IdeManager;", "()V", "productInfoParser", "Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfoParser;", "productInfoJson", "Ljava/nio/file/Path;", "getProductInfoJson", "(Ljava/nio/file/Path;)Ljava/nio/file/Path;", "assertProductInfoPresent", "", "idePath", "createIde", "Lcom/jetbrains/plugin/structure/ide/Ide;", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "productInfo", "Lcom/jetbrains/plugin/structure/intellij/platform/ProductInfo;", "version", "createIdeVersion", "createModule", "Lcom/jetbrains/plugin/structure/ide/layout/PluginWithArtifactPathResult;", "pluginArtifactPath", "descriptorName", "", "pathResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "createPlugin", "descriptorPath", "resourceResolver", "getPlatformResourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/CompositeResourceResolver;", "getResourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/NamedResourceResolver;", "layoutComponent", "Lcom/jetbrains/plugin/structure/intellij/platform/LayoutComponent;", "isAtLeastVersion", "", "expectedVersion", "readCorePlugin", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "readPlugins", "supports", "containsProductInfoJson", "withPath", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "structure-ide"})
@SourceDebugExtension(value={"SMAP\nProductInfoBasedIdeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProductInfoBasedIdeManager.kt\ncom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n1603#2,9:195\n1855#2:204\n1856#2:206\n1612#2:207\n1789#2,3:208\n1603#2,9:211\n1855#2:220\n1856#2:222\n1612#2:223\n1549#2:224\n1620#2,3:225\n1#3:205\n1#3:221\n*E\n*S KotlinDebug\n*F\n+ 1 ProductInfoBasedIdeManager.kt\ncom/jetbrains/plugin/structure/ide/ProductInfoBasedIdeManager\n*L\n79#1,9:195\n79#1:204\n79#1:206\n79#1:207\n93#1,3:208\n106#1,9:211\n106#1:220\n106#1:222\n106#1:223\n151#1:224\n151#1,3:225\n79#1:205\n106#1:221\n*E\n"})
public final class ProductInfoBasedIdeManager
extends IdeManager {
    private final ProductInfoParser productInfoParser = new ProductInfoParser();

    @Override
    @NotNull
    public Ide createIde(@NotNull Path idePath) throws InvalidIdeException {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        return this.createIde(idePath, ProductInfoBasedIdeManagerKt.access$getVERSION_FROM_PRODUCT_INFO$p());
    }

    @Override
    @NotNull
    public Ide createIde(@NotNull Path idePath, @Nullable IdeVersion version) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        this.assertProductInfoPresent(idePath);
        try {
            ProductInfo productInfo = this.productInfoParser.parse(this.getProductInfoJson(idePath));
            IdeVersion ideVersion = version;
            if (ideVersion == null) {
                ideVersion = this.createIdeVersion(productInfo);
            }
            IdeVersion ideVersion2 = ideVersion;
            return this.createIde(idePath, ideVersion2, productInfo);
        }
        catch (ProductInfoParseException e) {
            throw (Throwable)new InvalidIdeException(idePath, e);
        }
    }

    private final Ide createIde(Path idePath, IdeVersion ideVersion, ProductInfo productInfo) {
        if (!FileUtilKt.isDirectory(idePath)) {
            throw (Throwable)new IOException("Specified path does not exist or is not a directory: " + idePath);
        }
        List<IdePlugin> corePlugin = this.readCorePlugin(idePath, ideVersion);
        List<IdePlugin> plugins = this.readPlugins(idePath, productInfo, ideVersion);
        return new IdeImpl(idePath, ideVersion, CollectionsKt.plus((Collection)corePlugin, (Iterable)plugins));
    }

    /*
     * WARNING - void declaration
     */
    private final List<IdePlugin> readPlugins(Path idePath, ProductInfo productInfo, IdeVersion ideVersion) {
        void $this$fold$iv;
        void $this$mapNotNullTo$iv$iv;
        CompositeResourceResolver platformResourceResolver = this.getPlatformResourceResolver(productInfo, idePath);
        BundledModulesManager moduleManager = new BundledModulesManager(new BundledModulesResolver(idePath, null, 2, null));
        Function4 function4 = new Function4<Path, String, ResourceResolver, IdeVersion, PluginWithArtifactPathResult>(this){

            @NotNull
            public final PluginWithArtifactPathResult invoke(@NotNull Path p1, @NotNull String p2, @NotNull ResourceResolver p3, @NotNull IdeVersion p4) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                Intrinsics.checkNotNullParameter(p2, "p2");
                Intrinsics.checkNotNullParameter(p3, "p3");
                Intrinsics.checkNotNullParameter(p4, "p4");
                return ProductInfoBasedIdeManager.access$createModule((ProductInfoBasedIdeManager)this.receiver, p1, p2, p3, p4);
            }
        };
        ModuleFactory moduleV2Factory2 = new ModuleFactory(new LayoutComponentLoader(function4){
            private final /* synthetic */ Function4 function;
            {
                this.function = function4;
            }

            public final /* synthetic */ PluginWithArtifactPathResult load(Path pluginArtifactPath, String descriptorName, ResourceResolver resourceResolver, IdeVersion ideVersion) {
                Intrinsics.checkNotNullParameter(pluginArtifactPath, "pluginArtifactPath");
                Intrinsics.checkNotNullParameter(descriptorName, "descriptorName");
                Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
                Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
                R r = this.function.invoke(pluginArtifactPath, descriptorName, resourceResolver, ideVersion);
                Intrinsics.checkNotNullExpressionValue(r, "invoke(...)");
                return (PluginWithArtifactPathResult)r;
            }

            public Function getFunctionDelegate() {
                return this.function;
            }

            public boolean equals(Object object) {
                return object instanceof LayoutComponentLoader && object instanceof FunctionAdapter && Intrinsics.areEqual(this.function, ((FunctionAdapter)object).getFunctionDelegate());
            }

            public int hashCode() {
                return this.function.hashCode();
            }
        }, new ProductInfoClasspathProvider(productInfo));
        Function4 function42 = new Function4<Path, String, ResourceResolver, IdeVersion, PluginWithArtifactPathResult>(this){

            @NotNull
            public final PluginWithArtifactPathResult invoke(@NotNull Path p1, @NotNull String p2, @NotNull ResourceResolver p3, @NotNull IdeVersion p4) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                Intrinsics.checkNotNullParameter(p2, "p2");
                Intrinsics.checkNotNullParameter(p3, "p3");
                Intrinsics.checkNotNullParameter(p4, "p4");
                return ProductInfoBasedIdeManager.access$createPlugin((ProductInfoBasedIdeManager)this.receiver, p1, p2, p3, p4);
            }
        };
        PluginFactory pluginFactory2 = new PluginFactory(new /* invalid duplicate definition of identical inner class */);
        Iterable $this$mapNotNull$iv = productInfo.getLayout();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PluginWithArtifactPathResult pluginWithArtifactPathResult;
            PluginWithArtifactPathResult pluginWithArtifactPathResult2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            LayoutComponent layoutComponent = (LayoutComponent)element$iv$iv;
            boolean bl2 = false;
            LayoutComponent layoutComponent2 = layoutComponent;
            if (layoutComponent2 instanceof LayoutComponent.ModuleV2 || layoutComponent2 instanceof LayoutComponent.ProductModuleV2) {
                pluginWithArtifactPathResult2 = moduleV2Factory2.read(layoutComponent, idePath, ideVersion, (ResourceResolver)platformResourceResolver, moduleManager);
            } else if (layoutComponent2 instanceof LayoutComponent.Plugin) {
                pluginWithArtifactPathResult2 = pluginFactory2.read((LayoutComponent.Plugin)layoutComponent, idePath, ideVersion, (ResourceResolver)platformResourceResolver, moduleManager);
            } else if (layoutComponent2 instanceof LayoutComponent.PluginAlias) {
                pluginWithArtifactPathResult2 = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (pluginWithArtifactPathResult2 == null) continue;
            PluginWithArtifactPathResult it$iv$iv = pluginWithArtifactPathResult = pluginWithArtifactPathResult2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        LoadingResults initial$iv = new LoadingResults();
        boolean $i$f$fold = false;
        LoadingResults accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p2;
            PluginWithArtifactPathResult $i$f$forEach2 = (PluginWithArtifactPathResult)element$iv;
            LoadingResults p1 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p1.add((PluginWithArtifactPathResult)p2);
        }
        LoadingResults moduleLoadingResults = accumulator$iv;
        PluginWithArtifactPathResult.Companion.logFailures$structure_ide(ProductInfoBasedIdeManagerKt.access$getLOG$p(), moduleLoadingResults.getFailures(), idePath);
        return moduleLoadingResults.getSuccessfulPlugins();
    }

    private final List<IdePlugin> readCorePlugin(Path idePath, IdeVersion ideVersion) {
        Function4 function4 = new Function4<Path, String, ResourceResolver, IdeVersion, PluginWithArtifactPathResult>(this){

            @NotNull
            public final PluginWithArtifactPathResult invoke(@NotNull Path p1, @NotNull String p2, @NotNull ResourceResolver p3, @NotNull IdeVersion p4) {
                Intrinsics.checkNotNullParameter(p1, "p1");
                Intrinsics.checkNotNullParameter(p2, "p2");
                Intrinsics.checkNotNullParameter(p3, "p3");
                Intrinsics.checkNotNullParameter(p4, "p4");
                return ProductInfoBasedIdeManager.access$createPlugin((ProductInfoBasedIdeManager)this.receiver, p1, p2, p3, p4);
            }
        };
        CorePluginManager corePluginManager2 = new CorePluginManager(new /* invalid duplicate definition of identical inner class */);
        return corePluginManager2.loadCorePlugins(idePath, ideVersion);
    }

    /*
     * WARNING - void declaration
     */
    private final CompositeResourceResolver getPlatformResourceResolver(ProductInfo productInfo, Path idePath) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = productInfo.getLayout();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            NamedResourceResolver namedResourceResolver;
            NamedResourceResolver namedResourceResolver2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            LayoutComponent it = (LayoutComponent)element$iv$iv;
            boolean bl2 = false;
            if (it instanceof LayoutComponent.Classpathable) {
                namedResourceResolver2 = this.getResourceResolver(it, idePath);
            } else {
                ProductInfoBasedIdeManagerKt.access$getLOG$p().atDebug().log("No classpath declared for '{}'. Skipping", (Object)it);
                namedResourceResolver2 = null;
            }
            if (namedResourceResolver2 == null) continue;
            NamedResourceResolver it$iv$iv = namedResourceResolver = namedResourceResolver2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List resourceResolvers = (List)destination$iv$iv;
        return new CompositeResourceResolver(resourceResolvers);
    }

    private final PluginWithArtifactPathResult createModule(Path pluginArtifactPath, String descriptorName, ResourceResolver pathResolver, IdeVersion ideVersion) {
        return this.withPath(IdePluginManager.createBundledModule$default(IdePluginManager.Companion.createManager(pathResolver), pluginArtifactPath, ideVersion, descriptorName, null, 8, null), pluginArtifactPath);
    }

    private final PluginWithArtifactPathResult createPlugin(Path pluginArtifactPath, String descriptorPath, ResourceResolver resourceResolver, IdeVersion ideVersion) {
        return this.withPath(IdePluginManager.createBundledPlugin$default(IdePluginManager.Companion.createManager(resourceResolver), pluginArtifactPath, ideVersion, descriptorPath, null, 8, null), pluginArtifactPath);
    }

    static /* synthetic */ PluginWithArtifactPathResult createPlugin$default(ProductInfoBasedIdeManager productInfoBasedIdeManager, Path path, String string2, ResourceResolver resourceResolver, IdeVersion ideVersion, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "plugin.xml";
        }
        return productInfoBasedIdeManager.createPlugin(path, string2, resourceResolver, ideVersion);
    }

    private final IdeVersion createIdeVersion(ProductInfo productInfo) {
        ProductInfo productInfo2;
        StringBuilder stringBuilder;
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        ProductInfo $this$with = productInfo2 = productInfo;
        boolean bl2 = false;
        CharSequence charSequence = $this$with.getProductCode();
        if (charSequence.length() > 0) {
            $this$buildString.append($this$with.getProductCode()).append("-");
        }
        $this$buildString.append($this$with.getBuildNumber());
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        String versionString = string2;
        IdeVersion ideVersion = IdeVersion.createIdeVersion(versionString);
        Intrinsics.checkNotNullExpressionValue(ideVersion, "IdeVersion.createIdeVersion(versionString)");
        return ideVersion;
    }

    /*
     * WARNING - void declaration
     */
    private final NamedResourceResolver getResourceResolver(LayoutComponent layoutComponent, Path idePath) {
        NamedResourceResolver namedResourceResolver;
        if (layoutComponent instanceof LayoutComponent.Classpathable) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((LayoutComponent.Classpathable)((Object)layoutComponent)).getClasspath();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void jarPath;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Path fullyQualifiedJarFile = idePath.resolve((Path)jarPath);
                NamedResourceResolver namedResourceResolver2 = new NamedResourceResolver(layoutComponent.getName() + "#" + (Path)jarPath, new JarFilesResourceResolver(CollectionsKt.listOf(fullyQualifiedJarFile)));
                collection.add(namedResourceResolver2);
            }
            List itemJarResolvers = (List)destination$iv$iv;
            namedResourceResolver = new NamedResourceResolver(layoutComponent.getName(), new CompositeResourceResolver(itemJarResolvers));
        } else {
            namedResourceResolver = null;
        }
        return namedResourceResolver;
    }

    private final boolean containsProductInfoJson(Path $this$containsProductInfoJson) {
        Path path = $this$containsProductInfoJson.resolve("product-info.json");
        Intrinsics.checkNotNullExpressionValue(path, "resolve(PRODUCT_INFO_JSON)");
        return FileUtilKt.exists(path);
    }

    private final Path getProductInfoJson(Path $this$productInfoJson) {
        Path path = $this$productInfoJson.resolve("product-info.json");
        Intrinsics.checkNotNullExpressionValue(path, "resolve(PRODUCT_INFO_JSON)");
        return path;
    }

    private final void assertProductInfoPresent(Path idePath) throws InvalidIdeException {
        if (!this.containsProductInfoJson(idePath)) {
            throw (Throwable)new InvalidIdeException(idePath, "The 'product-info.json' file is not available.");
        }
    }

    public final boolean supports(@NotNull Path idePath) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        return this.containsProductInfoJson(idePath) && this.isAtLeastVersion(idePath, "242");
    }

    private final boolean isAtLeastVersion(Path idePath, String expectedVersion) {
        boolean bl;
        IdeVersionResolution version = new BuildTxtIdeVersionProvider().readIdeVersion(idePath);
        if (version instanceof IdeVersionResolution.Found) {
            bl = ((IdeVersionResolution.Found)version).getIdeVersion().compareTo(IdeVersion.createIdeVersion(expectedVersion)) > 0;
        } else if (version instanceof IdeVersionResolution.Failed || version instanceof IdeVersionResolution.NotFound) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private final PluginWithArtifactPathResult withPath(PluginCreationResult<? extends IdePlugin> $this$withPath, Path pluginArtifactPath) {
        PluginWithArtifactPathResult pluginWithArtifactPathResult;
        PluginCreationResult<? extends IdePlugin> pluginCreationResult = $this$withPath;
        if (pluginCreationResult instanceof PluginCreationSuccess) {
            pluginWithArtifactPathResult = new PluginWithArtifactPathResult.Success(pluginArtifactPath, (IdePlugin)((PluginCreationSuccess)$this$withPath).getPlugin());
        } else if (pluginCreationResult instanceof PluginCreationFail) {
            pluginWithArtifactPathResult = new PluginWithArtifactPathResult.Failure(pluginArtifactPath);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pluginWithArtifactPathResult;
    }

    public static final /* synthetic */ PluginWithArtifactPathResult access$createModule(ProductInfoBasedIdeManager $this, Path pluginArtifactPath, String descriptorName, ResourceResolver pathResolver, IdeVersion ideVersion) {
        return $this.createModule(pluginArtifactPath, descriptorName, pathResolver, ideVersion);
    }

    public static final /* synthetic */ PluginWithArtifactPathResult access$createPlugin(ProductInfoBasedIdeManager $this, Path pluginArtifactPath, String descriptorPath, ResourceResolver resourceResolver, IdeVersion ideVersion) {
        return $this.createPlugin(pluginArtifactPath, descriptorPath, resourceResolver, ideVersion);
    }
}

