/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.EmptyResolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResourceBundleNameSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u00013B\u001d\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\rH\u0016J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\rH\u0016J\u0010\u0010&\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH\u0002J\"\u0010'\u001a\u00020\"2\u0018\u0010(\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0*\u0012\u0004\u0012\u00020\"0)H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010#\u001a\u00020\rH\u0016J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020.0*2\u0006\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\rH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0018\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00120\u0019j\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0012`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/CompositeResolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "resolvers", "", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "(Ljava/util/List;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;)V", "allBundleNameSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "getAllBundleNameSet", "()Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "allClasses", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getAllClasses", "()Ljava/util/HashSet;", "allPackages", "", "getAllPackages", "()Ljava/util/Set;", "baseBundleNameToResolvers", "", "", "fullBundleNames", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "packageToResolvers", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "buildIndex", "", "close", "containsClass", "", "className", "containsPackage", "packageName", "getPackageName", "processAllClasses", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "Lorg/objectweb/asm/tree/ClassNode;", "resolveClass", "resolveExactPropertyResourceBundle", "Ljava/util/PropertyResourceBundle;", "baseName", "locale", "Ljava/util/Locale;", "toString", "Companion", "structure-classes"})
@SourceDebugExtension(value={"SMAP\nCompositeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/CompositeResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,127:1\n361#2,7:128\n361#2,7:135\n361#2,7:142\n1446#3,5:149\n1747#3,3:156\n1206#4,2:154\n*E\n*S KotlinDebug\n*F\n+ 1 CompositeResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/CompositeResolver\n*L\n32#1,7:128\n37#1,7:135\n41#1,7:142\n48#1,5:149\n64#1,3:156\n57#1,2:154\n*E\n"})
public final class CompositeResolver
extends Resolver {
    private final Map<String, List<Resolver>> packageToResolvers;
    private final HashMap<String, Set<String>> fullBundleNames;
    private final Map<String, List<Resolver>> baseBundleNameToResolvers;
    private final List<Resolver> resolvers;
    @NotNull
    private final Resolver.ReadMode readMode;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final void buildIndex() {
        for (Resolver resolver : this.resolvers) {
            for (String packageName : resolver.getAllPackages()) {
                List list;
                Map<String, List<Resolver>> $this$getOrPut$iv = this.packageToResolvers;
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(packageName);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(packageName, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                Collection collection = list;
                collection.add(resolver);
            }
            ResourceBundleNameSet bundleNameSet = resolver.getAllBundleNameSet();
            for (String baseBundleName : bundleNameSet.getBaseBundleNames()) {
                Object object;
                List list;
                Object $this$getOrPut$iv = this.baseBundleNameToResolvers;
                boolean $i$f$getOrPut22 = false;
                List value$iv = $this$getOrPut$iv.get(baseBundleName);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(baseBundleName, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                $this$getOrPut$iv = list;
                $this$getOrPut$iv.add(resolver);
                Set<String> resolverAllNames = bundleNameSet.get(baseBundleName);
                Collection $i$f$getOrPut22 = resolverAllNames;
                if (!(!$i$f$getOrPut22.isEmpty())) continue;
                Map $this$getOrPut$iv2 = this.fullBundleNames;
                boolean $i$f$getOrPut = false;
                Object value$iv2 = $this$getOrPut$iv2.get(baseBundleName);
                if (value$iv2 == null) {
                    boolean bl = false;
                    Set answer$iv = new HashSet();
                    $this$getOrPut$iv2.put(baseBundleName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv2;
                }
                Collection collection = (Set)object;
                CollectionsKt.addAll(collection, (Iterable)resolverAllNames);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public HashSet<String> getAllClasses() {
        void var2_2;
        void $this$flatMapTo$iv;
        Iterable iterable = this.resolvers;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Resolver it = (Resolver)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getAllClasses();
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return (HashSet)var2_2;
    }

    @Override
    @NotNull
    public ResourceBundleNameSet getAllBundleNameSet() {
        return new ResourceBundleNameSet((Map<String, ? extends Set<String>>)this.fullBundleNames);
    }

    @Override
    @NotNull
    public Set<String> getAllPackages() {
        return this.packageToResolvers.keySet();
    }

    @Override
    public boolean processAllClasses(@NotNull Function1<? super ResolutionResult<? extends ClassNode>, Boolean> processor) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(processor, "processor");
            Sequence $this$all$iv = CollectionsKt.asSequence((Iterable)this.resolvers);
            boolean $i$f$all = false;
            Iterator iterator2 = $this$all$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Resolver it = (Resolver)element$iv;
                boolean bl2 = false;
                if (it.processAllClasses(processor)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private final String getPackageName(String className) {
        return StringsKt.substringBeforeLast(className, '/', "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean containsClass(@NotNull String className) {
        Resolver it;
        Intrinsics.checkNotNullParameter(className, "className");
        String packageName = this.getPackageName(className);
        List<Resolver> resolvers = this.packageToResolvers.get(packageName);
        if (resolvers == null) return false;
        Iterable $this$any$iv = resolvers;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (Resolver)element$iv;
            boolean bl = false;
        } while (!it.containsClass(className));
        return true;
    }

    @Override
    public boolean containsPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Map<String, List<Resolver>> map2 = this.packageToResolvers;
        return map2.containsKey(packageName);
    }

    @Override
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        String packageName = this.getPackageName(className);
        List<Resolver> resolvers = this.packageToResolvers.get(packageName);
        if (resolvers == null || resolvers.isEmpty()) {
            return ResolutionResult.NotFound.INSTANCE;
        }
        for (Resolver resolver : resolvers) {
            ResolutionResult<ClassNode> resolutionResult = resolver.resolveClass(className);
            if (resolutionResult instanceof ResolutionResult.NotFound) continue;
            return resolutionResult;
        }
        return ResolutionResult.NotFound.INSTANCE;
    }

    @Override
    @NotNull
    public ResolutionResult<PropertyResourceBundle> resolveExactPropertyResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(locale, "locale");
        List<Resolver> resolvers = this.baseBundleNameToResolvers.get(baseName);
        if (resolvers == null || resolvers.isEmpty()) {
            return ResolutionResult.NotFound.INSTANCE;
        }
        for (Resolver resolver : resolvers) {
            ResolutionResult<PropertyResourceBundle> resolutionResult = resolver.resolveExactPropertyResourceBundle(baseName, locale);
            if (resolutionResult instanceof ResolutionResult.NotFound) continue;
            return resolutionResult;
        }
        return ResolutionResult.NotFound.INSTANCE;
    }

    @Override
    public void close() {
        LanguageUtilsKt.closeAll(this.resolvers);
    }

    @NotNull
    public String toString() {
        return "Union of " + this.resolvers.size() + " resolver" + (this.resolvers.size() != 1 ? "s" : "");
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return this.readMode;
    }

    private CompositeResolver(List<? extends Resolver> resolvers, Resolver.ReadMode readMode) {
        this.resolvers = resolvers;
        this.readMode = readMode;
        this.packageToResolvers = new HashMap();
        this.fullBundleNames = new HashMap();
        this.baseBundleNameToResolvers = new HashMap();
        this.buildIndex();
    }

    public /* synthetic */ CompositeResolver(List resolvers, Resolver.ReadMode readMode, DefaultConstructorMarker $constructor_marker) {
        this(resolvers, readMode);
    }

    @JvmStatic
    @NotNull
    public static final Resolver create(Resolver ... resolvers) {
        return Companion.create(resolvers);
    }

    @JvmStatic
    @NotNull
    public static final Resolver create(@NotNull Iterable<? extends Resolver> resolvers) {
        return Companion.create(resolvers);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/CompositeResolver$Companion;", "", "()V", "create", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "resolvers", "", "([Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;)Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "", "structure-classes"})
    @SourceDebugExtension(value={"SMAP\nCompositeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/CompositeResolver$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1726#2,3:128\n*E\n*S KotlinDebug\n*F\n+ 1 CompositeResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/CompositeResolver$Companion\n*L\n118#1,3:128\n*E\n"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Resolver create(Resolver ... resolvers) {
            Intrinsics.checkNotNullParameter(resolvers, "resolvers");
            return this.create(ArraysKt.asIterable(resolvers));
        }

        @JvmStatic
        @NotNull
        public final Resolver create(@NotNull Iterable<? extends Resolver> resolvers) {
            boolean bl;
            List<? extends Resolver> list;
            block5: {
                Intrinsics.checkNotNullParameter(resolvers, "resolvers");
                list = CollectionsKt.toList(resolvers);
                if (list.isEmpty()) {
                    return EmptyResolver.INSTANCE;
                }
                if (list.size() == 1) {
                    return CollectionsKt.first(list);
                }
                Iterable $this$all$iv = list;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Resolver it = (Resolver)element$iv;
                        boolean bl2 = false;
                        if (it.getReadMode() == Resolver.ReadMode.FULL) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            Resolver.ReadMode readMode = bl ? Resolver.ReadMode.FULL : Resolver.ReadMode.SIGNATURES;
            return new CompositeResolver(list, readMode, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

