/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000e\u001a\n\u0010\u0019\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u001a\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\u0005\u001a\n\u0010\u001d\u001a\u00020\u000b*\u00020\u0005\u001a\n\u0010\u001e\u001a\u00020\u000b*\u00020\u0005\u001a\n\u0010\u001f\u001a\u00020\u000b*\u00020\u0005\u001a7\u0010 \u001a\u00020\u001c*\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\"2!\u0010#\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u001c0$\u001a\n\u0010(\u001a\u00020\u001c*\u00020\u0005\u001a\n\u0010)\u001a\u00020\u001c*\u00020\u0005\u001a\u0012\u0010*\u001a\u00020\u000b*\u00020\u00052\u0006\u0010+\u001a\u00020\u0004\u001a\n\u0010,\u001a\u00020-*\u00020\u0005\u001a\n\u0010.\u001a\u00020\u000b*\u00020\u0005\u001a\n\u0010/\u001a\u00020\u000b*\u00020\u0005\u001a\u0018\u00100\u001a\u0010\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00050\u000501*\u00020\u0005\u001a\u0010\u00102\u001a\b\u0012\u0004\u0012\u00020\u000501*\u00020\u0005\u001a\u0010\u00103\u001a\b\u0012\u0004\u0012\u00020\u000501*\u00020\u0005\u001a \u00104\u001a\u0010\u0012\f\u0012\n \u0002*\u0004\u0018\u00010\u00050\u000501*\u00020\u00052\u0006\u0010\b\u001a\u00020\u0004\u001a\n\u00105\u001a\u000206*\u00020\u0005\u001a\n\u00107\u001a\u000208*\u00020\u0005\u001a\u001a\u00109\u001a\b\u0012\u0004\u0012\u00020\u000401*\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\"\u001a\u0014\u0010:\u001a\u00020\u0004*\u00020\u00052\b\b\u0002\u0010!\u001a\u00020\"\u001a\n\u0010;\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010<\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010=\u001a\u00020\u0004*\u00020\u0004\u001a\u0012\u0010>\u001a\u00020\u0004*\u00020\u00042\u0006\u0010?\u001a\u00020\u0005\u001a\n\u0010@\u001a\u00020\u0004*\u00020\u0004\u001a\u0012\u0010A\u001a\u00020\u001c*\u00020\u00052\u0006\u0010B\u001a\u000208\u001a\u001c\u0010C\u001a\u00020\u001c*\u00020\u00052\u0006\u0010D\u001a\u00020\u00042\b\b\u0002\u0010!\u001a\u00020\"\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\"\u0015\u0010\n\u001a\u00020\u000b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\"\u0015\u0010\r\u001a\u00020\u000b*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\f\"\u0015\u0010\u000e\u001a\u00020\u000f*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007\"\u0019\u0010\u0014\u001a\u00060\u000fj\u0002`\u0015*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0011\"\u0015\u0010\u0017\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007*\n\u0010E\"\u00020\u000f2\u00020\u000f\u00a8\u0006F"}, d2={"LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "description", "", "Ljava/nio/file/Path;", "getDescription", "(Ljava/nio/file/Path;)Ljava/lang/String;", "extension", "getExtension", "isDirectory", "", "(Ljava/nio/file/Path;)Z", "isFile", "length", "", "getLength", "(Ljava/nio/file/Path;)J", "nameWithoutExtension", "getNameWithoutExtension", "pluginSize", "Lcom/jetbrains/plugin/structure/base/utils/Bytes;", "getPluginSize", "simpleName", "getSimpleName", "create", "createDir", "createParentDirs", "", "deleteLogged", "deleteQuietly", "exists", "forEachLine", "charset", "Ljava/nio/charset/Charset;", "action", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "line", "forceDeleteIfExists", "forceRemoveDirectory", "hasExtension", "expected", "inputStream", "Ljava/io/InputStream;", "isJar", "isZip", "listAllFiles", "", "listFiles", "listJars", "listRecursivelyAllFilesWithExtension", "outputStream", "Ljava/io/OutputStream;", "readBytes", "", "readLines", "readText", "replaceInvalidFileNameCharacters", "toSystemDependentName", "toSystemIndependentName", "withPathSeparatorOf", "path", "withZipFsSeparator", "writeBytes", "bytes", "writeText", "text", "Bytes", "structure-base"})
@SourceDebugExtension(value={"SMAP\nFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtil.kt\ncom/jetbrains/plugin/structure/base/utils/FileUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1#2:176\n766#3:177\n857#3,2:178\n*E\n*S KotlinDebug\n*F\n+ 1 FileUtil.kt\ncom/jetbrains/plugin/structure/base/utils/FileUtilKt\n*L\n112#1:177\n112#1,2:178\n*E\n"})
public final class FileUtilKt {
    private static final Logger LOG = LoggerFactory.getLogger("structure.FileUtil");

    public static final boolean isZip(@NotNull Path $this$isZip) {
        Intrinsics.checkNotNullParameter($this$isZip, "$this$isZip");
        return FileUtilKt.hasExtension($this$isZip, "zip");
    }

    public static final boolean isJar(@NotNull Path $this$isJar) {
        Intrinsics.checkNotNullParameter($this$isJar, "$this$isJar");
        return FileUtilKt.hasExtension($this$isJar, "jar");
    }

    public static final boolean hasExtension(@NotNull Path $this$hasExtension, @NotNull String expected) {
        Intrinsics.checkNotNullParameter($this$hasExtension, "$this$hasExtension");
        Intrinsics.checkNotNullParameter(expected, "expected");
        return Files.isRegularFile($this$hasExtension, new LinkOption[0]) && Intrinsics.areEqual(expected, FileUtilKt.getExtension($this$hasExtension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> listRecursivelyAllFilesWithExtension(@NotNull Path $this$listRecursivelyAllFilesWithExtension, @NotNull String extension) {
        List<Path> list;
        Intrinsics.checkNotNullParameter($this$listRecursivelyAllFilesWithExtension, "$this$listRecursivelyAllFilesWithExtension");
        Intrinsics.checkNotNullParameter(extension, "extension");
        AutoCloseable autoCloseable = Files.walk($this$listRecursivelyAllFilesWithExtension, FileVisitOption.FOLLOW_LINKS);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            Stream stream2 = stream.filter(new Predicate(extension){
                final /* synthetic */ String $extension$inlined;
                {
                    this.$extension$inlined = string2;
                }

                public final boolean test(Path it) {
                    return StringsKt.endsWith$default(((Object)it).toString(), "." + this.$extension$inlined, false, 2, null);
                }
            });
            Intrinsics.checkNotNullExpressionValue(stream2, "stream.filter { it.toStr\u2026dsWith(\".${extension}\") }");
            list = StreamsKt.toList(stream2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return list;
    }

    @NotNull
    public static final String withPathSeparatorOf(@NotNull String $this$withPathSeparatorOf, @NotNull Path path) {
        Intrinsics.checkNotNullParameter($this$withPathSeparatorOf, "$this$withPathSeparatorOf");
        Intrinsics.checkNotNullParameter(path, "path");
        String string2 = StringsKt.replace$default($this$withPathSeparatorOf, '\\', '/', false, 4, null);
        FileSystem fileSystem = path.getFileSystem();
        Intrinsics.checkNotNullExpressionValue(fileSystem, "path.fileSystem");
        String string3 = fileSystem.getSeparator();
        Intrinsics.checkNotNullExpressionValue(string3, "path.fileSystem.separator");
        return StringsKt.replace$default(string2, "/", string3, false, 4, null);
    }

    @NotNull
    public static final String withZipFsSeparator(@NotNull String $this$withZipFsSeparator) {
        Intrinsics.checkNotNullParameter($this$withZipFsSeparator, "$this$withZipFsSeparator");
        return StringsKt.replace$default($this$withZipFsSeparator, '\\', '/', false, 4, null);
    }

    @NotNull
    public static final String toSystemIndependentName(@NotNull String $this$toSystemIndependentName) {
        Intrinsics.checkNotNullParameter($this$toSystemIndependentName, "$this$toSystemIndependentName");
        return StringsKt.replace$default($this$toSystemIndependentName, '\\', '/', false, 4, null);
    }

    @NotNull
    public static final String toSystemDependentName(@NotNull String $this$toSystemDependentName) {
        Intrinsics.checkNotNullParameter($this$toSystemDependentName, "$this$toSystemDependentName");
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkNotNullExpressionValue(fileSystem, "FileSystems.getDefault()");
        String string2 = fileSystem.getSeparator();
        Intrinsics.checkNotNullExpressionValue(string2, "FileSystems.getDefault().separator");
        return StringsKt.replace$default($this$toSystemDependentName, "/", string2, false, 4, null);
    }

    @NotNull
    public static final String replaceInvalidFileNameCharacters(@NotNull String $this$replaceInvalidFileNameCharacters) {
        Intrinsics.checkNotNullParameter($this$replaceInvalidFileNameCharacters, "$this$replaceInvalidFileNameCharacters");
        CharSequence charSequence = $this$replaceInvalidFileNameCharacters;
        Regex regex = new Regex("[^a-zA-Z0-9.#\\-() ]");
        String string2 = "_";
        return regex.replace(charSequence, string2);
    }

    @NotNull
    public static final InputStream inputStream(@NotNull Path $this$inputStream) {
        Intrinsics.checkNotNullParameter($this$inputStream, "$this$inputStream");
        InputStream inputStream2 = Files.newInputStream($this$inputStream, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue(inputStream2, "Files.newInputStream(this)");
        return inputStream2;
    }

    @NotNull
    public static final OutputStream outputStream(@NotNull Path $this$outputStream) {
        Intrinsics.checkNotNullParameter($this$outputStream, "$this$outputStream");
        OutputStream outputStream2 = Files.newOutputStream($this$outputStream, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue(outputStream2, "Files.newOutputStream(this)");
        return outputStream2;
    }

    public static final void writeText(@NotNull Path $this$writeText, @NotNull String text, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$writeText, "$this$writeText");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(charset, "charset");
        String string2 = text;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        FileUtilKt.writeBytes($this$writeText, byArray);
    }

    public static /* synthetic */ void writeText$default(Path path, String string2, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        FileUtilKt.writeText(path, string2, charset);
    }

    @NotNull
    public static final String readText(@NotNull Path $this$readText, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$readText, "$this$readText");
        Intrinsics.checkNotNullParameter(charset, "charset");
        byte[] byArray = Files.readAllBytes($this$readText);
        Intrinsics.checkNotNullExpressionValue(byArray, "Files.readAllBytes(this)");
        byte[] byArray2 = byArray;
        return new String(byArray2, charset);
    }

    public static /* synthetic */ String readText$default(Path path, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileUtilKt.readText(path, charset);
    }

    @NotNull
    public static final List<String> readLines(@NotNull Path $this$readLines, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter($this$readLines, "$this$readLines");
        Intrinsics.checkNotNullParameter(charset, "charset");
        ArrayList result2 = new ArrayList();
        FileUtilKt.forEachLine($this$readLines, charset, (Function1<? super String, Unit>)new Function1<String, Unit>(result2){
            final /* synthetic */ ArrayList $result;

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.$result.add(it);
            }
            {
                this.$result = arrayList;
                super(1);
            }
        });
        return result2;
    }

    public static /* synthetic */ List readLines$default(Path path, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return FileUtilKt.readLines(path, charset);
    }

    public static final void forEachLine(@NotNull Path $this$forEachLine, @NotNull Charset charset, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter($this$forEachLine, "$this$forEachLine");
        Intrinsics.checkNotNullParameter(charset, "charset");
        Intrinsics.checkNotNullParameter(action, "action");
        TextStreamsKt.forEachLine(new BufferedReader(new InputStreamReader(Files.newInputStream($this$forEachLine, new OpenOption[0]), charset)), action);
    }

    public static /* synthetic */ void forEachLine$default(Path path, Charset charset, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        FileUtilKt.forEachLine(path, charset, function1);
    }

    @NotNull
    public static final byte[] readBytes(@NotNull Path $this$readBytes) {
        Intrinsics.checkNotNullParameter($this$readBytes, "$this$readBytes");
        byte[] byArray = Files.readAllBytes($this$readBytes);
        Intrinsics.checkNotNullExpressionValue(byArray, "Files.readAllBytes(this)");
        return byArray;
    }

    public static final void writeBytes(@NotNull Path $this$writeBytes, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter($this$writeBytes, "$this$writeBytes");
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        Files.write($this$writeBytes, bytes, new OpenOption[0]);
    }

    @NotNull
    public static final Path createDir(@NotNull Path $this$createDir) {
        Intrinsics.checkNotNullParameter($this$createDir, "$this$createDir");
        Files.createDirectories($this$createDir, new FileAttribute[0]);
        return $this$createDir;
    }

    @NotNull
    public static final Path create(@NotNull Path $this$create) {
        Intrinsics.checkNotNullParameter($this$create, "$this$create");
        if ($this$create.getParent() != null) {
            Files.createDirectories($this$create.getParent(), new FileAttribute[0]);
        }
        Files.createFile($this$create, new FileAttribute[0]);
        return $this$create;
    }

    public static final void createParentDirs(@NotNull Path $this$createParentDirs) {
        block0: {
            Intrinsics.checkNotNullParameter($this$createParentDirs, "$this$createParentDirs");
            Path path = $this$createParentDirs.getParent();
            if (path == null) break block0;
            FileUtilKt.createDir(path);
        }
    }

    public static final void forceDeleteIfExists(@NotNull Path $this$forceDeleteIfExists) {
        Intrinsics.checkNotNullParameter($this$forceDeleteIfExists, "$this$forceDeleteIfExists");
        if (Files.exists($this$forceDeleteIfExists, new LinkOption[0])) {
            if (Files.isDirectory($this$forceDeleteIfExists, new LinkOption[0])) {
                FileUtilKt.forceRemoveDirectory($this$forceDeleteIfExists);
            } else {
                Files.delete($this$forceDeleteIfExists);
            }
        }
    }

    public static final boolean deleteLogged(@NotNull Path $this$deleteLogged) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$deleteLogged, "$this$deleteLogged");
        try {
            FileUtilKt.forceDeleteIfExists($this$deleteLogged);
            bl = true;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.info("Cannot delete file because of interruption:  " + $this$deleteLogged);
            bl = false;
        }
        catch (Exception e) {
            LOG.error("Unable to delete " + $this$deleteLogged, e);
            bl = false;
        }
        return bl;
    }

    public static final boolean exists(@NotNull Path $this$exists) {
        Intrinsics.checkNotNullParameter($this$exists, "$this$exists");
        return Files.exists($this$exists, new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> listFiles(@NotNull Path $this$listFiles) {
        List<Path> list;
        Intrinsics.checkNotNullParameter($this$listFiles, "$this$listFiles");
        if (!FileUtilKt.isDirectory($this$listFiles)) {
            return CollectionsKt.emptyList();
        }
        AutoCloseable autoCloseable = Files.list($this$listFiles);
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl = false;
            List<Path> list2 = it.collect(Collectors.toList());
            list = list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        Intrinsics.checkNotNullExpressionValue(list, "Files.list(this).use { i\u2026ct(Collectors.toList()) }");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Path> listJars(@NotNull Path $this$listJars) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$listJars, "$this$listJars");
        Iterable $this$filter$iv = FileUtilKt.listFiles($this$listJars);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!FileUtilKt.isJar(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<Path> listAllFiles(@NotNull Path $this$listAllFiles) {
        List<Path> list;
        Intrinsics.checkNotNullParameter($this$listAllFiles, "$this$listAllFiles");
        AutoCloseable autoCloseable = Files.walk($this$listAllFiles, new FileVisitOption[0]);
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            Stream stream2 = stream.filter(listAllFiles.1.1.INSTANCE).map(new Function($this$listAllFiles){
                final /* synthetic */ Path $this_listAllFiles$inlined;
                {
                    this.$this_listAllFiles$inlined = path;
                }

                public final Path apply(Path it) {
                    return this.$this_listAllFiles$inlined.relativize(it);
                }
            });
            Intrinsics.checkNotNullExpressionValue(stream2, "stream.filter { it.isFil\u2026p { this.relativize(it) }");
            list = StreamsKt.toList(stream2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
        return list;
    }

    public static final boolean deleteQuietly(@NotNull Path $this$deleteQuietly) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$deleteQuietly, "$this$deleteQuietly");
        try {
            if (FileUtilKt.isDirectory($this$deleteQuietly)) {
                FileUtilKt.forceRemoveDirectory($this$deleteQuietly);
            } else {
                Files.delete($this$deleteQuietly);
            }
            bl = true;
        }
        catch (Exception ignored) {
            bl = false;
        }
        return bl;
    }

    public static final void forceRemoveDirectory(@NotNull Path $this$forceRemoveDirectory) {
        Intrinsics.checkNotNullParameter($this$forceRemoveDirectory, "$this$forceRemoveDirectory");
        Files.walkFileTree($this$forceRemoveDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @NotNull
            public FileVisitResult visitFile(@NotNull Path file2, @NotNull BasicFileAttributes attrs) throws IOException {
                Intrinsics.checkNotNullParameter(file2, "file");
                Intrinsics.checkNotNullParameter(attrs, "attrs");
                Files.delete(file2);
                return FileVisitResult.CONTINUE;
            }

            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir2, @Nullable IOException exc) throws IOException {
                Intrinsics.checkNotNullParameter(dir2, "dir");
                Files.delete(dir2);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static final boolean isDirectory(@NotNull Path $this$isDirectory) {
        Intrinsics.checkNotNullParameter($this$isDirectory, "$this$isDirectory");
        return Files.isDirectory($this$isDirectory, new LinkOption[0]);
    }

    public static final boolean isFile(@NotNull Path $this$isFile) {
        Intrinsics.checkNotNullParameter($this$isFile, "$this$isFile");
        return Files.isRegularFile($this$isFile, new LinkOption[0]);
    }

    @NotNull
    public static final String getSimpleName(@NotNull Path $this$simpleName) {
        Intrinsics.checkNotNullParameter($this$simpleName, "$this$simpleName");
        Path path = $this$simpleName.getFileName();
        return (path != null ? (Comparable)path : (Comparable)((Object)"")).toString();
    }

    @NotNull
    public static final String getNameWithoutExtension(@NotNull Path $this$nameWithoutExtension) {
        Intrinsics.checkNotNullParameter($this$nameWithoutExtension, "$this$nameWithoutExtension");
        return StringsKt.substringBeforeLast$default(FileUtilKt.getSimpleName($this$nameWithoutExtension), ".", null, 2, null);
    }

    @NotNull
    public static final String getExtension(@NotNull Path $this$extension) {
        Intrinsics.checkNotNullParameter($this$extension, "$this$extension");
        return StringsKt.substringAfterLast(FileUtilKt.getSimpleName($this$extension), ".", "");
    }

    public static final long getLength(@NotNull Path $this$length) {
        Intrinsics.checkNotNullParameter($this$length, "$this$length");
        return Files.size($this$length);
    }

    public static final long getPluginSize(@NotNull Path $this$pluginSize) {
        Intrinsics.checkNotNullParameter($this$pluginSize, "$this$pluginSize");
        return FileUtilKt.isZip($this$pluginSize) || FileUtilKt.isJar($this$pluginSize) ? Files.size($this$pluginSize) : -1L;
    }

    @NotNull
    public static final String getDescription(@NotNull Path $this$description) {
        Intrinsics.checkNotNullParameter($this$description, "$this$description");
        return Intrinsics.areEqual($this$description.getFileSystem(), FileSystems.getDefault()) ? ((Object)$this$description).toString() : $this$description.getFileSystem() + "!" + $this$description;
    }
}

