/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class WeakHashSet<T>
extends AbstractSet<T> {
    private final Set<MyRef<T>> set = new HashSet<MyRef<T>>();
    private final ReferenceQueue<T> queue = new ReferenceQueue();

    WeakHashSet() {
    }

    @Override
    public Iterator<T> iterator() {
        return ContainerUtil.filterIterator(ContainerUtil.mapIterator(this.set.iterator(), Reference::get), Objects::nonNull);
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean add(@NotNull T t2) {
        if (t2 == null) {
            WeakHashSet.$$$reportNull$$$0(0);
        }
        this.processQueue();
        MyRef<T> ref = new MyRef<T>(t2, this.queue);
        return this.set.add(ref);
    }

    @Override
    public boolean remove(@NotNull Object o) {
        if (o == null) {
            WeakHashSet.$$$reportNull$$$0(1);
        }
        this.processQueue();
        return this.set.remove(new HardRef<Object>(o));
    }

    @Override
    public boolean contains(@NotNull Object o) {
        if (o == null) {
            WeakHashSet.$$$reportNull$$$0(2);
        }
        this.processQueue();
        return this.set.contains(new HardRef<Object>(o));
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    private void processQueue() {
        MyRef ref;
        while ((ref = (MyRef)this.queue.poll()) != null) {
            this.set.remove(ref);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/containers/WeakHashSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HardRef<T>
    extends MyRef<T> {
        HardRef(@NotNull T referent) {
            if (referent == null) {
                HardRef.$$$reportNull$$$0(0);
            }
            super(referent, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/util/containers/WeakHashSet$HardRef", "<init>"));
        }
    }

    private static class MyRef<T>
    extends WeakReference<T> {
        private final int myHashCode;

        MyRef(@NotNull T referent, ReferenceQueue<? super T> q) {
            if (referent == null) {
                MyRef.$$$reportNull$$$0(0);
            }
            super(referent, q);
            this.myHashCode = referent.hashCode();
        }

        public int hashCode() {
            return this.myHashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MyRef)) {
                return false;
            }
            MyRef otherRef = (MyRef)obj;
            if (this instanceof HardRef || otherRef instanceof HardRef) {
                return Comparing.equal(otherRef.get(), this.get());
            }
            return this == obj;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referent", "com/intellij/util/containers/WeakHashSet$MyRef", "<init>"));
        }
    }
}

