/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.RefHashMap;
import com.intellij.util.containers.RefValueHashMapUtil;
import java.lang.ref.ReferenceQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

abstract class RefKeyRefValueHashMap<K, V>
implements Map<K, V> {
    private final RefHashMap<K, ValueReference<K, V>> myMap;
    private final ReferenceQueue<V> myQueue;

    RefKeyRefValueHashMap(@NotNull RefHashMap<K, ValueReference<K, V>> weakKeyMap) {
        if (weakKeyMap == null) {
            RefKeyRefValueHashMap.$$$reportNull$$$0(0);
        }
        this.myQueue = new ReferenceQueue();
        this.myMap = weakKeyMap;
    }

    protected V dereference(ValueReference<K, ? extends V> reference) {
        return reference == null ? null : (V)reference.get();
    }

    @NotNull
    protected abstract ValueReference<K, V> createValueReference(@NotNull RefHashMap.Key<K> var1, V var2, ReferenceQueue<? super V> var3);

    boolean processQueue() {
        ValueReference ref;
        boolean processed = this.myMap.processQueue();
        while ((ref = (ValueReference)((Object)this.myQueue.poll())) != null) {
            RefHashMap.Key weakKey = ref.getKey();
            this.myMap.removeKey(weakKey);
            processed = true;
        }
        return processed;
    }

    @Override
    public V get(Object key) {
        ValueReference<K, V> ref = this.myMap.get(key);
        return this.dereference(ref);
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        RefHashMap.Key<K> weakKey = this.myMap.createKey(key);
        ValueReference<K, V> reference = this.createValueReference(weakKey, value, this.myQueue);
        ValueReference<K, V> oldRef = this.myMap.putKey(weakKey, reference);
        return this.dereference(oldRef);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        ValueReference<K, V> ref = this.myMap.remove(key);
        return this.dereference(ref);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t2) {
        if (t2 == null) {
            RefKeyRefValueHashMap.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        throw RefValueHashMapUtil.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(Object value) {
        throw RefValueHashMapUtil.pointlessContainsValue();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set set = this.myMap.keySet();
        if (set == null) {
            RefKeyRefValueHashMap.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result2 = new ArrayList();
        Collection refs = this.myMap.values();
        for (ValueReference ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result2.add(value);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            RefKeyRefValueHashMap.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weakKeyMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/RefKeyRefValueHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/RefKeyRefValueHashMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface ValueReference<K, V> {
        @NotNull
        public RefHashMap.Key<K> getKey();

        public V get();
    }
}

