/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ExceptionUtil;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLogger
extends Logger {
    private static boolean ourMirrorToStderr = true;

    public DefaultLogger(String category) {
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public void debug(String message2) {
    }

    @Override
    public void debug(Throwable t2) {
    }

    @Override
    public void debug(String message2, Throwable t2) {
    }

    @Override
    public void info(String message2) {
    }

    @Override
    public void info(String message2, Throwable t2) {
    }

    @Override
    public void warn(String message2, @Nullable Throwable t2) {
        t2 = DefaultLogger.ensureNotControlFlow(t2);
        System.err.println("WARN: " + message2);
        if (t2 != null) {
            t2.printStackTrace(System.err);
        }
    }

    @Override
    public void error(String message2, @Nullable Throwable t2, String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(0);
        }
        t2 = DefaultLogger.ensureNotControlFlow(t2);
        message2 = message2 + DefaultLogger.attachmentsToString(t2);
        DefaultLogger.dumpExceptionsToStderr(message2, t2, details);
        throw new AssertionError(message2, t2);
    }

    public static void dumpExceptionsToStderr(String message2, @Nullable Throwable t2, String ... details) {
        if (details == null) {
            DefaultLogger.$$$reportNull$$$0(1);
        }
        if (DefaultLogger.shouldDumpExceptionToStderr()) {
            System.err.println("ERROR: " + message2);
            if (t2 != null) {
                t2.printStackTrace(System.err);
            }
            if (details.length > 0) {
                System.err.println("details: ");
                for (String detail : details) {
                    System.err.println(detail);
                }
            }
        }
    }

    @Override
    public void setLevel(@NotNull Level level) {
        if (level == null) {
            DefaultLogger.$$$reportNull$$$0(2);
        }
    }

    @NotNull
    public static String attachmentsToString(@Nullable Throwable t2) {
        if (t2 != null) {
            String prefix = "\n\nAttachments:\n";
            String attachments = ExceptionUtil.findCauseAndSuppressed(t2, ExceptionWithAttachments.class).stream().flatMap(e -> Stream.of(e.getAttachments())).map(ATTACHMENT_TO_STRING).collect(Collectors.joining("\n----\n", prefix, ""));
            if (!attachments.equals(prefix)) {
                String string2 = attachments;
                if (string2 == null) {
                    DefaultLogger.$$$reportNull$$$0(3);
                }
                return string2;
            }
        }
        return "";
    }

    public static boolean shouldDumpExceptionToStderr() {
        return ourMirrorToStderr;
    }

    public static void disableStderrDumping(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            DefaultLogger.$$$reportNull$$$0(4);
        }
        boolean prev = ourMirrorToStderr;
        ourMirrorToStderr = false;
        Disposer.register(parentDisposable, () -> {
            ourMirrorToStderr = prev;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/DefaultLogger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/DefaultLogger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "attachmentsToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "dumpExceptionsToStderr";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLevel";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "disableStderrDumping";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

