/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JpsPathMapper;

public class JpsWslPathMapper
implements JpsPathMapper {
    private static final String WSL_PREFIX = "//wsl$/";
    @Nullable
    private String myWslRootPrefix;

    @Override
    @Nullable
    public String mapUrl(@Nullable String url) {
        int index;
        int startPos;
        int endPos;
        if (url == null) {
            return null;
        }
        if (url.contains(WSL_PREFIX) && (endPos = url.indexOf(47, (startPos = url.indexOf(WSL_PREFIX)) + WSL_PREFIX.length())) >= 0) {
            return url.substring(0, startPos) + url.substring(endPos);
        }
        if (url.startsWith("file://")) {
            return "file://" + this.mapPath(url.substring("file://".length()));
        }
        if (url.startsWith("jar://") && (index = url.indexOf("!/")) >= 0) {
            return "jar://" + this.mapPath(url.substring("jar://".length(), index)) + url.substring(index);
        }
        return url;
    }

    @NotNull
    private String mapPath(@NotNull String path) {
        if (path == null) {
            JpsWslPathMapper.$$$reportNull$$$0(0);
        }
        if (this.myWslRootPrefix == null || path.indexOf(58) != 1) {
            String wslPath;
            try {
                wslPath = JpsWslPathMapper.runWslPath(path);
            }
            catch (IOException | InterruptedException e) {
                String string2 = path;
                if (string2 == null) {
                    JpsWslPathMapper.$$$reportNull$$$0(1);
                }
                return string2;
            }
            if (path.indexOf(58) == 1) {
                int pathLengthAfterDriveLetter = path.length() - 2;
                this.myWslRootPrefix = wslPath.substring(0, wslPath.length() - pathLengthAfterDriveLetter - 1);
            }
            String string3 = wslPath;
            if (string3 == null) {
                JpsWslPathMapper.$$$reportNull$$$0(2);
            }
            return string3;
        }
        String string4 = this.myWslRootPrefix + Character.toLowerCase(path.charAt(0)) + FileUtil.toSystemIndependentName(path.substring(2));
        if (string4 == null) {
            JpsWslPathMapper.$$$reportNull$$$0(3);
        }
        return string4;
    }

    private static String runWslPath(String path) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder("/usr/bin/wslpath", path);
        Process process = processBuilder.start();
        process.waitFor();
        if (process.exitValue() == 0) {
            return StreamUtil.readText(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8)).trim();
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/JpsWslPathMapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/JpsWslPathMapper";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "mapPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mapPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

