/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.JDOMUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JDomSerializationUtil {
    @NonNls
    public static final String COMPONENT_ELEMENT = "component";

    @Nullable
    public static Element findComponent(@Nullable Element root, @NonNls String componentName) {
        for (Element element : JDOMUtil.getChildren(root, COMPONENT_ELEMENT)) {
            if (!JDomSerializationUtil.isComponent(componentName, element)) continue;
            return element;
        }
        return null;
    }

    public static boolean isComponent(@NotNull String componentName, @NotNull Element element) {
        if (componentName == null) {
            JDomSerializationUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JDomSerializationUtil.$$$reportNull$$$0(1);
        }
        return componentName.equals(element.getAttributeValue("name"));
    }

    public static Element createComponentElement(String componentName) {
        Element element = new Element(COMPONENT_ELEMENT);
        element.setAttribute("name", componentName);
        return element;
    }

    @NotNull
    public static Element findOrCreateComponentElement(@NotNull Element root, @NotNull String componentName) {
        Element component;
        if (root == null) {
            JDomSerializationUtil.$$$reportNull$$$0(2);
        }
        if (componentName == null) {
            JDomSerializationUtil.$$$reportNull$$$0(3);
        }
        if ((component = JDomSerializationUtil.findComponent(root, componentName)) == null) {
            component = JDomSerializationUtil.createComponentElement(componentName);
            JDomSerializationUtil.addComponent(root, component);
        }
        Element element = component;
        if (element == null) {
            JDomSerializationUtil.$$$reportNull$$$0(4);
        }
        return element;
    }

    public static void addComponent(@NotNull Element root, @NotNull Element component) {
        String componentName;
        Element old;
        if (root == null) {
            JDomSerializationUtil.$$$reportNull$$$0(5);
        }
        if (component == null) {
            JDomSerializationUtil.$$$reportNull$$$0(6);
        }
        if ((old = JDomSerializationUtil.findComponent(root, componentName = component.getAttributeValue("name"))) != null) {
            root.removeContent(old);
        }
        for (int i = 0; i < root.getContent().size(); ++i) {
            String name;
            Element element;
            Content o = root.getContent().get(i);
            if (!(o instanceof Element) || !(element = (Element)o).getName().equals(COMPONENT_ELEMENT) || componentName.compareTo(name = element.getAttributeValue("name")) >= 0) continue;
            root.addContent(i, component);
            return;
        }
        root.addContent(component);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/model/serialization/JDomSerializationUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = COMPONENT_ELEMENT;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/model/serialization/JDomSerializationUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateComponentElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isComponent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateComponentElement";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

