/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text;

import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.util.Cache;

public abstract class GenericPatternCache
implements PatternCache {
    PatternCompiler _compiler;
    Cache _cache;
    public static final int DEFAULT_CAPACITY = 20;

    GenericPatternCache(Cache cache2, PatternCompiler patternCompiler) {
        this._cache = cache2;
        this._compiler = patternCompiler;
    }

    public final synchronized Pattern addPattern(String string2, int n) throws MalformedPatternException {
        Pattern pattern;
        Object object = this._cache.getElement(string2);
        if (object != null && (pattern = (Pattern)object).getOptions() == n) {
            return pattern;
        }
        pattern = this._compiler.compile(string2, n);
        this._cache.addElement(string2, pattern);
        return pattern;
    }

    public final synchronized Pattern addPattern(String string2) throws MalformedPatternException {
        return this.addPattern(string2, 0);
    }

    public final synchronized Pattern getPattern(String string2, int n) throws MalformedCachePatternException {
        Pattern pattern = null;
        try {
            pattern = this.addPattern(string2, n);
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new MalformedCachePatternException("Invalid expression: " + string2 + "\n" + malformedPatternException.getMessage());
        }
        return pattern;
    }

    public final synchronized Pattern getPattern(String string2) throws MalformedCachePatternException {
        return this.getPattern(string2, 0);
    }

    public final int size() {
        return this._cache.size();
    }

    public final int capacity() {
        return this._cache.capacity();
    }
}

