/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.clazz.AbstractMethodVerifier;
import com.jetbrains.pluginverifier.verifiers.clazz.ClassVerifier;
import com.jetbrains.pluginverifier.verifiers.clazz.InheritFromFinalClassVerifier;
import com.jetbrains.pluginverifier.verifiers.clazz.InterfacesVerifier;
import com.jetbrains.pluginverifier.verifiers.clazz.SuperClassVerifier;
import com.jetbrains.pluginverifier.verifiers.field.FieldTypeVerifier;
import com.jetbrains.pluginverifier.verifiers.field.FieldVerifier;
import com.jetbrains.pluginverifier.verifiers.filter.ClassFilter;
import com.jetbrains.pluginverifier.verifiers.instruction.InstructionVerifier;
import com.jetbrains.pluginverifier.verifiers.instruction.LdcInstructionVerifier;
import com.jetbrains.pluginverifier.verifiers.instruction.MemberAccessVerifier;
import com.jetbrains.pluginverifier.verifiers.instruction.MultiANewArrayInstructionVerifier;
import com.jetbrains.pluginverifier.verifiers.instruction.TypeInstructionVerifier;
import com.jetbrains.pluginverifier.verifiers.method.MethodArgumentTypesVerifier;
import com.jetbrains.pluginverifier.verifiers.method.MethodLocalVarsVerifier;
import com.jetbrains.pluginverifier.verifiers.method.MethodReturnTypeVerifier;
import com.jetbrains.pluginverifier.verifiers.method.MethodThrowsVerifier;
import com.jetbrains.pluginverifier.verifiers.method.MethodTryCatchVerifier;
import com.jetbrains.pluginverifier.verifiers.method.MethodVerifier;
import com.jetbrains.pluginverifier.verifiers.method.OverrideNonFinalVerifier;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.Field;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u00002\u00020\u0001BU\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00170\u001eJ\u0018\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/BytecodeVerifier;", "", "verificationFilters", "", "Lcom/jetbrains/pluginverifier/verifiers/filter/ClassFilter;", "additionalClassVerifiers", "Lcom/jetbrains/pluginverifier/verifiers/clazz/ClassVerifier;", "additionalMethodVerifiers", "Lcom/jetbrains/pluginverifier/verifiers/method/MethodVerifier;", "additionalFieldVerifiers", "Lcom/jetbrains/pluginverifier/verifiers/field/FieldVerifier;", "additionalInstructionVerifiers", "Lcom/jetbrains/pluginverifier/verifiers/instruction/InstructionVerifier;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "classVerifiers", "fieldVerifiers", "instructionVerifiers", "methodVerifiers", "shouldVerify", "", "classFile", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "verify", "", "classesToCheck", "", "", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "progressIndicator", "Lkotlin/Function1;", "", "verifyClass", "className", "verifyClassFile", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nBytecodeVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytecodeVerifier.kt\ncom/jetbrains/pluginverifier/verifiers/BytecodeVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1726#2,3:99\n1855#2,2:102\n*S KotlinDebug\n*F\n+ 1 BytecodeVerifier.kt\ncom/jetbrains/pluginverifier/verifiers/BytecodeVerifier\n*L\n72#1:99,3\n84#1:102,2\n*E\n"})
public final class BytecodeVerifier {
    @NotNull
    private final List<ClassFilter> verificationFilters;
    @NotNull
    private final List<FieldVerifier> fieldVerifiers;
    @NotNull
    private final List<ClassVerifier> classVerifiers;
    @NotNull
    private final List<MethodVerifier> methodVerifiers;
    @NotNull
    private final List<InstructionVerifier> instructionVerifiers;

    public BytecodeVerifier(@NotNull List<? extends ClassFilter> verificationFilters, @NotNull List<? extends ClassVerifier> additionalClassVerifiers, @NotNull List<? extends MethodVerifier> additionalMethodVerifiers, @NotNull List<? extends FieldVerifier> additionalFieldVerifiers, @NotNull List<? extends InstructionVerifier> additionalInstructionVerifiers) {
        Intrinsics.checkNotNullParameter(verificationFilters, "verificationFilters");
        Intrinsics.checkNotNullParameter(additionalClassVerifiers, "additionalClassVerifiers");
        Intrinsics.checkNotNullParameter(additionalMethodVerifiers, "additionalMethodVerifiers");
        Intrinsics.checkNotNullParameter(additionalFieldVerifiers, "additionalFieldVerifiers");
        Intrinsics.checkNotNullParameter(additionalInstructionVerifiers, "additionalInstructionVerifiers");
        this.verificationFilters = verificationFilters;
        this.fieldVerifiers = CollectionsKt.plus((Collection)CollectionsKt.listOf(new FieldTypeVerifier()), (Iterable)additionalFieldVerifiers);
        Object[] objectArray = new ClassVerifier[]{new SuperClassVerifier(), new InterfacesVerifier(), new AbstractMethodVerifier(), new InheritFromFinalClassVerifier()};
        this.classVerifiers = CollectionsKt.plus((Collection)CollectionsKt.listOf(objectArray), (Iterable)additionalClassVerifiers);
        objectArray = new MethodVerifier[]{new OverrideNonFinalVerifier(), new MethodReturnTypeVerifier(), new MethodArgumentTypesVerifier(), new MethodLocalVarsVerifier(), new MethodThrowsVerifier(), new MethodTryCatchVerifier()};
        this.methodVerifiers = CollectionsKt.plus((Collection)CollectionsKt.listOf(objectArray), (Iterable)additionalMethodVerifiers);
        objectArray = new InstructionVerifier[]{new MemberAccessVerifier(), new TypeInstructionVerifier(), new LdcInstructionVerifier(), new MultiANewArrayInstructionVerifier()};
        this.instructionVerifiers = CollectionsKt.plus((Collection)CollectionsKt.listOf(objectArray), (Iterable)additionalInstructionVerifiers);
    }

    public /* synthetic */ BytecodeVerifier(List list, List list2, List list3, List list4, List list5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list5 = CollectionsKt.emptyList();
        }
        this(list, list2, list3, list4, list5);
    }

    public final void verify(@NotNull Set<String> classesToCheck, @NotNull VerificationContext context, @NotNull Function1<? super Double, Unit> progressIndicator) throws InterruptedException {
        Intrinsics.checkNotNullParameter(classesToCheck, "classesToCheck");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(progressIndicator, "progressIndicator");
        if (!((Collection)classesToCheck).isEmpty()) {
            Iterator<String> iterator2 = classesToCheck.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int totalVerifiedClasses = n++;
                String className = iterator2.next();
                LanguageUtilsKt.checkIfInterrupted();
                this.verifyClass(className, context);
                progressIndicator.invoke((Double)((double)(totalVerifiedClasses + 1) / (double)classesToCheck.size()));
            }
        }
    }

    private final void verifyClass(String className, VerificationContext context) {
        ClassFile classFile = ResolutionUtilKt.resolveClassOrNull(context.getClassResolver(), className);
        if (classFile != null && this.shouldVerify(classFile)) {
            this.verifyClassFile(classFile, context);
        }
    }

    private final boolean shouldVerify(ClassFile classFile) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.verificationFilters;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ClassFilter it = (ClassFilter)element$iv;
                    boolean bl2 = false;
                    if (it.shouldVerify(classFile)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void verifyClassFile(ClassFile classFile, VerificationContext context) {
        for (ClassVerifier verifier : this.classVerifiers) {
            verifier.verify(classFile, context);
        }
        Iterator<Object> iterator2 = classFile.getMethods().iterator();
        while (iterator2.hasNext()) {
            Method method = (Method)iterator2.next();
            for (MethodVerifier verifier : this.methodVerifiers) {
                verifier.verify(method, context);
            }
            Iterable $this$forEach$iv = method.getInstructions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AbstractInsnNode instruction = (AbstractInsnNode)element$iv;
                boolean bl = false;
                for (InstructionVerifier verifier : this.instructionVerifiers) {
                    verifier.verify(method, instruction, context);
                }
            }
        }
        iterator2 = classFile.getFields().iterator();
        while (iterator2.hasNext()) {
            Field field = (Field)iterator2.next();
            for (FieldVerifier verifier : this.fieldVerifiers) {
                verifier.verify(field, context);
            }
        }
    }

    public BytecodeVerifier() {
        this(null, null, null, null, null, 31, null);
    }
}

