/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.properties;

import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.utils.PropertyBundleUtilsKt;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.problems.MissingPropertyReferenceProblem;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import com.jetbrains.pluginverifier.results.reference.FieldReference;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import com.jetbrains.pluginverifier.usages.ApiUsageProcessor;
import com.jetbrains.pluginverifier.usages.properties.DeprecatedPropertyUsageWarning;
import com.jetbrains.pluginverifier.verifiers.BytecodeUtilKt;
import com.jetbrains.pluginverifier.verifiers.CodeAnalysis;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFileMember;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassUsageType;
import com.jetbrains.pluginverifier.verifiers.resolution.Field;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/pluginverifier/usages/properties/PropertyUsageProcessor;", "Lcom/jetbrains/pluginverifier/usages/ApiUsageProcessor;", "()V", "checkProperty", "", "resourceBundleName", "", "propertyKey", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "usageLocation", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "processMethodInvocation", "methodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "resolvedMethod", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "instructionNode", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "callerMethod", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nPropertyUsageProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyUsageProcessor.kt\ncom/jetbrains/pluginverifier/usages/properties/PropertyUsageProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1747#2,3:91\n766#2:94\n857#2,2:95\n*S KotlinDebug\n*F\n+ 1 PropertyUsageProcessor.kt\ncom/jetbrains/pluginverifier/usages/properties/PropertyUsageProcessor\n*L\n31#1:91,3\n73#1:94\n73#1:95,2\n*E\n"})
public final class PropertyUsageProcessor
implements ApiUsageProcessor {
    @Override
    public void processMethodInvocation(@NotNull MethodReference methodReference, @NotNull Method resolvedMethod, @NotNull AbstractInsnNode instructionNode, @NotNull Method callerMethod, @NotNull VerificationContext context) {
        boolean bl;
        List<MethodParameter> methodParameters;
        block5: {
            Intrinsics.checkNotNullParameter(methodReference, "methodReference");
            Intrinsics.checkNotNullParameter(resolvedMethod, "resolvedMethod");
            Intrinsics.checkNotNullParameter(instructionNode, "instructionNode");
            Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
            Intrinsics.checkNotNullParameter(context, "context");
            methodParameters = resolvedMethod.getMethodParameters();
            Iterable $this$any$iv = methodParameters;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MethodParameter it = (MethodParameter)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains((CharSequence)it.getName(), "default", true)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Iterator<MethodParameter> iterator2 = methodParameters.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int onStackIndex;
            String resourceBundleName;
            AnnotationNode propertyKeyAnnotation;
            Object object;
            int parameterIndex = n++;
            MethodParameter methodParameter = iterator2.next();
            if (BytecodeUtilKt.findAnnotation(methodParameter.getAnnotations(), "org/jetbrains/annotations/PropertyKey") == null || ((object = BytecodeUtilKt.getAnnotationValue(propertyKeyAnnotation, "resourceBundle")) instanceof String ? (String)object : null) == null) continue;
            resourceBundleName = resourceBundleName;
            List<AbstractInsnNode> instructions = callerMethod.getInstructions();
            int instructionIndex = instructions.indexOf(instructionNode);
            String propertyKey = new CodeAnalysis().evaluateConstantString(callerMethod, instructionIndex, onStackIndex = methodParameters.size() - 1 - parameterIndex);
            if (propertyKey == null) continue;
            this.checkProperty(resourceBundleName, propertyKey, context, callerMethod.getLocation());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkProperty(String resourceBundleName, String propertyKey, VerificationContext context, MethodLocation usageLocation) {
        if (!Intrinsics.areEqual(resourceBundleName, PropertyBundleUtilsKt.getBundleBaseName(resourceBundleName))) {
            return;
        }
        Resolver resolver = context.getClassResolver();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        ResolutionResult<PropertyResourceBundle> resolutionResult = resolver.resolveExactPropertyResourceBundle(resourceBundleName, locale);
        if (!(resolutionResult instanceof ResolutionResult.Found)) {
            return;
        }
        PropertyResourceBundle resourceBundle = (PropertyResourceBundle)((ResolutionResult.Found)resolutionResult).getValue();
        if (!resourceBundle.containsKey(propertyKey)) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = context.getClassResolver().getAllBundleNameSet().getBaseBundleNames();
            boolean $i$f$filter = false;
            void var10_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.endsWith$default(it, "DeprecatedMessagesBundle", false, 2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List deprecatedBundleNames = (List)destination$iv$iv;
            for (String deprecatedBundleName : deprecatedBundleNames) {
                PropertyResourceBundle deprecatedBundle;
                Resolver resolver2 = context.getClassResolver();
                Locale locale2 = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue(locale2, "ROOT");
                ResolutionResult<PropertyResourceBundle> resolution = resolver2.resolveExactPropertyResourceBundle(deprecatedBundleName, locale2);
                if (!(resolution instanceof ResolutionResult.Found) || !(deprecatedBundle = (PropertyResourceBundle)((ResolutionResult.Found)resolution).getValue()).containsKey(propertyKey)) continue;
                context.getWarningRegistrar().registerCompatibilityWarning(new DeprecatedPropertyUsageWarning(propertyKey, resourceBundleName, deprecatedBundleName, usageLocation));
                return;
            }
            context.getProblemRegistrar().registerProblem(new MissingPropertyReferenceProblem(propertyKey, resourceBundleName, usageLocation));
        }
    }

    @Override
    public void processClassReference(@NotNull ClassReference classReference, @NotNull ClassFile resolvedClass, @NotNull VerificationContext context, @NotNull ClassFileMember referrer, @NotNull ClassUsageType classUsageType) {
        ApiUsageProcessor.DefaultImpls.processClassReference(this, classReference, resolvedClass, context, referrer, classUsageType);
    }

    @Override
    public void processFieldAccess(@NotNull FieldReference fieldReference, @NotNull Field resolvedField, @NotNull VerificationContext context, @NotNull Method callerMethod) {
        ApiUsageProcessor.DefaultImpls.processFieldAccess(this, fieldReference, resolvedField, context, callerMethod);
    }
}

