/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.nonExtendable;

import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.location.LocationToReferenceKt;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.presentation.HostClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterNameOption;
import com.jetbrains.pluginverifier.results.presentation.MethodParameterTypeOption;
import com.jetbrains.pluginverifier.results.presentation.MethodReturnTypeOption;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import com.jetbrains.pluginverifier.usages.UsageLocationPresentationKt;
import com.jetbrains.pluginverifier.usages.nonExtendable.NonExtendableApiUsage;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/pluginverifier/usages/nonExtendable/NonExtendableMethodOverriding;", "Lcom/jetbrains/pluginverifier/usages/nonExtendable/NonExtendableApiUsage;", "apiElement", "Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "usageLocation", "Lcom/jetbrains/pluginverifier/results/location/Location;", "(Lcom/jetbrains/pluginverifier/results/location/MethodLocation;Lcom/jetbrains/pluginverifier/results/location/Location;)V", "getApiElement", "()Lcom/jetbrains/pluginverifier/results/location/MethodLocation;", "apiReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "getApiReference", "()Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "fullDescription", "", "getFullDescription", "()Ljava/lang/String;", "problemType", "getProblemType", "shortDescription", "getShortDescription", "getUsageLocation", "()Lcom/jetbrains/pluginverifier/results/location/Location;", "equals", "", "other", "", "hashCode", "", "verifier-intellij"})
public final class NonExtendableMethodOverriding
extends NonExtendableApiUsage {
    @NotNull
    private final MethodLocation apiElement;
    @NotNull
    private final Location usageLocation;

    public NonExtendableMethodOverriding(@NotNull MethodLocation apiElement, @NotNull Location usageLocation) {
        Intrinsics.checkNotNullParameter(apiElement, "apiElement");
        Intrinsics.checkNotNullParameter(usageLocation, "usageLocation");
        this.apiElement = apiElement;
        this.usageLocation = usageLocation;
    }

    @Override
    @NotNull
    public MethodLocation getApiElement() {
        return this.apiElement;
    }

    @Override
    @NotNull
    public Location getUsageLocation() {
        return this.usageLocation;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Non extendable method is overridden";
    }

    @Override
    @NotNull
    public MethodReference getApiReference() {
        return LocationToReferenceKt.toReference(this.getApiElement());
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "Non-extendable method " + LocationsPresentationKt.formatMethodLocation(this.getApiElement(), HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.SIMPLE_PARAM_CLASS_NAME, MethodReturnTypeOption.NO_RETURN_TYPE, MethodParameterNameOption.NO_PARAMETER_NAMES) + " is overridden";
    }

    @Override
    @NotNull
    public String getFullDescription() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_fullDescription__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_fullDescription__u24lambda_u240.append("Non-extendable method ");
        $this$_get_fullDescription__u24lambda_u240.append(LocationsPresentationKt.formatMethodLocation(this.getApiElement(), HostClassOption.FULL_HOST_NAME, MethodParameterTypeOption.FULL_PARAM_CLASS_NAME, MethodReturnTypeOption.FULL_RETURN_TYPE_CLASS_NAME, MethodParameterNameOption.WITH_PARAM_NAMES_IF_AVAILABLE));
        $this$_get_fullDescription__u24lambda_u240.append(" is overridden by " + UsageLocationPresentationKt.formatUsageLocation(this.getUsageLocation()) + ". ");
        $this$_get_fullDescription__u24lambda_u240.append("This method is marked with @org.jetbrains.annotations.ApiStatus.NonExtendable annotation, which indicates that the method is not supposed to be overridden by client code. See documentation of the @ApiStatus.NonExtendable for more info.");
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof NonExtendableMethodOverriding && Intrinsics.areEqual(this.getApiElement(), ((NonExtendableMethodOverriding)other).getApiElement()) && Intrinsics.areEqual(this.getUsageLocation(), ((NonExtendableMethodOverriding)other).getUsageLocation());
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.getApiElement(), this.getUsageLocation()};
        return Objects.hash(objectArray);
    }
}

