/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.tasks.checkPluginApi;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.pluginverifier.PluginVerificationDescriptor;
import com.jetbrains.pluginverifier.PluginVerificationTarget;
import com.jetbrains.pluginverifier.filtering.ProblemsFilter;
import com.jetbrains.pluginverifier.jdk.JdkDescriptor;
import com.jetbrains.pluginverifier.jdk.JdkDescriptorCreator;
import com.jetbrains.pluginverifier.options.CmdOpts;
import com.jetbrains.pluginverifier.options.OptionsParser;
import com.jetbrains.pluginverifier.options.PluginsParsing;
import com.jetbrains.pluginverifier.options.PluginsSet;
import com.jetbrains.pluginverifier.plugin.PluginDetails;
import com.jetbrains.pluginverifier.plugin.PluginDetailsCache;
import com.jetbrains.pluginverifier.reporting.PluginVerificationReportage;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.repository.repositories.local.LocalPluginInfo;
import com.jetbrains.pluginverifier.resolution.PluginApiClassResolverProvider;
import com.jetbrains.pluginverifier.tasks.TaskParametersBuilder;
import com.jetbrains.pluginverifier.tasks.checkPluginApi.CheckPluginApiOpts;
import com.jetbrains.pluginverifier.tasks.checkPluginApi.CheckPluginApiParams;
import com.jetbrains.pluginverifier.verifiers.packages.DefaultPackageFilter;
import com.jetbrains.pluginverifier.verifiers.packages.PackageFilter;
import com.sampullara.cli.Args;
import java.io.Closeable;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u001b\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/pluginverifier/tasks/checkPluginApi/CheckPluginApiParamsBuilder;", "Lcom/jetbrains/pluginverifier/tasks/TaskParametersBuilder;", "pluginRepository", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "pluginDetailsCache", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;", "reportage", "Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;", "(Lcom/jetbrains/pluginverifier/repository/PluginRepository;Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;)V", "build", "Lcom/jetbrains/pluginverifier/tasks/checkPluginApi/CheckPluginApiParams;", "opts", "Lcom/jetbrains/pluginverifier/options/CmdOpts;", "freeArgs", "", "", "parsePackageFilter", "Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;", "packages", "", "([Ljava/lang/String;)Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;", "parsePluginsToCheck", "Lcom/jetbrains/pluginverifier/options/PluginsSet;", "pluginsToCheckFile", "Ljava/nio/file/Path;", "providePluginDetails", "Lcom/jetbrains/pluginverifier/plugin/PluginDetails;", "pluginFile", "Companion", "verifier-cli"})
@SourceDebugExtension(value={"SMAP\nCheckPluginApiParamsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckPluginApiParamsBuilder.kt\ncom/jetbrains/pluginverifier/tasks/checkPluginApi/CheckPluginApiParamsBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,180:1\n37#2,2:181\n1#3:183\n1#3:221\n70#4,2:184\n70#4,2:186\n70#4,2:188\n72#4,3:198\n72#4,3:201\n72#4,3:204\n1549#5:190\n1620#5,3:191\n1549#5:194\n1620#5,3:195\n1603#5,9:211\n1855#5:220\n1856#5:222\n1612#5:223\n11335#6:207\n11670#6,3:208\n*S KotlinDebug\n*F\n+ 1 CheckPluginApiParamsBuilder.kt\ncom/jetbrains/pluginverifier/tasks/checkPluginApi/CheckPluginApiParamsBuilder\n*L\n46#1:181,2\n109#1:221\n70#1:184,2\n72#1:186,2\n75#1:188,2\n75#1:198,3\n72#1:201,3\n70#1:204,3\n77#1:190\n77#1:191,3\n82#1:194\n82#1:195,3\n109#1:211,9\n109#1:220\n109#1:222\n109#1:223\n108#1:207\n108#1:208,3\n*E\n"})
public final class CheckPluginApiParamsBuilder
implements TaskParametersBuilder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginRepository pluginRepository;
    @NotNull
    private final PluginDetailsCache pluginDetailsCache;
    @NotNull
    private final PluginVerificationReportage reportage;
    @Deprecated
    @NotNull
    public static final String USAGE = "Expected exactly 3 arguments: <base plugin version> <new plugin version> <plugins to check>.\nExample: java -jar verifier.jar check-plugin-api Kotlin-old.zip Kotlin-new.zip kotlin-depends.txt";

    public CheckPluginApiParamsBuilder(@NotNull PluginRepository pluginRepository, @NotNull PluginDetailsCache pluginDetailsCache, @NotNull PluginVerificationReportage reportage) {
        Intrinsics.checkNotNullParameter(pluginRepository, "pluginRepository");
        Intrinsics.checkNotNullParameter(pluginDetailsCache, "pluginDetailsCache");
        Intrinsics.checkNotNullParameter(reportage, "reportage");
        this.pluginRepository = pluginRepository;
        this.pluginDetailsCache = pluginDetailsCache;
        this.reportage = reportage;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CheckPluginApiParams build(@NotNull CmdOpts opts, @NotNull List<String> freeArgs) {
        Path path;
        Intrinsics.checkNotNullParameter(opts, "opts");
        Intrinsics.checkNotNullParameter(freeArgs, "freeArgs");
        CheckPluginApiOpts apiOpts = new CheckPluginApiOpts();
        Collection $this$toTypedArray$iv = freeArgs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        List<String> args2 = Args.parse(apiOpts, thisCollection$iv.toArray(new String[0]), false);
        if (args2.size() != 3) {
            Args.usage(apiOpts);
            throw new IllegalArgumentException(USAGE);
        }
        Path basePluginFile = Paths.get(args2.get(0), new String[0]);
        Intrinsics.checkNotNullExpressionValue(basePluginFile, "basePluginFile");
        if (!FileUtilKt.exists(basePluginFile)) {
            boolean $i$a$-require-CheckPluginApiParamsBuilder$build$42 = false;
            String $i$a$-require-CheckPluginApiParamsBuilder$build$42 = "Base plugin file " + basePluginFile + " doesn't exist";
            throw new IllegalArgumentException($i$a$-require-CheckPluginApiParamsBuilder$build$42.toString());
        }
        Path newPluginFile = Paths.get(args2.get(1), new String[0]);
        Intrinsics.checkNotNullExpressionValue(newPluginFile, "newPluginFile");
        if (!FileUtilKt.exists(newPluginFile)) {
            boolean $i$a$-require-CheckPluginApiParamsBuilder$build$52 = false;
            String $i$a$-require-CheckPluginApiParamsBuilder$build$52 = "New plugin file " + newPluginFile + " doesn't exist";
            throw new IllegalArgumentException($i$a$-require-CheckPluginApiParamsBuilder$build$52.toString());
        }
        Path pluginsToCheckFile = Paths.get(args2.get(2), new String[0]);
        Intrinsics.checkNotNullExpressionValue(pluginsToCheckFile, "pluginsToCheckFile");
        if (!FileUtilKt.exists(pluginsToCheckFile)) {
            boolean $i$a$-require-CheckPluginApiParamsBuilder$build$62 = false;
            String $i$a$-require-CheckPluginApiParamsBuilder$build$62 = "File with list of plugins' IDs to check doesn't exist: " + pluginsToCheckFile;
            throw new IllegalArgumentException($i$a$-require-CheckPluginApiParamsBuilder$build$62.toString());
        }
        PluginsSet pluginsSet = this.parsePluginsToCheck(pluginsToCheckFile);
        PackageFilter pluginPackageFilter = this.parsePackageFilter(apiOpts.getPluginPackages());
        String string2 = opts.getRuntimeDir();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            path = Paths.get(it, new String[0]);
        } else {
            path = null;
        }
        if (path == null) {
            boolean $i$a$-requireNotNull-CheckPluginApiParamsBuilder$build$jdkPath$32 = false;
            String $i$a$-requireNotNull-CheckPluginApiParamsBuilder$build$jdkPath$32 = "JDK runtime is not specified";
            throw new IllegalArgumentException($i$a$-requireNotNull-CheckPluginApiParamsBuilder$build$jdkPath$32.toString());
        }
        Path jdkPath = path;
        List<ProblemsFilter> problemsFilters = OptionsParser.INSTANCE.getProblemsFilters(opts);
        PluginDetails basePluginDetails = this.providePluginDetails(basePluginFile);
        Closeable $this$closeOnException$iv = basePluginDetails;
        boolean $i$f$closeOnException = false;
        try {
            PluginDetails it = (PluginDetails)$this$closeOnException$iv;
            boolean bl = false;
            PluginDetails newPluginDetails = this.providePluginDetails(newPluginFile);
            Closeable $this$closeOnException$iv2 = newPluginDetails;
            boolean $i$f$closeOnException2 = false;
            try {
                PluginDetails it2 = (PluginDetails)$this$closeOnException$iv2;
                boolean bl2 = false;
                JdkDescriptor jdkDescriptor = JdkDescriptorCreator.createJdkDescriptor$default(JdkDescriptorCreator.INSTANCE, jdkPath, null, 2, null);
                Closeable $this$closeOnException$iv3 = jdkDescriptor;
                boolean $i$f$closeOnException3 = false;
                try {
                    void $this$mapTo$iv$iv;
                    Collection collection;
                    void $this$mapTo$iv$iv2;
                    JdkDescriptor it3 = (JdkDescriptor)$this$closeOnException$iv3;
                    boolean bl3 = false;
                    PluginApiClassResolverProvider baseClassResolverProvider = new PluginApiClassResolverProvider(jdkDescriptor, basePluginDetails, pluginPackageFilter);
                    Iterable $this$map$iv = pluginsSet.getPluginsToCheck();
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo22 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void it4;
                        PluginInfo pluginInfo = (PluginInfo)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        collection.add(new PluginVerificationDescriptor.Plugin((PluginInfo)it4, basePluginDetails.getPluginInfo(), baseClassResolverProvider, jdkDescriptor.getJdkVersion()));
                    }
                    List baseVerificationDescriptors = (List)destination$iv$iv;
                    PluginApiClassResolverProvider newClassResolverProvider = new PluginApiClassResolverProvider(jdkDescriptor, newPluginDetails, pluginPackageFilter);
                    Iterable $this$map$iv2 = pluginsSet.getPluginsToCheck();
                    boolean $i$f$map2 = false;
                    Iterable $i$f$mapTo22 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it5;
                        PluginInfo pluginInfo = (PluginInfo)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl5 = false;
                        collection.add(new PluginVerificationDescriptor.Plugin((PluginInfo)it5, newPluginDetails.getPluginInfo(), newClassResolverProvider, jdkDescriptor.getJdkVersion()));
                    }
                    List newVerificationDescriptors = (List)destination$iv$iv2;
                    PluginVerificationTarget.Plugin baseVerificationTarget = new PluginVerificationTarget.Plugin(basePluginDetails.getPluginInfo(), jdkDescriptor.getJdkVersion());
                    PluginVerificationTarget.Plugin newVerificationTarget = new PluginVerificationTarget.Plugin(newPluginDetails.getPluginInfo(), jdkDescriptor.getJdkVersion());
                    return new CheckPluginApiParams(basePluginDetails, newPluginDetails, jdkDescriptor, problemsFilters, baseVerificationDescriptors, newVerificationDescriptors, baseVerificationTarget, newVerificationTarget, opts.getExcludeExternalBuildClassesSelector());
                }
                catch (Throwable e$iv) {
                    Closeable closeable = $this$closeOnException$iv3;
                    if (closeable != null) {
                        LanguageUtilsKt.closeLogged(closeable);
                    }
                    throw e$iv;
                }
            }
            catch (Throwable e$iv) {
                Closeable closeable = $this$closeOnException$iv2;
                if (closeable != null) {
                    LanguageUtilsKt.closeLogged(closeable);
                }
                throw e$iv;
            }
        }
        catch (Throwable e$iv) {
            block17: {
                Closeable closeable = $this$closeOnException$iv;
                if (closeable == null) break block17;
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e$iv;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final PackageFilter parsePackageFilter(String[] packages2) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        String[] $this$map$iv = packages2;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            DefaultPackageFilter.Descriptor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            boolean exclude = StringsKt.startsWith$default(it, "-", false, 2, null);
            char[] cArray = new char[]{'+', '-'};
            String binaryPackageName = StringsKt.replace$default(StringsKt.trim(it, cArray), '.', '/', false, 4, null);
            if ((((CharSequence)binaryPackageName).length() == 0 ? null : new DefaultPackageFilter.Descriptor(!exclude, binaryPackageName)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return new DefaultPackageFilter(list);
    }

    private final PluginDetails providePluginDetails(Path pluginFile) {
        PluginCreationResult<IdePlugin> pluginCreationResult = IdePluginManager.Companion.createManager().createPlugin(pluginFile);
        if (!(pluginCreationResult instanceof PluginCreationSuccess)) {
            boolean $i$a$-check-CheckPluginApiParamsBuilder$providePluginDetails$22 = false;
            String $i$a$-check-CheckPluginApiParamsBuilder$providePluginDetails$22 = pluginCreationResult.toString();
            throw new IllegalStateException($i$a$-check-CheckPluginApiParamsBuilder$providePluginDetails$22.toString());
        }
        LocalPluginInfo localPluginInfo = new LocalPluginInfo((IdePlugin)((PluginCreationSuccess)pluginCreationResult).getPlugin());
        PluginDetailsCache.Result cacheEntry = this.pluginDetailsCache.getPluginDetailsCacheEntry(localPluginInfo);
        if (!(cacheEntry instanceof PluginDetailsCache.Result.Provided)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        return ((PluginDetailsCache.Result.Provided)cacheEntry).getPluginDetails();
    }

    private final PluginsSet parsePluginsToCheck(Path pluginsToCheckFile) {
        PluginsSet pluginsSet = new PluginsSet(null, null, 3, null);
        PluginsParsing pluginsParsing = new PluginsParsing(this.pluginRepository, this.reportage, pluginsSet, null, 8, null);
        for (String line : FileUtilKt.readLines$default(pluginsToCheckFile, null, 1, null)) {
            Path path;
            boolean validateDescriptor = !StringsKt.endsWith$default(line, "!!", false, 2, null);
            String path2 = StringsKt.substringBeforeLast$default(line, "!!", null, 2, null);
            try {
                Path path3;
                Path it = path3 = Paths.get(path2, new String[0]);
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                Path path4 = FileUtilKt.exists(it) ? path3 : null;
                if (path4 == null) {
                    it = path3 = pluginsToCheckFile.resolveSibling(path2);
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    path4 = FileUtilKt.exists(it) ? path3 : null;
                }
                path = path4;
            }
            catch (InvalidPathException e) {
                path = null;
            }
            Path pluginPath = path;
            if (pluginPath != null) {
                pluginsParsing.addPluginFile(pluginPath, validateDescriptor);
                continue;
            }
            pluginsParsing.addLastPluginVersion(line);
        }
        return pluginsSet;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/pluginverifier/tasks/checkPluginApi/CheckPluginApiParamsBuilder$Companion;", "", "()V", "USAGE", "", "verifier-cli"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

