/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.problems;

import com.jetbrains.pluginverifier.results.presentation.PackageNotFoundDescriptionBuilder;
import com.jetbrains.pluginverifier.results.problems.ClassNotFoundProblem;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/pluginverifier/results/problems/PackageNotFoundProblem;", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "packageName", "", "classNotFoundProblems", "", "Lcom/jetbrains/pluginverifier/results/problems/ClassNotFoundProblem;", "(Ljava/lang/String;Ljava/util/Set;)V", "getClassNotFoundProblems", "()Ljava/util/Set;", "fullDescription", "getFullDescription", "()Ljava/lang/String;", "getPackageName", "problemType", "getProblemType", "shortDescription", "getShortDescription", "equals", "", "other", "", "hashCode", "", "verifier-core"})
public final class PackageNotFoundProblem
extends CompatibilityProblem {
    @NotNull
    private final String packageName;
    @NotNull
    private final Set<ClassNotFoundProblem> classNotFoundProblems;

    public PackageNotFoundProblem(@NotNull String packageName, @NotNull Set<ClassNotFoundProblem> classNotFoundProblems) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        Intrinsics.checkNotNullParameter(classNotFoundProblems, "classNotFoundProblems");
        this.packageName = packageName;
        this.classNotFoundProblems = classNotFoundProblems;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final Set<ClassNotFoundProblem> getClassNotFoundProblems() {
        return this.classNotFoundProblems;
    }

    @Override
    @NotNull
    public String getProblemType() {
        return "Package not found";
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return "Package '" + StringsKt.replace$default(this.packageName, '/', '.', false, 4, null) + "' is not found";
    }

    @Override
    @NotNull
    public String getFullDescription() {
        return PackageNotFoundDescriptionBuilder.INSTANCE.buildDescription(this);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof PackageNotFoundProblem && Intrinsics.areEqual(this.packageName, ((PackageNotFoundProblem)other).packageName) && Intrinsics.areEqual(this.classNotFoundProblems, ((PackageNotFoundProblem)other).classNotFoundProblems);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.packageName, this.classNotFoundProblems};
        return Objects.hash(objectArray);
    }
}

