/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.results.presentation;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.FieldLocation;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.presentation.ClassOption;
import com.jetbrains.pluginverifier.results.presentation.LocationsPresentationKt;
import com.jetbrains.pluginverifier.results.presentation.ReferencesPresentationKt;
import com.jetbrains.pluginverifier.results.problems.ClassNotFoundProblem;
import com.jetbrains.pluginverifier.results.problems.PackageNotFoundProblem;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/pluginverifier/results/presentation/PackageNotFoundDescriptionBuilder;", "", "()V", "MINIMUM_HIDDEN", "", "NOT_FOUND_CLASSES_SAMPLES", "NOT_FOUND_LOCATIONS", "locationsComparator", "Ljava/util/Comparator;", "Lcom/jetbrains/pluginverifier/results/location/Location;", "buildDescription", "", "packageNotFoundProblem", "Lcom/jetbrains/pluginverifier/results/problems/PackageNotFoundProblem;", "selectFromDifferentLocations", "", "Lcom/jetbrains/pluginverifier/results/problems/ClassNotFoundProblem;", "number", "problems", "hostClass", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nPackageNotFoundDescriptionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageNotFoundDescriptionBuilder.kt\ncom/jetbrains/pluginverifier/results/presentation/PackageNotFoundDescriptionBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1620#2,3:150\n1477#2:153\n1502#2,3:154\n1505#2,3:164\n1549#2:167\n1620#2,3:168\n1855#2,2:171\n1477#2:173\n1502#2,3:174\n1505#2,3:184\n1238#2,2:189\n1045#2:191\n1241#2:192\n361#3,7:157\n361#3,7:177\n442#3:187\n392#3:188\n135#4,9:193\n215#4:202\n216#4:204\n144#4:205\n1#5:203\n*S KotlinDebug\n*F\n+ 1 PackageNotFoundDescriptionBuilder.kt\ncom/jetbrains/pluginverifier/results/presentation/PackageNotFoundDescriptionBuilder\n*L\n32#1:150,3\n68#1:153\n68#1:154,3\n68#1:164,3\n87#1:167\n87#1:168,3\n87#1:171,2\n109#1:173\n109#1:174,3\n109#1:184,3\n110#1:189,2\n110#1:191\n110#1:192\n68#1:157,7\n109#1:177,7\n110#1:187\n110#1:188\n116#1:193,9\n116#1:202\n116#1:204\n116#1:205\n116#1:203\n*E\n"})
public final class PackageNotFoundDescriptionBuilder {
    @NotNull
    public static final PackageNotFoundDescriptionBuilder INSTANCE = new PackageNotFoundDescriptionBuilder();
    private static final int NOT_FOUND_CLASSES_SAMPLES = 5;
    private static final int NOT_FOUND_LOCATIONS = 5;
    private static final int MINIMUM_HIDDEN = 3;
    @NotNull
    private static final Comparator<Location> locationsComparator = PackageNotFoundDescriptionBuilder::locationsComparator$lambda$14;

    private PackageNotFoundDescriptionBuilder() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildDescription(@NotNull PackageNotFoundProblem packageNotFoundProblem) {
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Collection collection;
        void destination$iv;
        void $this$mapTo$iv;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(packageNotFoundProblem, "packageNotFoundProblem");
        StringBuilder $this$buildDescription_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        Set<ClassNotFoundProblem> classNotFoundProblems = packageNotFoundProblem.getClassNotFoundProblems();
        Iterable iterable = classNotFoundProblems;
        Collection collection2 = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            ClassNotFoundProblem classNotFoundProblem = (ClassNotFoundProblem)item$iv;
            collection = destination$iv;
            boolean bl2 = false;
            collection.add(it.getUnresolved().getClassName());
        }
        HashSet missingClasses = (HashSet)destination$iv;
        int missingClassesNumber = missingClasses.size();
        String normalPackageName = StringsKt.replace$default(packageNotFoundProblem.getPackageName(), '/', '.', false, 4, null);
        $this$buildDescription_u24lambda_u245.append("Package '" + normalPackageName + "'");
        $this$buildDescription_u24lambda_u245.append(" is not found along with its ");
        if (missingClassesNumber > 1) {
            $this$buildDescription_u24lambda_u245.append(FormatUtilsKt.pluralizeWithNumber("class", missingClassesNumber));
        } else {
            $this$buildDescription_u24lambda_u245.append("class " + LocationsPresentationKt.getToFullJavaClassName().invoke((String)CollectionsKt.first(missingClasses)));
        }
        StringBuilder stringBuilder2 = $this$buildDescription_u24lambda_u245.append(".");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append('\\n')");
        StringBuilder stringBuilder3 = $this$buildDescription_u24lambda_u245.append("Probably the package '" + normalPackageName + "' belongs to a library or dependency that is not resolved by the checker.\nIt is also possible, however, that this package was actually removed from a dependency causing the detected problems. Access to unresolved classes at runtime may lead to **NoSuchClassError**.");
        Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(value)");
        Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append('\\n')");
        Pair<Integer, Integer> pair = missingClassesNumber < 8 ? TuplesKt.to(missingClassesNumber, 0) : TuplesKt.to(5, missingClassesNumber - 5);
        int showClasses = ((Number)pair.component1()).intValue();
        int hideClasses = ((Number)pair.component2()).intValue();
        $this$buildDescription_u24lambda_u245.append("The following classes of '" + normalPackageName + "' are not resolved");
        if (hideClasses > 0) {
            StringBuilder stringBuilder4 = $this$buildDescription_u24lambda_u245.append(" (only " + showClasses + " most used classes are shown, " + hideClasses + " hidden):");
            Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append('\\n')");
        } else {
            StringBuilder stringBuilder5 = $this$buildDescription_u24lambda_u245.append(":");
            Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder5.append('\n'), "append('\\n')");
        }
        Iterable bl2 = classNotFoundProblems;
        boolean $i$f$groupBy = false;
        void var16_22 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ClassNotFoundProblem it = (ClassNotFoundProblem)element$iv$iv;
            boolean bl3 = false;
            ClassReference key$iv$iv = it.getUnresolved();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl4 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        List classRefToProblems = CollectionsKt.sortedWith(MapsKt.toList(destination$iv$iv), PackageNotFoundDescriptionBuilder::buildDescription$lambda$5$lambda$2);
        for (Pair pair2 : CollectionsKt.take(classRefToProblems, showClasses)) {
            void $this$mapTo$iv$iv;
            ClassReference classRef = (ClassReference)pair2.component1();
            List problems = (List)pair2.component2();
            Pair<Integer, Integer> pair3 = problems.size() < 8 ? TuplesKt.to(problems.size(), 0) : TuplesKt.to(5, problems.size() - 5);
            int showLocations = ((Number)pair3.component1()).intValue();
            int hideLocations = ((Number)pair3.component2()).intValue();
            List<ClassNotFoundProblem> differentProblems = INSTANCE.selectFromDifferentLocations(showLocations, problems);
            StringBuilder stringBuilder6 = $this$buildDescription_u24lambda_u245.append("  Class " + ReferencesPresentationKt.formatClassReference(classRef, ClassOption.FULL_NAME) + " is referenced in");
            Intrinsics.checkNotNullExpressionValue(stringBuilder6, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder6.append('\n'), "append('\\n')");
            Iterable $this$map$iv = differentProblems;
            boolean $i$f$map = false;
            $this$getOrPut$iv$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ClassNotFoundProblem classNotFoundProblem = (ClassNotFoundProblem)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl5 = false;
                collection.add(it.getUsage());
            }
            Iterable $this$forEach$iv = CollectionsKt.sortedWith((List)destination$iv$iv2, locationsComparator);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Location it = (Location)element$iv;
                boolean bl6 = false;
                StringBuilder stringBuilder7 = $this$buildDescription_u24lambda_u245.append("    " + it);
                Intrinsics.checkNotNullExpressionValue(stringBuilder7, "append(value)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder7.append('\n'), "append('\\n')");
            }
            if (hideLocations <= 0) continue;
            StringBuilder stringBuilder8 = $this$buildDescription_u24lambda_u245.append("    ...and " + hideLocations + " other " + FormatUtilsKt.pluralize("place", hideLocations) + "...");
            Intrinsics.checkNotNullExpressionValue(stringBuilder8, "append(value)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder8.append('\n'), "append('\\n')");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ClassNotFoundProblem> selectFromDifferentLocations(int number, List<ClassNotFoundProblem> problems) {
        Object object;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object list$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        if (problems.size() <= number) {
            return problems;
        }
        Iterable iterable = problems;
        boolean $i$f$groupBy = false;
        void var6_5 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            ClassNotFoundProblem it = (ClassNotFoundProblem)element$iv$iv;
            boolean bl = false;
            key$iv$iv = INSTANCE.hostClass(it.getUsage());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Object $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        list$iv$iv = $this$associateByTo$iv$iv$iv.iterator();
        while (list$iv$iv.hasNext()) {
            void it;
            void it$iv$iv;
            Object element$iv$iv$iv = list$iv$iv.next();
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = object;
            boolean bl3 = false;
            Iterable $this$sortedBy$iv = (Iterable)it.getValue();
            boolean $i$f$sortedBy = false;
            List list = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    ClassNotFoundProblem it = (ClassNotFoundProblem)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getUsage().getPresentableLocation());
                    it = (ClassNotFoundProblem)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getUsage().getPresentableLocation()));
                }
            });
            map2.put(k, list);
        }
        Map hostClassToProblems = destination$iv$iv;
        ArrayList result2 = new ArrayList();
        int index = 0;
        while (result2.size() < number) {
            void $this$mapNotNullTo$iv$iv;
            Map $this$mapNotNull$iv = hostClassToProblems;
            boolean $i$f$mapNotNull = false;
            $this$associateByTo$iv$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (object.hasNext()) {
                ClassNotFoundProblem it$iv$iv;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = (Map.Entry)object.next();
                boolean bl = false;
                Map.Entry it = element$iv$iv;
                boolean bl4 = false;
                if ((ClassNotFoundProblem)CollectionsKt.getOrNull((List)it.getValue(), index) == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List slice = (List)destination$iv$iv2;
            result2.addAll(slice);
            int n = index;
            index = n + 1;
        }
        if (result2.size() > number) {
            return CollectionsKt.take(result2, number);
        }
        return result2;
    }

    private final ClassLocation hostClass(Location $this$hostClass) {
        ClassLocation classLocation;
        Location location = $this$hostClass;
        if (location instanceof ClassLocation) {
            classLocation = (ClassLocation)$this$hostClass;
        } else if (location instanceof MethodLocation) {
            classLocation = ((MethodLocation)$this$hostClass).getHostClass();
        } else if (location instanceof FieldLocation) {
            classLocation = ((FieldLocation)$this$hostClass).getHostClass();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return classLocation;
    }

    private static final int buildDescription$lambda$5$lambda$2(Pair one, Pair two) {
        return ((List)one.getSecond()).size() != ((List)two.getSecond()).size() ? Intrinsics.compare(((List)two.getSecond()).size(), ((List)one.getSecond()).size()) : ((ClassReference)one.getFirst()).getClassName().compareTo(((ClassReference)two.getFirst()).getClassName());
    }

    private static final int locationsComparator$lambda$14(Location one, Location two) {
        if (one instanceof ClassLocation && two instanceof ClassLocation) {
            return ((ClassLocation)one).getClassName().compareTo(((ClassLocation)two).getClassName());
        }
        if (one instanceof MethodLocation && two instanceof MethodLocation) {
            Comparator comparator = new Comparator(){

                public final int compare(T a, T b) {
                    MethodLocation it = (MethodLocation)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getHostClass().getClassName());
                    it = (MethodLocation)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getHostClass().getClassName()));
                }
            };
            return ((Comparator)new Comparator(comparator){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        MethodLocation it = (MethodLocation)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getMethodName());
                        it = (MethodLocation)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n = ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getMethodName()));
                    }
                    return n;
                }
            }).compare(one, two);
        }
        if (one instanceof FieldLocation && two instanceof FieldLocation) {
            Comparator comparator = new Comparator(){

                public final int compare(T a, T b) {
                    FieldLocation it = (FieldLocation)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getHostClass().getClassName());
                    it = (FieldLocation)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getHostClass().getClassName()));
                }
            };
            return ((Comparator)new Comparator(comparator){
                final /* synthetic */ Comparator $this_thenBy;
                {
                    this.$this_thenBy = $receiver;
                }

                public final int compare(T a, T b) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a, b);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        FieldLocation it = (FieldLocation)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getFieldName());
                        it = (FieldLocation)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        n = ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getFieldName()));
                    }
                    return n;
                }
            }).compare(one, two);
        }
        return one.getPresentableLocation().compareTo(two.getPresentableLocation());
    }
}

