/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.resolution;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.CompositeResolver;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.pluginverifier.PluginVerifierKt;
import com.jetbrains.pluginverifier.dependencies.DependenciesGraph;
import com.jetbrains.pluginverifier.dependencies.DependenciesGraphBuilder;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyFinder;
import com.jetbrains.pluginverifier.ide.IdeDescriptor;
import com.jetbrains.pluginverifier.plugin.PluginDetails;
import com.jetbrains.pluginverifier.plugin.PluginDetailsCache;
import com.jetbrains.pluginverifier.resolution.ClassResolverProvider;
import com.jetbrains.pluginverifier.verifiers.packages.PackageFilter;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/pluginverifier/resolution/DefaultClassResolverProvider;", "Lcom/jetbrains/pluginverifier/resolution/ClassResolverProvider;", "dependencyFinder", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;", "ideDescriptor", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;", "externalClassesPackageFilter", "Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;", "(Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;)V", "createDependenciesResolver", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "results", "", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder$Result;", "provide", "Lcom/jetbrains/pluginverifier/resolution/ClassResolverProvider$Result;", "checkedPluginDetails", "Lcom/jetbrains/pluginverifier/plugin/PluginDetails;", "provideExternalClassesPackageFilter", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nDefaultClassResolverProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultClassResolverProvider.kt\ncom/jetbrains/pluginverifier/resolution/DefaultClassResolverProvider\n+ 2 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n79#2,4:72\n83#2:78\n79#2,4:79\n83#2:85\n1855#3,2:76\n1855#3,2:83\n*S KotlinDebug\n*F\n+ 1 DefaultClassResolverProvider.kt\ncom/jetbrains/pluginverifier/resolution/DefaultClassResolverProvider\n*L\n29#1:72,4\n29#1:78\n53#1:79,4\n53#1:85\n29#1:76,2\n53#1:83,2\n*E\n"})
public final class DefaultClassResolverProvider
implements ClassResolverProvider {
    @NotNull
    private final DependencyFinder dependencyFinder;
    @NotNull
    private final IdeDescriptor ideDescriptor;
    @NotNull
    private final PackageFilter externalClassesPackageFilter;

    public DefaultClassResolverProvider(@NotNull DependencyFinder dependencyFinder, @NotNull IdeDescriptor ideDescriptor, @NotNull PackageFilter externalClassesPackageFilter) {
        Intrinsics.checkNotNullParameter(dependencyFinder, "dependencyFinder");
        Intrinsics.checkNotNullParameter(ideDescriptor, "ideDescriptor");
        Intrinsics.checkNotNullParameter(externalClassesPackageFilter, "externalClassesPackageFilter");
        this.dependencyFinder = dependencyFinder;
        this.ideDescriptor = ideDescriptor;
        this.externalClassesPackageFilter = externalClassesPackageFilter;
    }

    @Override
    @NotNull
    public ClassResolverProvider.Result provide(@NotNull PluginDetails checkedPluginDetails) {
        Intrinsics.checkNotNullParameter(checkedPluginDetails, "checkedPluginDetails");
        ArrayList closeableResources = new ArrayList();
        List $this$closeOnException$iv = closeableResources;
        boolean $i$f$closeOnException = false;
        try {
            List it = $this$closeOnException$iv;
            boolean bl = false;
            Resolver pluginResolver = PluginVerifierKt.createPluginResolver(checkedPluginDetails.getPluginClassesLocations());
            Pair<DependenciesGraph, List<DependencyFinder.Result>> pair = new DependenciesGraphBuilder(this.dependencyFinder).buildDependenciesGraph(checkedPluginDetails.getIdePlugin(), this.ideDescriptor.getIde());
            DependenciesGraph dependenciesGraph = pair.component1();
            List<DependencyFinder.Result> dependenciesResults = pair.component2();
            CollectionsKt.addAll((Collection)closeableResources, (Iterable)dependenciesResults);
            Resolver dependenciesClassResolver = this.createDependenciesResolver(dependenciesResults);
            Resolver[] resolverArray = new Resolver[]{pluginResolver, this.ideDescriptor.getJdkDescriptor().getJdkResolver(), this.ideDescriptor.getIdeResolver(), dependenciesClassResolver};
            Resolver resolver = ResolutionUtilKt.caching(CompositeResolver.Companion.create(resolverArray));
            return new ClassResolverProvider.Result(pluginResolver, resolver, dependenciesGraph, closeableResources);
        }
        catch (Throwable e$iv) {
            Iterable $this$forEach$iv$iv = $this$closeOnException$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Closeable t$iv = (Closeable)element$iv$iv;
                boolean bl = false;
                Closeable closeable = t$iv;
                if (closeable == null) continue;
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e$iv;
        }
    }

    @Override
    @NotNull
    public PackageFilter provideExternalClassesPackageFilter() {
        return this.externalClassesPackageFilter;
    }

    private final Resolver createDependenciesResolver(List<? extends DependencyFinder.Result> results) {
        ArrayList<Resolver> resolvers = new ArrayList<Resolver>();
        List $this$closeOnException$iv = resolvers;
        boolean $i$f$closeOnException = false;
        try {
            List it = $this$closeOnException$iv;
            boolean bl = false;
            for (DependencyFinder.Result result2 : results) {
                Resolver resolver;
                PluginDetailsCache.Result cacheResult;
                if (!(result2 instanceof DependencyFinder.Result.DetailsProvided) || !((cacheResult = ((DependencyFinder.Result.DetailsProvided)result2).getPluginDetailsCacheResult()) instanceof PluginDetailsCache.Result.Provided)) continue;
                try {
                    resolver = PluginVerifierKt.createPluginResolver(((PluginDetailsCache.Result.Provided)cacheResult).getPluginDetails().getPluginClassesLocations());
                }
                catch (Exception e) {
                    LanguageUtilsKt.rethrowIfInterrupted(e);
                    continue;
                }
                Resolver resolver2 = resolver;
                resolvers.add(resolver2);
            }
            return CompositeResolver.Companion.create((Iterable<? extends Resolver>)resolvers);
        }
        catch (Throwable e$iv) {
            Iterable $this$forEach$iv$iv = $this$closeOnException$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Closeable t$iv = (Closeable)element$iv$iv;
                boolean bl = false;
                Closeable closeable = t$iv;
                if (closeable == null) continue;
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e$iv;
        }
    }
}

