/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.repositories.custom;

import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingParser;
import com.jetbrains.plugin.structure.intellij.repository.CustomPluginRepositoryListingType;
import com.jetbrains.pluginverifier.misc.RestApiFailed;
import com.jetbrains.pluginverifier.misc.RestApiOk;
import com.jetbrains.pluginverifier.misc.RestApiResult;
import com.jetbrains.pluginverifier.misc.RestApis;
import com.jetbrains.pluginverifier.repository.repositories.custom.CustomPluginInfo;
import com.jetbrains.pluginverifier.repository.repositories.custom.CustomPluginRepository;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/pluginverifier/repository/repositories/custom/DefaultCustomPluginRepository;", "Lcom/jetbrains/pluginverifier/repository/repositories/custom/CustomPluginRepository;", "repositoryUrl", "Ljava/net/URL;", "pluginsListXmlUrl", "pluginsXmlListingType", "Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingType;", "presentableName", "", "(Ljava/net/URL;Ljava/net/URL;Lcom/jetbrains/plugin/structure/intellij/repository/CustomPluginRepositoryListingType;Ljava/lang/String;)V", "getPresentableName", "()Ljava/lang/String;", "repositoryConnector", "Lcom/jetbrains/pluginverifier/repository/repositories/custom/DefaultCustomPluginRepository$PluginListConnector;", "getRepositoryConnector", "()Lcom/jetbrains/pluginverifier/repository/repositories/custom/DefaultCustomPluginRepository$PluginListConnector;", "repositoryConnector$delegate", "Lkotlin/Lazy;", "getRepositoryUrl", "()Ljava/net/URL;", "requestAllPlugins", "", "Lcom/jetbrains/pluginverifier/repository/repositories/custom/CustomPluginInfo;", "toString", "PluginListConnector", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nDefaultCustomPluginRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultCustomPluginRepository.kt\ncom/jetbrains/pluginverifier/repository/repositories/custom/DefaultCustomPluginRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1549#2:66\n1620#2,3:67\n*S KotlinDebug\n*F\n+ 1 DefaultCustomPluginRepository.kt\ncom/jetbrains/pluginverifier/repository/repositories/custom/DefaultCustomPluginRepository\n*L\n32#1:66\n32#1:67,3\n*E\n"})
public final class DefaultCustomPluginRepository
extends CustomPluginRepository {
    @NotNull
    private final URL repositoryUrl;
    @NotNull
    private final URL pluginsListXmlUrl;
    @NotNull
    private final CustomPluginRepositoryListingType pluginsXmlListingType;
    @NotNull
    private final String presentableName;
    @NotNull
    private final Lazy repositoryConnector$delegate;

    public DefaultCustomPluginRepository(@NotNull URL repositoryUrl, @NotNull URL pluginsListXmlUrl, @NotNull CustomPluginRepositoryListingType pluginsXmlListingType, @NotNull String presentableName2) {
        Intrinsics.checkNotNullParameter(repositoryUrl, "repositoryUrl");
        Intrinsics.checkNotNullParameter(pluginsListXmlUrl, "pluginsListXmlUrl");
        Intrinsics.checkNotNullParameter((Object)pluginsXmlListingType, "pluginsXmlListingType");
        Intrinsics.checkNotNullParameter(presentableName2, "presentableName");
        this.repositoryUrl = repositoryUrl;
        this.pluginsListXmlUrl = pluginsListXmlUrl;
        this.pluginsXmlListingType = pluginsXmlListingType;
        this.presentableName = presentableName2;
        this.repositoryConnector$delegate = LazyKt.lazy((Function0)new Function0<PluginListConnector>(this){
            final /* synthetic */ DefaultCustomPluginRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final PluginListConnector invoke() {
                return new PluginListConnector(DefaultCustomPluginRepository.access$getPluginsListXmlUrl$p(this.this$0));
            }
        });
    }

    @Override
    @NotNull
    public URL getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    private final PluginListConnector getRepositoryConnector() {
        Lazy lazy = this.repositoryConnector$delegate;
        return (PluginListConnector)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CustomPluginInfo> requestAllPlugins() {
        void $this$mapTo$iv$iv;
        String xmlContent = this.getRepositoryConnector().getPluginsListXml();
        Iterable $this$map$iv = CustomPluginRepositoryListingParser.INSTANCE.parseListOfPlugins(xmlContent, this.pluginsListXmlUrl, this.getRepositoryUrl(), this.pluginsXmlListingType);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CustomPluginRepositoryListingParser.PluginInfo pluginInfo = (CustomPluginRepositoryListingParser.PluginInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CustomPluginInfo(it.getPluginId(), it.getPluginName(), it.getVersion(), it.getVendor(), it.getRepositoryUrl(), it.getDownloadUrl(), it.getBrowserUrl(), it.getSourceCodeUrl(), it.getSinceBuild(), it.getUntilBuild()));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String toString() {
        return this.getPresentableName();
    }

    public static final /* synthetic */ URL access$getPluginsListXmlUrl$p(DefaultCustomPluginRepository $this) {
        return $this.pluginsListXmlUrl;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0007\u001a\u00060\bj\u0002`\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/pluginverifier/repository/repositories/custom/DefaultCustomPluginRepository$PluginListConnector;", "", "endpointUrl", "Ljava/net/URL;", "(Ljava/net/URL;)V", "restApis", "Lcom/jetbrains/pluginverifier/misc/RestApis;", "getPluginsListXml", "", "Lcom/jetbrains/pluginverifier/repository/repositories/custom/XmlString;", "verifier-repository"})
    private static final class PluginListConnector {
        @NotNull
        private final URL endpointUrl;
        @NotNull
        private final RestApis restApis;

        public PluginListConnector(@NotNull URL endpointUrl) {
            Intrinsics.checkNotNullParameter(endpointUrl, "endpointUrl");
            this.endpointUrl = endpointUrl;
            this.restApis = new RestApis();
        }

        @NotNull
        public final String getPluginsListXml() {
            String string2;
            String string3 = this.endpointUrl.toExternalForm();
            Intrinsics.checkNotNullExpressionValue(string3, "endpointUrl.toExternalForm()");
            RestApiResult apiResult = RestApis.getRawString$default(this.restApis, string3, null, 2, null);
            if (apiResult instanceof RestApiOk) {
                string2 = (String)((RestApiOk)apiResult).getPayload();
            } else if (apiResult instanceof RestApiFailed) {
                string2 = "<plugin-repository />";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string2;
        }
    }
}

