/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.downloader;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.misc.RestApisKt;
import com.jetbrains.pluginverifier.network.NonSuccessfulResponseException;
import com.jetbrains.pluginverifier.network.NotFound404ResponseException;
import com.jetbrains.pluginverifier.network.ServerInternalError500Exception;
import com.jetbrains.pluginverifier.network.ServerUnavailable503Exception;
import com.jetbrains.pluginverifier.repository.downloader.DownloadResult;
import com.jetbrains.pluginverifier.repository.downloader.Downloader;
import com.jetbrains.pluginverifier.repository.downloader.UrlDownloaderKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u001c*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0003\u001c\u001d\u001eB\u001b\u0012\u0014\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002J%\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0018J%\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0016J%\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/UrlDownloader;", "K", "Lcom/jetbrains/pluginverifier/repository/downloader/Downloader;", "urlProvider", "Lkotlin/Function1;", "Ljava/net/URL;", "(Lkotlin/jvm/functions/Function1;)V", "downloadConnector", "Lcom/jetbrains/pluginverifier/repository/downloader/UrlDownloader$DownloadConnector;", "copyFileOrDirectory", "Lcom/jetbrains/pluginverifier/repository/downloader/DownloadResult$Downloaded;", "downloadUrl", "tempDirectory", "Ljava/nio/file/Path;", "copyResponseTo", "", "response", "Lcom/jetbrains/pluginverifier/repository/downloader/UrlDownloader$Response;", "file", "doDownload", "Lcom/jetbrains/pluginverifier/repository/downloader/DownloadResult;", "key", "(Ljava/lang/Object;Ljava/net/URL;Ljava/nio/file/Path;)Lcom/jetbrains/pluginverifier/repository/downloader/DownloadResult;", "download", "(Ljava/lang/Object;Ljava/nio/file/Path;)Lcom/jetbrains/pluginverifier/repository/downloader/DownloadResult;", "downloadByUrl", "downloadFileOrDirectory", "(Ljava/net/URL;Ljava/nio/file/Path;Ljava/lang/Object;)Lcom/jetbrains/pluginverifier/repository/downloader/DownloadResult;", "Companion", "DownloadConnector", "Response", "verifier-repository"})
public final class UrlDownloader<K>
implements Downloader<K> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<K, URL> urlProvider;
    @NotNull
    private final DownloadConnector downloadConnector;
    @NotNull
    private static final String FILE_PROTOCOL = "file";
    @NotNull
    private static final String HTTP_PROTOCOL = "http";
    @NotNull
    private static final String HTTPS_PROTOCOL = "https";
    private static final Logger LOG = LoggerFactory.getLogger(UrlDownloader.class);

    public UrlDownloader(@NotNull Function1<? super K, URL> urlProvider2) {
        Intrinsics.checkNotNullParameter(urlProvider2, "urlProvider");
        this.urlProvider = urlProvider2;
        this.downloadConnector = new DownloadConnector();
    }

    @Override
    @NotNull
    public DownloadResult download(K key, @NotNull Path tempDirectory) throws InterruptedException {
        URL uRL;
        Intrinsics.checkNotNullParameter(tempDirectory, "tempDirectory");
        try {
            uRL = this.urlProvider.invoke(key);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            return new DownloadResult.FailedToDownload("Invalid URL", e);
        }
        URL uRL2 = uRL;
        if (uRL2 == null) {
            return new DownloadResult.NotFound("Unknown URL for " + key);
        }
        URL downloadUrl = uRL2;
        return this.downloadByUrl(key, downloadUrl, tempDirectory);
    }

    private final DownloadResult downloadByUrl(K key, URL downloadUrl, Path tempDirectory) {
        DownloadResult downloadResult;
        LanguageUtilsKt.checkIfInterrupted();
        try {
            downloadResult = this.doDownload(key, downloadUrl, tempDirectory);
        }
        catch (NotFound404ResponseException e) {
            downloadResult = new DownloadResult.NotFound("Resource is not found by " + downloadUrl);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            downloadResult = new DownloadResult.FailedToDownload("Unable to download " + key + ": " + e.getMessage(), e);
        }
        return downloadResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final DownloadResult doDownload(K key, URL downloadUrl, Path tempDirectory) {
        String protocol = downloadUrl.getProtocol();
        if (protocol == null) throw new IllegalArgumentException("Unknown protocol: " + protocol + " of " + downloadUrl);
        int n = -1;
        switch (protocol.hashCode()) {
            case 3143036: {
                if (protocol.equals(FILE_PROTOCOL)) {
                    n = 1;
                }
                break;
            }
            case 3213448: {
                if (protocol.equals(HTTP_PROTOCOL)) {
                    n = 2;
                }
                break;
            }
            case 99617003: {
                if (protocol.equals(HTTPS_PROTOCOL)) {
                    n = 2;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                DownloadResult downloadResult = this.copyFileOrDirectory(downloadUrl, tempDirectory);
                return downloadResult;
            }
            case 2: {
                DownloadResult downloadResult = this.downloadFileOrDirectory(downloadUrl, tempDirectory, key);
                return downloadResult;
            }
            default: {
                throw new IllegalArgumentException("Unknown protocol: " + protocol + " of " + downloadUrl);
            }
        }
    }

    private final DownloadResult.Downloaded copyFileOrDirectory(URL downloadUrl, Path tempDirectory) {
        Path original = FileUtils.toFile(downloadUrl).toPath();
        Intrinsics.checkNotNullExpressionValue(original, "original");
        Path destination = tempDirectory.resolve(FileUtilKt.getSimpleName(original));
        File file2 = original.toFile();
        Intrinsics.checkNotNullExpressionValue(file2, "original.toFile()");
        File file3 = destination.toFile();
        Intrinsics.checkNotNullExpressionValue(file3, "destination.toFile()");
        FilesKt.copyRecursively$default(file2, file3, false, null, 6, null);
        Intrinsics.checkNotNullExpressionValue(destination, "destination");
        return new DownloadResult.Downloaded(destination, FileUtilKt.getExtension(destination), FileUtilKt.isDirectory(destination));
    }

    private final DownloadResult downloadFileOrDirectory(URL downloadUrl, Path tempDirectory, K key) {
        DownloadResult downloadResult;
        String string2 = downloadUrl.toExternalForm();
        Intrinsics.checkNotNullExpressionValue(string2, "downloadUrl.toExternalForm()");
        Response response = DownloadConnector.download$default(this.downloadConnector, string2, null, 2, null);
        String extension = response.getExtension();
        Path downloadedTempFile = Files.createTempFile(tempDirectory, "", "." + extension, new FileAttribute[0]);
        try {
            LOG.debug("Downloading {} to {}", (Object)key, (Object)downloadedTempFile);
            Intrinsics.checkNotNullExpressionValue(downloadedTempFile, "downloadedTempFile");
            this.copyResponseTo(response, downloadedTempFile);
            downloadResult = new DownloadResult.Downloaded(downloadedTempFile, extension, false);
        }
        catch (Throwable e) {
            Intrinsics.checkNotNullExpressionValue(downloadedTempFile, "downloadedTempFile");
            FileUtilKt.deleteLogged(downloadedTempFile);
            throw e;
        }
        return downloadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyResponseTo(Response response, Path file2) {
        LanguageUtilsKt.checkIfInterrupted();
        Closeable closeable = response.getBody();
        Throwable throwable = null;
        try {
            InputStream responseBody = (InputStream)closeable;
            boolean bl = false;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            long l = Files.copy(responseBody, file2, copyOptionArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/UrlDownloader$Companion;", "", "()V", "FILE_PROTOCOL", "", "HTTPS_PROTOCOL", "HTTP_PROTOCOL", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "verifier-repository"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/UrlDownloader$DownloadConnector;", "", "()V", "httpClient", "Ljava/net/http/HttpClient;", "getHttpClient", "()Ljava/net/http/HttpClient;", "assertHttpOk", "", "url", "", "response", "Ljava/net/http/HttpResponse;", "Ljava/io/InputStream;", "download", "Lcom/jetbrains/pluginverifier/repository/downloader/UrlDownloader$Response;", "timeout", "Ljava/time/Duration;", "verifier-repository"})
    private static final class DownloadConnector {
        @NotNull
        private final HttpClient httpClient = RestApisKt.createHttpClient$default(null, 1, null);

        @NotNull
        public final HttpClient getHttpClient() {
            return this.httpClient;
        }

        @NotNull
        public final Response download(@NotNull String url, @NotNull Duration timeout2) {
            Intrinsics.checkNotNullParameter(url, "url");
            Intrinsics.checkNotNullParameter(timeout2, "timeout");
            HttpRequest httpGet = HttpRequest.newBuilder().GET().uri(URI.create(url)).timeout(timeout2).build();
            HttpResponse<InputStream> httpResponse = this.httpClient.send(httpGet, HttpResponse.BodyHandlers.ofInputStream());
            Intrinsics.checkNotNullExpressionValue(httpResponse, "httpClient.send(httpGet,\u2026Handlers.ofInputStream())");
            HttpResponse<InputStream> response = httpResponse;
            this.assertHttpOk(url, response);
            String extension = UrlDownloaderKt.guessExtension$default(response, null, 1, null);
            InputStream inputStream2 = response.body();
            Intrinsics.checkNotNullExpressionValue(inputStream2, "response.body()");
            return new Response(inputStream2, UrlDownloaderKt.access$contentLength(response), extension);
        }

        public static /* synthetic */ Response download$default(DownloadConnector downloadConnector, String string2, Duration duration, int n, Object object) {
            if ((n & 2) != 0) {
                Duration duration2 = Duration.ofMinutes(5L);
                Intrinsics.checkNotNullExpressionValue(duration2, "ofMinutes(5)");
                duration = duration2;
            }
            return downloadConnector.download(string2, duration);
        }

        private final void assertHttpOk(String url, HttpResponse<InputStream> response) {
            int code = response.statusCode();
            switch (code) {
                case 200: {
                    return;
                }
                case 404: {
                    throw new NotFound404ResponseException(url);
                }
                case 500: {
                    throw new ServerInternalError500Exception(url);
                }
                case 503: {
                    throw new ServerUnavailable503Exception(url);
                }
            }
            InputStream inputStream2 = response.body();
            Intrinsics.checkNotNullExpressionValue(inputStream2, "response.body()");
            InputStream inputStream3 = inputStream2;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream3, charset);
            int n = 8192;
            String string2 = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)).readLine();
            Intrinsics.checkNotNullExpressionValue(string2, "response.body().bufferedReader().readLine()");
            String message2 = StringsKt.take(string2, 255);
            throw new NonSuccessfulResponseException(url, code, message2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/UrlDownloader$Response;", "", "body", "Ljava/io/InputStream;", "contentLength", "", "extension", "", "(Ljava/io/InputStream;JLjava/lang/String;)V", "getBody", "()Ljava/io/InputStream;", "getContentLength", "()J", "getExtension", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "verifier-repository"})
    private static final class Response {
        @NotNull
        private final InputStream body;
        private final long contentLength;
        @NotNull
        private final String extension;

        public Response(@NotNull InputStream body, long contentLength, @NotNull String extension) {
            Intrinsics.checkNotNullParameter(body, "body");
            Intrinsics.checkNotNullParameter(extension, "extension");
            this.body = body;
            this.contentLength = contentLength;
            this.extension = extension;
        }

        public /* synthetic */ Response(InputStream inputStream2, long l, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = -1L;
            }
            this(inputStream2, l, string2);
        }

        @NotNull
        public final InputStream getBody() {
            return this.body;
        }

        public final long getContentLength() {
            return this.contentLength;
        }

        @NotNull
        public final String getExtension() {
            return this.extension;
        }

        @NotNull
        public final InputStream component1() {
            return this.body;
        }

        public final long component2() {
            return this.contentLength;
        }

        @NotNull
        public final String component3() {
            return this.extension;
        }

        @NotNull
        public final Response copy(@NotNull InputStream body, long contentLength, @NotNull String extension) {
            Intrinsics.checkNotNullParameter(body, "body");
            Intrinsics.checkNotNullParameter(extension, "extension");
            return new Response(body, contentLength, extension);
        }

        public static /* synthetic */ Response copy$default(Response response, InputStream inputStream2, long l, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                inputStream2 = response.body;
            }
            if ((n & 2) != 0) {
                l = response.contentLength;
            }
            if ((n & 4) != 0) {
                string2 = response.extension;
            }
            return response.copy(inputStream2, l, string2);
        }

        @NotNull
        public String toString() {
            return "Response(body=" + this.body + ", contentLength=" + this.contentLength + ", extension=" + this.extension + ")";
        }

        public int hashCode() {
            int result2 = this.body.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.contentLength);
            result2 = result2 * 31 + this.extension.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Response)) {
                return false;
            }
            Response response = (Response)other;
            if (!Intrinsics.areEqual(this.body, response.body)) {
                return false;
            }
            if (this.contentLength != response.contentLength) {
                return false;
            }
            return Intrinsics.areEqual(this.extension, response.extension);
        }
    }
}

