/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.downloader;

import com.jetbrains.pluginverifier.repository.cleanup.SpaceAmount;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\b\u001a\u00060\u0005R\u00020\u0000J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0005R\u00020\u0000H\u0002RB\u0010\u0003\u001a6\u0012\u0014\u0012\u0012 \u0006*\b\u0018\u00010\u0005R\u00020\u00000\u0005R\u00020\u0000 \u0006*\u001a\u0012\u0014\u0012\u0012 \u0006*\b\u0018\u00010\u0005R\u00020\u00000\u0005R\u00020\u0000\u0018\u00010\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics;", "", "()V", "events", "", "Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics$DownloadEvent;", "kotlin.jvm.PlatformType", "", "downloadStarted", "getTotalAstronomicalDownloadDuration", "Ljava/time/Duration;", "getTotalDownloadedAmount", "Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "reportEvent", "", "downloadEvent", "DownloadEvent", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nDownloadStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadStatistics.kt\ncom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,65:1\n1789#2,3:66\n1477#2:69\n1502#2,3:70\n1505#2,3:80\n1477#2:83\n1502#2,3:84\n1505#2,3:94\n1549#2:97\n1620#2,3:98\n1549#2:101\n1620#2,3:102\n361#3,7:73\n361#3,7:87\n*S KotlinDebug\n*F\n+ 1 DownloadStatistics.kt\ncom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics\n*L\n25#1:66,3\n31#1:69\n31#1:70,3\n31#1:80,3\n32#1:83\n32#1:84,3\n32#1:94,3\n33#1:97\n33#1:98,3\n33#1:101\n33#1:102,3\n31#1:73,7\n32#1:87,7\n*E\n"})
public final class DownloadStatistics {
    private final List<DownloadEvent> events = Collections.synchronizedList(new ArrayList());

    private final synchronized void reportEvent(DownloadEvent downloadEvent) {
        List<DownloadEvent> list = this.events;
        Intrinsics.checkNotNullExpressionValue(list, "events");
        ((Collection)list).add(downloadEvent);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SpaceAmount getTotalDownloadedAmount() {
        void $this$fold$iv;
        List<DownloadEvent> list = this.events;
        Intrinsics.checkNotNullExpressionValue(list, "events");
        Iterable iterable = list;
        SpaceAmount initial$iv = SpaceAmount.Companion.getZERO_SPACE();
        boolean $i$f$fold = false;
        SpaceAmount accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void event;
            DownloadEvent downloadEvent = (DownloadEvent)element$iv;
            SpaceAmount acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.plus(event.getDownloadedAmount$verifier_repository());
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Duration getTotalAstronomicalDownloadDuration() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$groupByTo$iv$iv2;
        List<DownloadEvent> list = this.events;
        Intrinsics.checkNotNullExpressionValue(list, "events");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object;
            DownloadEvent it = (DownloadEvent)element$iv$iv;
            boolean bl = false;
            Instant key$iv$iv = it.getStartInstant$verifier_repository();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map startEvents = destination$iv$iv;
        List<DownloadEvent> list2 = this.events;
        Intrinsics.checkNotNullExpressionValue(list2, "events");
        Iterable $this$groupBy$iv2 = list2;
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv2;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DownloadEvent it = (DownloadEvent)element$iv$iv;
            boolean bl = false;
            Instant key$iv$iv = it.getEndInstant$verifier_repository();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map endEvents = destination$iv$iv2;
        List<DownloadEvent> list3 = this.events;
        Intrinsics.checkNotNullExpressionValue(list3, "events");
        Iterable $this$map$iv = list3;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DownloadEvent bl = (DownloadEvent)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl4 = false;
            collection.add(it.getStartInstant$verifier_repository());
        }
        Collection collection2 = (List)destination$iv$iv3;
        List<DownloadEvent> list4 = this.events;
        Intrinsics.checkNotNullExpressionValue(list4, "events");
        $this$map$iv = list4;
        collection = collection2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            DownloadEvent it = (DownloadEvent)item$iv$iv;
            Collection collection3 = destination$iv$iv3;
            boolean bl = false;
            collection3.add(it.getEndInstant$verifier_repository());
        }
        List allInstants = CollectionsKt.sorted(CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv3)));
        Duration totalDuration = Duration.ZERO;
        HashSet activeEvents = new HashSet();
        int n = allInstants.size() - 1;
        for (int i = 0; i < n; ++i) {
            Instant segmentStart = (Instant)allInstants.get(i);
            Instant segmentEnd = (Instant)allInstants.get(i + 1);
            Collection collection4 = activeEvents;
            List list5 = (List)endEvents.get(segmentStart);
            if (list5 == null) {
                list5 = CollectionsKt.emptyList();
            }
            CollectionsKt.removeAll(collection4, list5);
            Collection collection5 = activeEvents;
            List list6 = (List)startEvents.get(segmentStart);
            if (list6 == null) {
                list6 = CollectionsKt.emptyList();
            }
            CollectionsKt.addAll(collection5, list6);
            if (!(!((Collection)activeEvents).isEmpty())) continue;
            totalDuration = totalDuration.plus(Duration.between(segmentStart, segmentEnd));
        }
        Duration duration = totalDuration;
        Intrinsics.checkNotNullExpressionValue(duration, "totalDuration");
        return duration;
    }

    @NotNull
    public final DownloadEvent downloadStarted() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue(instant, "now()");
        return new DownloadEvent(this, instant, null, null, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics$DownloadEvent;", "", "startInstant", "Ljava/time/Instant;", "endInstant", "downloadedAmount", "Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "(Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics;Ljava/time/Instant;Ljava/time/Instant;Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;)V", "getDownloadedAmount$verifier_repository", "()Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "setDownloadedAmount$verifier_repository", "(Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;)V", "getEndInstant$verifier_repository", "()Ljava/time/Instant;", "setEndInstant$verifier_repository", "(Ljava/time/Instant;)V", "getStartInstant$verifier_repository", "downloadEnded", "", "verifier-repository"})
    public final class DownloadEvent {
        @NotNull
        private final Instant startInstant;
        @NotNull
        private Instant endInstant;
        @NotNull
        private SpaceAmount downloadedAmount;
        final /* synthetic */ DownloadStatistics this$0;

        public DownloadEvent(@NotNull DownloadStatistics this$0, @NotNull Instant startInstant, @NotNull Instant endInstant, SpaceAmount downloadedAmount) {
            Intrinsics.checkNotNullParameter(startInstant, "startInstant");
            Intrinsics.checkNotNullParameter(endInstant, "endInstant");
            Intrinsics.checkNotNullParameter(downloadedAmount, "downloadedAmount");
            this.this$0 = this$0;
            this.startInstant = startInstant;
            this.endInstant = endInstant;
            this.downloadedAmount = downloadedAmount;
        }

        public /* synthetic */ DownloadEvent(DownloadStatistics downloadStatistics, Instant instant, Instant instant2, SpaceAmount spaceAmount, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                Instant instant3 = Instant.EPOCH;
                Intrinsics.checkNotNullExpressionValue(instant3, "EPOCH");
                instant2 = instant3;
            }
            if ((n & 4) != 0) {
                spaceAmount = SpaceAmount.Companion.getZERO_SPACE();
            }
            this(downloadStatistics, instant, instant2, spaceAmount);
        }

        @NotNull
        public final Instant getStartInstant$verifier_repository() {
            return this.startInstant;
        }

        @NotNull
        public final Instant getEndInstant$verifier_repository() {
            return this.endInstant;
        }

        public final void setEndInstant$verifier_repository(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter(instant, "<set-?>");
            this.endInstant = instant;
        }

        @NotNull
        public final SpaceAmount getDownloadedAmount$verifier_repository() {
            return this.downloadedAmount;
        }

        public final void setDownloadedAmount$verifier_repository(@NotNull SpaceAmount spaceAmount) {
            Intrinsics.checkNotNullParameter(spaceAmount, "<set-?>");
            this.downloadedAmount = spaceAmount;
        }

        public final synchronized void downloadEnded(@NotNull SpaceAmount downloadedAmount) {
            Intrinsics.checkNotNullParameter(downloadedAmount, "downloadedAmount");
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue(instant, "now()");
            this.endInstant = instant;
            this.downloadedAmount = downloadedAmount;
            this.this$0.reportEvent(this);
        }
    }
}

