/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.reporting.telemetry;

import com.jetbrains.plugin.structure.base.telemetry.PluginTelemetry;
import com.jetbrains.pluginverifier.reporting.telemetry.TelemetryAggregator;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\bH\u0086\u0002J\u001b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0086\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\u0005*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/pluginverifier/reporting/telemetry/TelemetryAggregator;", "", "()V", "telemetries", "", "Lcom/jetbrains/pluginverifier/reporting/telemetry/TelemetryAggregator$PluginCoordinate;", "Lcom/jetbrains/plugin/structure/base/telemetry/PluginTelemetry;", "coordinate", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "getCoordinate", "(Lcom/jetbrains/pluginverifier/repository/PluginInfo;)Lcom/jetbrains/pluginverifier/reporting/telemetry/TelemetryAggregator$PluginCoordinate;", "get", "plugin", "id", "", "version", "reportTelemetry", "", "pluginInfo", "telemetry", "PluginCoordinate", "verifier-intellij"})
public final class TelemetryAggregator {
    @NotNull
    private final Map<PluginCoordinate, PluginTelemetry> telemetries = new ConcurrentHashMap();

    public final void reportTelemetry(@NotNull PluginInfo pluginInfo, @NotNull PluginTelemetry telemetry) {
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(telemetry, "telemetry");
        this.telemetries.merge(this.getCoordinate(pluginInfo), telemetry, (arg_0, arg_1) -> TelemetryAggregator.reportTelemetry$lambda$0(reportTelemetry.1.INSTANCE, arg_0, arg_1));
    }

    @Nullable
    public final PluginTelemetry get(@NotNull String id, @NotNull String version) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(version, "version");
        return this.telemetries.get(new PluginCoordinate(id, version));
    }

    @Nullable
    public final PluginTelemetry get(@NotNull PluginInfo plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        return this.telemetries.get(this.getCoordinate(plugin));
    }

    private final PluginCoordinate getCoordinate(PluginInfo $this$coordinate) {
        return new PluginCoordinate($this$coordinate.getPluginId(), $this$coordinate.getVersion());
    }

    private static final PluginTelemetry reportTelemetry$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (PluginTelemetry)$tmp0.invoke(p0, p1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/pluginverifier/reporting/telemetry/TelemetryAggregator$PluginCoordinate;", "", "id", "", "version", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getVersion", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "verifier-intellij"})
    private static final class PluginCoordinate {
        @NotNull
        private final String id;
        @NotNull
        private final String version;

        public PluginCoordinate(@NotNull String id, @NotNull String version) {
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter(version, "version");
            this.id = id;
            this.version = version;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.version;
        }

        @NotNull
        public final PluginCoordinate copy(@NotNull String id, @NotNull String version) {
            Intrinsics.checkNotNullParameter(id, "id");
            Intrinsics.checkNotNullParameter(version, "version");
            return new PluginCoordinate(id, version);
        }

        public static /* synthetic */ PluginCoordinate copy$default(PluginCoordinate pluginCoordinate, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = pluginCoordinate.id;
            }
            if ((n & 2) != 0) {
                string3 = pluginCoordinate.version;
            }
            return pluginCoordinate.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "PluginCoordinate(id=" + this.id + ", version=" + this.version + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.version.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PluginCoordinate)) {
                return false;
            }
            PluginCoordinate pluginCoordinate = (PluginCoordinate)other;
            if (!Intrinsics.areEqual(this.id, pluginCoordinate.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.version, pluginCoordinate.version);
        }
    }
}

