/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.plugin;

import com.jetbrains.pluginverifier.plugin.PluginDetailsCache;
import com.jetbrains.pluginverifier.plugin.PluginDetailsProvider;
import com.jetbrains.pluginverifier.plugin.PluginDetailsResourceProvider;
import com.jetbrains.pluginverifier.plugin.PluginFileProvider;
import com.jetbrains.pluginverifier.plugin.SizeLimitedPluginDetailsCache;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.cache.ResourceCache;
import com.jetbrains.pluginverifier.repository.cache.ResourceCacheEntry;
import com.jetbrains.pluginverifier.repository.cache.ResourceCacheEntryResult;
import com.jetbrains.pluginverifier.repository.cache.ResourceCacheKt;
import com.jetbrains.pluginverifier.repository.cleanup.SizeWeight;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0016R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/pluginverifier/plugin/SizeLimitedPluginDetailsCache;", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;", "cacheSize", "", "pluginFileProvider", "Lcom/jetbrains/pluginverifier/plugin/PluginFileProvider;", "pluginDetailsProvider", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsProvider;", "(ILcom/jetbrains/pluginverifier/plugin/PluginFileProvider;Lcom/jetbrains/pluginverifier/plugin/PluginDetailsProvider;)V", "internalCache", "Lcom/jetbrains/pluginverifier/repository/cache/ResourceCache;", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsProvider$Result;", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "Lcom/jetbrains/pluginverifier/repository/cleanup/SizeWeight;", "getPluginDetailsProvider", "()Lcom/jetbrains/pluginverifier/plugin/PluginDetailsProvider;", "getPluginFileProvider", "()Lcom/jetbrains/pluginverifier/plugin/PluginFileProvider;", "close", "", "getPluginDetailsCacheEntry", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache$Result;", "pluginInfo", "verifier-repository"})
public final class SizeLimitedPluginDetailsCache
implements PluginDetailsCache {
    @NotNull
    private final PluginFileProvider pluginFileProvider;
    @NotNull
    private final PluginDetailsProvider pluginDetailsProvider;
    @NotNull
    private final ResourceCache<PluginDetailsProvider.Result, PluginInfo, SizeWeight> internalCache;

    public SizeLimitedPluginDetailsCache(int cacheSize, @NotNull PluginFileProvider pluginFileProvider, @NotNull PluginDetailsProvider pluginDetailsProvider) {
        Intrinsics.checkNotNullParameter(pluginFileProvider, "pluginFileProvider");
        Intrinsics.checkNotNullParameter(pluginDetailsProvider, "pluginDetailsProvider");
        this.pluginFileProvider = pluginFileProvider;
        this.pluginDetailsProvider = pluginDetailsProvider;
        this.internalCache = ResourceCacheKt.createSizeLimitedResourceCache(cacheSize, new PluginDetailsResourceProvider(this.pluginFileProvider, this.pluginDetailsProvider), internalCache.1.INSTANCE, "PluginDetailsCache");
    }

    @NotNull
    public final PluginFileProvider getPluginFileProvider() {
        return this.pluginFileProvider;
    }

    @NotNull
    public final PluginDetailsProvider getPluginDetailsProvider() {
        return this.pluginDetailsProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public PluginDetailsCache.Result getPluginDetailsCacheEntry(@NotNull PluginInfo pluginInfo) throws InterruptedException {
        PluginDetailsCache.Result result2;
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        ResourceCacheEntryResult<PluginDetailsProvider.Result, SizeWeight> internalResult = this.internalCache.getResourceCacheEntry(pluginInfo);
        if (internalResult instanceof ResourceCacheEntryResult.Found) {
            ResourceCacheEntry<PluginDetailsProvider.Result.Provided, SizeWeight> internalEntry = ((ResourceCacheEntryResult.Found)internalResult).getResourceCacheEntry();
            PluginDetailsProvider.Result pluginDetailsProviderResult = (PluginDetailsProvider.Result)internalEntry.getResource();
            PluginDetailsProvider.Result result3 = pluginDetailsProviderResult;
            if (result3 instanceof PluginDetailsProvider.Result.Provided) {
                Intrinsics.checkNotNull(internalEntry, "null cannot be cast to non-null type com.jetbrains.pluginverifier.repository.cache.ResourceCacheEntry<com.jetbrains.pluginverifier.plugin.PluginDetailsProvider.Result.Provided, com.jetbrains.pluginverifier.repository.cleanup.SizeWeight>");
                result2 = new PluginDetailsCache.Result.Provided(internalEntry);
                return result2;
            } else if (result3 instanceof PluginDetailsProvider.Result.InvalidPlugin) {
                Intrinsics.checkNotNull(internalEntry, "null cannot be cast to non-null type com.jetbrains.pluginverifier.repository.cache.ResourceCacheEntry<com.jetbrains.pluginverifier.plugin.PluginDetailsProvider.Result.InvalidPlugin, com.jetbrains.pluginverifier.repository.cleanup.SizeWeight>");
                result2 = new PluginDetailsCache.Result.InvalidPlugin(internalEntry);
                return result2;
            } else {
                if (!(result3 instanceof PluginDetailsProvider.Result.Failed)) throw new NoWhenBranchMatchedException();
                result2 = new PluginDetailsCache.Result.Failed(((PluginDetailsProvider.Result.Failed)pluginDetailsProviderResult).getReason(), ((PluginDetailsProvider.Result.Failed)pluginDetailsProviderResult).getError());
            }
            return result2;
        } else if (internalResult instanceof ResourceCacheEntryResult.Failed) {
            result2 = new PluginDetailsCache.Result.Failed(((ResourceCacheEntryResult.Failed)internalResult).getMessage(), ((ResourceCacheEntryResult.Failed)internalResult).getError());
            return result2;
        } else {
            if (!(internalResult instanceof ResourceCacheEntryResult.NotFound)) throw new NoWhenBranchMatchedException();
            result2 = new PluginDetailsCache.Result.FileNotFound(((ResourceCacheEntryResult.NotFound)internalResult).getMessage());
        }
        return result2;
    }

    @Override
    public void close() {
        this.internalCache.close();
    }
}

