/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.options;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.filtering.AndroidProblemsFilter;
import com.jetbrains.pluginverifier.filtering.IdeaOnlyProblemsFilter;
import com.jetbrains.pluginverifier.filtering.IgnoreCondition;
import com.jetbrains.pluginverifier.filtering.IgnoredProblemsFilter;
import com.jetbrains.pluginverifier.filtering.KeepOnlyCondition;
import com.jetbrains.pluginverifier.filtering.KeepOnlyProblemsFilter;
import com.jetbrains.pluginverifier.filtering.ProblemsFilter;
import com.jetbrains.pluginverifier.filtering.documented.DocumentedProblemsFilter;
import com.jetbrains.pluginverifier.filtering.documented.DocumentedProblemsPage;
import com.jetbrains.pluginverifier.filtering.documented.DocumentedProblemsPagesFetcher;
import com.jetbrains.pluginverifier.filtering.documented.DocumentedProblemsParser;
import com.jetbrains.pluginverifier.ide.AvailableIde;
import com.jetbrains.pluginverifier.ide.IdeDescriptor;
import com.jetbrains.pluginverifier.ide.IdeDownloader;
import com.jetbrains.pluginverifier.ide.repositories.IdeRepository;
import com.jetbrains.pluginverifier.ide.repositories.IntelliJIdeRepository;
import com.jetbrains.pluginverifier.ide.repositories.ReleaseIdeRepository;
import com.jetbrains.pluginverifier.options.CmdOpts;
import com.jetbrains.pluginverifier.options.PluginParsingConfiguration;
import com.jetbrains.pluginverifier.options.SubmissionType;
import com.jetbrains.pluginverifier.output.OutputFormat;
import com.jetbrains.pluginverifier.output.OutputFormatKt;
import com.jetbrains.pluginverifier.output.OutputOptions;
import com.jetbrains.pluginverifier.output.teamcity.TeamCityHistory;
import com.jetbrains.pluginverifier.output.teamcity.TeamCityLog;
import com.jetbrains.pluginverifier.output.teamcity.TeamCityResultPrinter;
import com.jetbrains.pluginverifier.repository.downloader.DownloadResult;
import com.jetbrains.pluginverifier.verifiers.packages.DefaultPackageFilter;
import com.jetbrains.pluginverifier.verifiers.packages.PackageFilter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0010H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0010H\u0002J\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160*2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010,\u001a\u00020\u0014H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020.0*2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010/\u001a\u0002002\u0006\u0010\u0011\u001a\u00020\u0012J\u0017\u00101\u001a\u00020 *\b\u0012\u0004\u0012\u00020\u001402H\u0002\u00a2\u0006\u0002\u00103R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/jetbrains/pluginverifier/options/OptionsParser;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "TIMESTAMP_DATE_FORMAT", "Ljava/time/format/DateTimeFormatter;", "ideLatestRegexp", "Lkotlin/text/Regex;", "ideLatestReleaseRegexp", "createDocumentedProblemsFilter", "Lcom/jetbrains/pluginverifier/filtering/documented/DocumentedProblemsFilter;", "createIdeDescriptor", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;", "idePath", "Ljava/nio/file/Path;", "opts", "Lcom/jetbrains/pluginverifier/options/CmdOpts;", "ide", "", "createIgnoredProblemsFilter", "Lcom/jetbrains/pluginverifier/filtering/ProblemsFilter;", "createKeepOnlyProblemsFilter", "createPluginParsingConfiguration", "Lcom/jetbrains/pluginverifier/options/PluginParsingConfiguration;", "createSubsystemProblemsFilter", "downloadIde", "productCode", "ideRepository", "Lcom/jetbrains/pluginverifier/ide/repositories/IdeRepository;", "latestOrLatestRelease", "", "getExternalClassesPackageFilter", "Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;", "getIgnoreFilter", "Lcom/jetbrains/pluginverifier/filtering/IgnoredProblemsFilter;", "ignoreProblemsFile", "getKeepOnlyFilter", "Lcom/jetbrains/pluginverifier/filtering/KeepOnlyProblemsFilter;", "keepOnlyProblemsFile", "getProblemsFilters", "", "getVerificationReportsDirectory", "newVerificationDirectoryName", "parseOutputFormats", "Lcom/jetbrains/pluginverifier/output/OutputFormat;", "parseOutputOptions", "Lcom/jetbrains/pluginverifier/output/OutputOptions;", "isExplicitlyEmpty", "", "([Ljava/lang/String;)Z", "verifier-cli"})
@SourceDebugExtension(value={"SMAP\nOptionsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionsParser.kt\ncom/jetbrains/pluginverifier/options/OptionsParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,288:1\n1#2:289\n1#2:310\n1#2:327\n23035#3,10:290\n11335#3:350\n11670#3,3:351\n1603#4,9:300\n1855#4:309\n1856#4:311\n1612#4:312\n1549#4:313\n1620#4,3:314\n1603#4,9:317\n1855#4:326\n1856#4:328\n1612#4:329\n766#4:330\n857#4,2:331\n766#4:333\n857#4,2:334\n1963#4,14:336\n1549#4:354\n1620#4,3:355\n1360#4:358\n1446#4,5:359\n*S KotlinDebug\n*F\n+ 1 OptionsParser.kt\ncom/jetbrains/pluginverifier/options/OptionsParser\n*L\n73#1:310\n83#1:327\n71#1:290,10\n185#1:350\n185#1:351,3\n73#1:300,9\n73#1:309\n73#1:311\n73#1:312\n82#1:313\n82#1:314,3\n83#1:317,9\n83#1:326\n83#1:328\n83#1:329\n157#1:330\n157#1:331,2\n158#1:333\n158#1:334,2\n159#1:336,14\n187#1:354\n187#1:355,3\n238#1:358\n238#1:359,5\n*E\n"})
public final class OptionsParser {
    @NotNull
    public static final OptionsParser INSTANCE = new OptionsParser();
    private static final Logger LOG = LoggerFactory.getLogger(OptionsParser.class);
    private static final DateTimeFormatter TIMESTAMP_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd 'at' HH.mm.ss");
    @NotNull
    private static final Regex ideLatestRegexp = new Regex("\\[latest(-([A-Z]+))?]");
    @NotNull
    private static final Regex ideLatestReleaseRegexp = new Regex("\\[latest-release(-([A-Z]+))?]");

    private OptionsParser() {
    }

    private final Path getVerificationReportsDirectory(CmdOpts opts) {
        String string2 = opts.getVerificationReportsDir();
        if (string2 == null) {
            string2 = this.newVerificationDirectoryName();
        }
        Path reportDirectory = Paths.get(string2, new String[0]);
        Intrinsics.checkNotNullExpressionValue(reportDirectory, "reportDirectory");
        if (FileUtilKt.exists(reportDirectory) && !((Collection)FileUtilKt.listFiles(reportDirectory)).isEmpty()) {
            LOG.info("The verification directory " + reportDirectory.toAbsolutePath() + " is being deleted because it is not empty.");
            FileUtilKt.deleteLogged(reportDirectory);
        }
        FileUtilKt.createDir(reportDirectory);
        return reportDirectory;
    }

    private final String newVerificationDirectoryName() {
        String nowTime = TIMESTAMP_DATE_FORMAT.format(LocalDateTime.now());
        return FileUtilKt.replaceInvalidFileNameCharacters("verification-" + nowTime);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final OutputOptions parseOutputOptions(@NotNull CmdOpts opts) {
        Intrinsics.checkNotNullParameter(opts, "opts");
        verificationReportsDirectory = this.getVerificationReportsDirectory(opts);
        var3_3 = "Verification reports directory: %s";
        var4_4 = new Object[]{verificationReportsDirectory};
        v0 = String.format(var3_3, Arrays.copyOf(var4_4, var4_4.length));
        Intrinsics.checkNotNullExpressionValue(v0, "format(this, *args)");
        var3_3 = v0;
        System.out.println((Object)var3_3);
        if (opts.getNeedTeamCityLog()) {
            v1 = System.out;
            Intrinsics.checkNotNullExpressionValue(v1, "out");
            v2 = new TeamCityLog(v1);
        } else {
            v2 = teamCityLog = null;
        }
        if ((v3 = opts.getPreviousTcTestsFile()) == null) ** GOTO lbl-1000
        it = v3;
        $i$a$-let-OptionsParser$parseOutputOptions$previousTcHistory$1 = false;
        v4 = Paths.get((String)it, new String[0]);
        v3 = v4;
        if (v4 != null) {
            it = v3;
            $i$a$-let-OptionsParser$parseOutputOptions$previousTcHistory$2 = false;
            v5 = TeamCityHistory.Companion.readFromFile((Path)it);
        } else lbl-1000:
        // 2 sources

        {
            v5 = null;
        }
        previousTcHistory = v5;
        outputFormats = this.parseOutputFormats(opts);
        return new OutputOptions(verificationReportsDirectory, teamCityLog, TeamCityResultPrinter.GroupBy.Companion.parse(opts.getTeamCityGroupType()), previousTcHistory, outputFormats);
    }

    /*
     * WARNING - void declaration
     */
    private final List<OutputFormat> parseOutputFormats(CmdOpts opts) {
        List<OutputFormat> list;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$mapTo$iv$iv;
        List<OutputFormat> list2;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        if (this.isExplicitlyEmpty(opts.getOutputFormats())) {
            return CollectionsKt.emptyList();
        }
        String[] $this$partition$iv = opts.getOutputFormats();
        boolean $i$f$partition = false;
        ArrayList<String> first$iv = new ArrayList<String>();
        ArrayList<String> second$iv = new ArrayList<String>();
        int n = $this$partition$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$partition$iv[i];
            boolean bl = false;
            if (StringsKt.startsWith$default(((Object)StringsKt.trim((CharSequence)it)).toString(), "-", false, 2, null)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List exclusions = pair.component1();
        List inclusions = pair.component2();
        Collection<OutputFormat> $this$mapNotNull$iv2 = inclusions;
        boolean $i$f$mapNotNull = false;
        List<OutputFormat> list3 = $this$mapNotNull$iv2;
        Iterable<OutputFormat> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            OutputFormat it$iv$iv;
            OutputFormat outputFormat;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                String string2 = it.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toUpperCase(Locale.ROOT)");
                outputFormat = OutputFormat.valueOf(string2);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unsupported verification report output format '" + it + "'. Skipping this output format.");
                outputFormat = null;
            }
            if (outputFormat == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv2 = (List)destination$iv$iv;
        if ($this$mapNotNull$iv2.isEmpty()) {
            boolean bl = false;
            list2 = OutputFormatKt.getDEFAULT_OUTPUT_FORMATS();
        } else {
            list2 = $this$mapNotNull$iv2;
        }
        List includedFormats = list2;
        Iterable $this$map$iv = exclusions;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (String)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(StringsKt.removePrefix((String)it, (CharSequence)"-"));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNull2 = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator3.hasNext()) {
            OutputFormat it$iv$iv;
            OutputFormat outputFormat;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = iterator3.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl4 = false;
            try {
                String string3 = it.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toUpperCase(Locale.ROOT)");
                outputFormat = OutputFormat.valueOf(string3);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unsupported verification report output format '" + it + "' specified for exclusion. Ignoring this output format.");
                outputFormat = null;
            }
            if (outputFormat == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set excludedFormats = CollectionsKt.toSet((List)destination$iv$iv2);
        List<OutputFormat> list4 = CollectionsKt.minus((Iterable)includedFormats, excludedFormats);
        if (list4.isEmpty()) {
            boolean bl = false;
            LOG.warn("No supported output formats were set. Falling back to the default set");
            list = OutputFormatKt.getDEFAULT_OUTPUT_FORMATS();
        } else {
            list = list4;
        }
        return list;
    }

    @NotNull
    public final IdeDescriptor createIdeDescriptor(@NotNull String ide, @NotNull CmdOpts opts) {
        Intrinsics.checkNotNullParameter(ide, "ide");
        Intrinsics.checkNotNullParameter(opts, "opts");
        Path ideFile = StringsKt.startsWith$default(ide, "[", false, 2, null) && StringsKt.endsWith$default(ide, "]", false, 2, null) ? this.downloadIde(ide) : Paths.get(ide, new String[0]);
        Intrinsics.checkNotNullExpressionValue(ideFile, "ideFile");
        if (!FileUtilKt.isDirectory(ideFile)) {
            boolean bl = false;
            String string2 = "IDE must reside in a directory: " + ideFile;
            throw new IllegalArgumentException(string2.toString());
        }
        String string3 = "Reading IDE from %s";
        Object[] objectArray = new Object[]{ideFile};
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string4, "format(this, *args)");
        LOG.info(string4);
        return this.createIdeDescriptor(ideFile, opts);
    }

    @NotNull
    public final IdeDescriptor createIdeDescriptor(@NotNull Path idePath, @NotNull CmdOpts opts) {
        Path path;
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        Intrinsics.checkNotNullParameter(opts, "opts");
        String string2 = opts.getRuntimeDir();
        if (string2 != null) {
            Path path2;
            String it = string2;
            boolean bl = false;
            Path it2 = path2 = Paths.get(it, new String[0]);
            boolean bl2 = false;
            LOG.info("Using Java runtime from " + it2);
            path = path2;
        } else {
            path = null;
        }
        Path defaultJdkPath = path;
        return IdeDescriptor.Companion.create(idePath, defaultJdkPath, null);
    }

    @NotNull
    public final PluginParsingConfiguration createPluginParsingConfiguration(@NotNull CmdOpts opts) {
        Intrinsics.checkNotNullParameter(opts, "opts");
        CmdOpts $this$createPluginParsingConfiguration_u24lambda_u2411 = opts;
        boolean bl = false;
        String string2 = $this$createPluginParsingConfiguration_u24lambda_u2411.getSubmissionType();
        SubmissionType submissionType = Intrinsics.areEqual(string2, "existing") ? SubmissionType.EXISTING : (Intrinsics.areEqual(string2, "new") ? SubmissionType.NEW : SubmissionType.NEW);
        return new PluginParsingConfiguration(submissionType, ArraysKt.toList($this$createPluginParsingConfiguration_u24lambda_u2411.getMutedPluginProblems()));
    }

    private final Path downloadIde(String ide) {
        MatchResult latestMatch = ideLatestRegexp.matchEntire(ide);
        if (latestMatch != null) {
            Object productCode;
            Object object = latestMatch.getGroups().get(2);
            if (object == null || (object = ((MatchGroup)object).getValue()) == null) {
                object = "IU";
            }
            IdeRepository repository = Intrinsics.areEqual(productCode = object, "IU") ? (IdeRepository)new IntelliJIdeRepository(IntelliJIdeRepository.Channel.SNAPSHOTS) : (IdeRepository)new ReleaseIdeRepository(null, 1, null);
            return this.downloadIde((String)productCode, repository, true);
        }
        MatchResult latestReleaseMatch = ideLatestReleaseRegexp.matchEntire(ide);
        if (latestReleaseMatch != null) {
            Object object = latestReleaseMatch.getGroups().get(2);
            if (object == null || (object = ((MatchGroup)object).getValue()) == null) {
                object = "IU";
            }
            Object productCode = object;
            return this.downloadIde((String)productCode, new ReleaseIdeRepository(null, 1, null), false);
        }
        throw new IllegalArgumentException("IDE pattern does not match any of: " + ideLatestRegexp.getPattern() + ", " + ideLatestReleaseRegexp.getPattern());
    }

    /*
     * WARNING - void declaration
     */
    private final Path downloadIde(String productCode, IdeRepository ideRepository, boolean latestOrLatestRelease) {
        Object idesDirectory;
        Path ideDirectory;
        Object object;
        AvailableIde availableIde;
        String releaseModifier;
        block16: {
            block15: {
                Object v0;
                void $this$maxByOrNull$iv;
                AvailableIde it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                releaseModifier = (latestOrLatestRelease ? "latest" : "latest release") + " of " + productCode;
                LOG.info("Requesting the index of available IDE builds for the " + releaseModifier + " from " + ideRepository);
                Iterable iterable = ideRepository.fetchIndex();
                boolean $i$f$filter = false;
                void var8_8 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (AvailableIde)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getProduct().getProductCode(), productCode)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (AvailableIde)element$iv$iv;
                    boolean bl = false;
                    if (!(latestOrLatestRelease ? true : it.isRelease())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = maxElem$iv;
                    } else {
                        AvailableIde it2 = (AvailableIde)maxElem$iv;
                        boolean bl = false;
                        Comparable maxValue$iv = it2.getVersion();
                        do {
                            Object e$iv = iterator$iv.next();
                            AvailableIde it3 = (AvailableIde)e$iv;
                            $i$a$-maxByOrNull-OptionsParser$downloadIde$availableIde$3 = false;
                            Comparable v$iv = it3.getVersion();
                            if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = maxElem$iv;
                    }
                }
                if ((availableIde = (AvailableIde)v0) == null) {
                    throw new IllegalArgumentException("No IDE found for " + productCode + " in " + ideRepository);
                }
                object = System.getProperty("intellij.plugin.verifier.download.ide.temp.dir");
                if (object == null) break block15;
                String it4 = object;
                boolean bl = false;
                Path path = Paths.get(it4, new String[0]);
                object = path;
                if (path != null) break block16;
            }
            object = Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve("downloaded-ides");
        }
        if (Files.isDirectory(ideDirectory = (idesDirectory = object).resolve(availableIde.getVersion().asString()), new LinkOption[0])) {
            LOG.info("IDE " + releaseModifier + " is already downloaded to " + ideDirectory);
            Intrinsics.checkNotNullExpressionValue(ideDirectory, "ideDirectory");
            return ideDirectory;
        }
        Path path = idesDirectory.resolve("downloading");
        Intrinsics.checkNotNullExpressionValue(path, "idesDirectory.resolve(\"downloading\")");
        Path downloadingTempDir = FileUtilKt.createDir(path);
        LOG.info("Downloading " + releaseModifier + " " + availableIde.getVersion() + " from " + ideRepository + " to " + ideDirectory);
        DownloadResult downloadResult = new IdeDownloader().download(availableIde, downloadingTempDir);
        if (!(downloadResult instanceof DownloadResult.Downloaded)) {
            if (downloadResult instanceof DownloadResult.NotFound) {
                throw new IllegalArgumentException("No IDE found for " + productCode + " in " + ideRepository);
            }
            if (downloadResult instanceof DownloadResult.FailedToDownload) {
                throw new RuntimeException("Failed to download IDE " + productCode, ((DownloadResult.FailedToDownload)downloadResult).getError());
            }
            throw new NoWhenBranchMatchedException();
        }
        Files.move(((DownloadResult.Downloaded)downloadResult).getDownloadedFileOrDirectory(), ideDirectory, new CopyOption[0]);
        Path path2 = ideDirectory;
        Intrinsics.checkNotNullExpressionValue(path2, "{\n        Files.move(dow\u2026     ideDirectory\n      }");
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PackageFilter getExternalClassesPackageFilter(@NotNull CmdOpts opts) {
        void $this$mapTo$iv$iv;
        Iterable item$iv$iv2;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(opts, "opts");
        String[] $this$map$iv = opts.getExternalClassesPrefixes();
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Iterable item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            void var10_12 = item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.replace$default((String)it, '.', '/', false, 4, null));
        }
        List list = (List)destination$iv$iv;
        boolean bl = false;
        Iterable $this$map$iv2 = list;
        boolean $i$f$map2 = false;
        item$iv$iv2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv3;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new DefaultPackageFilter.Descriptor(true, (String)it));
        }
        List list2 = (List)destination$iv$iv2;
        return new DefaultPackageFilter(list2);
    }

    private final ProblemsFilter createIgnoredProblemsFilter(CmdOpts opts) {
        if (opts.getIgnoreProblemsFile() != null) {
            String string2 = opts.getIgnoreProblemsFile();
            Intrinsics.checkNotNull(string2);
            Path file2 = Paths.get(string2, new String[0]);
            Intrinsics.checkNotNullExpressionValue(file2, "file");
            if (!FileUtilKt.exists(file2)) {
                boolean bl = false;
                String string3 = "Ignored problems file doesn't exist " + file2;
                throw new IllegalArgumentException(string3.toString());
            }
            return this.getIgnoreFilter(file2);
        }
        return null;
    }

    private final ProblemsFilter createKeepOnlyProblemsFilter(CmdOpts opts) {
        if (opts.getKeepOnlyProblemsFile() != null) {
            String string2 = opts.getKeepOnlyProblemsFile();
            Intrinsics.checkNotNull(string2);
            Path file2 = Paths.get(string2, new String[0]);
            Intrinsics.checkNotNullExpressionValue(file2, "file");
            if (!FileUtilKt.exists(file2)) {
                boolean bl = false;
                String string3 = "Keep only problems file doesn't exist " + file2;
                throw new IllegalArgumentException(string3.toString());
            }
            return this.getKeepOnlyFilter(file2);
        }
        return null;
    }

    private final ProblemsFilter createSubsystemProblemsFilter(CmdOpts opts) {
        String string2 = opts.getSubsystemsToCheck();
        return Intrinsics.areEqual(string2, "android-only") ? (ProblemsFilter)new AndroidProblemsFilter() : (Intrinsics.areEqual(string2, "without-android") ? (ProblemsFilter)new IdeaOnlyProblemsFilter() : null);
    }

    @NotNull
    public final List<ProblemsFilter> getProblemsFilters(@NotNull CmdOpts opts) {
        DocumentedProblemsFilter documentedProblemsFilter;
        Intrinsics.checkNotNullParameter(opts, "opts");
        ProblemsFilter keepOnlyProblemsFilter = this.createKeepOnlyProblemsFilter(opts);
        ProblemsFilter ignoredProblemsFilter = this.createIgnoredProblemsFilter(opts);
        try {
            documentedProblemsFilter = opts.getOfflineMode() ? null : this.createDocumentedProblemsFilter();
        }
        catch (Exception e) {
            LOG.error("Unable to read documented IntelliJ API incompatible changes. Corresponding API problems won't be ignored.", e);
            documentedProblemsFilter = null;
        }
        DocumentedProblemsFilter documentedProblemsFilter2 = documentedProblemsFilter;
        ProblemsFilter codeProblemsFilter = this.createSubsystemProblemsFilter(opts);
        ProblemsFilter[] problemsFilterArray = new ProblemsFilter[]{keepOnlyProblemsFilter, ignoredProblemsFilter, documentedProblemsFilter2, codeProblemsFilter};
        return CollectionsKt.listOfNotNull(problemsFilterArray);
    }

    /*
     * WARNING - void declaration
     */
    private final DocumentedProblemsFilter createDocumentedProblemsFilter() {
        void $this$flatMapTo$iv$iv;
        List documentedPages = DocumentedProblemsPagesFetcher.fetchPages$default(new DocumentedProblemsPagesFetcher(), null, 1, null);
        DocumentedProblemsParser documentedProblemsParser = new DocumentedProblemsParser(true);
        Iterable $this$flatMap$iv = documentedPages;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DocumentedProblemsPage it = (DocumentedProblemsPage)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = documentedProblemsParser.parse(it.getPageBody());
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List documentedProblems = (List)destination$iv$iv;
        return new DocumentedProblemsFilter(documentedProblems);
    }

    private final IgnoredProblemsFilter getIgnoreFilter(Path ignoreProblemsFile) {
        ArrayList<IgnoreCondition> ignoreConditions = new ArrayList<IgnoreCondition>();
        try {
            FileUtilKt.forEachLine$default(ignoreProblemsFile, null, new Function1<String, Unit>(ignoreConditions){
                final /* synthetic */ ArrayList<IgnoreCondition> $ignoreConditions;
                {
                    this.$ignoreConditions = $ignoreConditions;
                    super(1);
                }

                public final void invoke(@NotNull String lineT) {
                    Intrinsics.checkNotNullParameter(lineT, "lineT");
                    String line = ((Object)StringsKt.trim((CharSequence)lineT)).toString();
                    if (StringsKt.isBlank(line) || StringsKt.startsWith$default(line, "//", false, 2, null)) {
                        return;
                    }
                    this.$ignoreConditions.add(IgnoreCondition.Companion.parseCondition(line));
                }
            }, 1, null);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            throw new IllegalArgumentException("Unable to parse ignored problems file " + ignoreProblemsFile, e);
        }
        return new IgnoredProblemsFilter((List<IgnoreCondition>)ignoreConditions);
    }

    private final KeepOnlyProblemsFilter getKeepOnlyFilter(Path keepOnlyProblemsFile) {
        ArrayList<KeepOnlyCondition> keepOnlyConditions = new ArrayList<KeepOnlyCondition>();
        try {
            FileUtilKt.forEachLine$default(keepOnlyProblemsFile, null, new Function1<String, Unit>(keepOnlyConditions){
                final /* synthetic */ ArrayList<KeepOnlyCondition> $keepOnlyConditions;
                {
                    this.$keepOnlyConditions = $keepOnlyConditions;
                    super(1);
                }

                public final void invoke(@NotNull String lineT) {
                    Intrinsics.checkNotNullParameter(lineT, "lineT");
                    String line = ((Object)StringsKt.trim((CharSequence)lineT)).toString();
                    if (StringsKt.isBlank(line) || StringsKt.startsWith$default(line, "//", false, 2, null)) {
                        return;
                    }
                    this.$keepOnlyConditions.add(KeepOnlyCondition.Companion.parseCondition(line));
                }
            }, 1, null);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            throw new IllegalArgumentException("Unable to parse keep only problems file " + keepOnlyProblemsFile, e);
        }
        return new KeepOnlyProblemsFilter((List<KeepOnlyCondition>)keepOnlyConditions);
    }

    private final boolean isExplicitlyEmpty(String[] $this$isExplicitlyEmpty) {
        return $this$isExplicitlyEmpty.length == 1 && ((CharSequence)ArraysKt.first($this$isExplicitlyEmpty)).length() == 0;
    }
}

