/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.misc;

import com.jetbrains.pluginverifier.misc.ExponentialBackOff;
import com.jetbrains.pluginverifier.misc.RecoverStrategy;
import com.jetbrains.pluginverifier.misc.RetryUtilKt;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/pluginverifier/misc/ExponentialBackOff;", "Lcom/jetbrains/pluginverifier/misc/RecoverStrategy;", "initialDelayMs", "", "(J)V", "effectiveDelay", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "random$delegate", "Lkotlin/Lazy;", "backOff", "previousDelay", "cause", "", "recover", "", "error", "attemptNumber", "", "Companion", "verifier-repository"})
public final class ExponentialBackOff
extends RecoverStrategy {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy random$delegate;
    private long effectiveDelay;
    private static final long BACKOFF_LIMIT_MS = TimeUnit.MINUTES.toMillis(3L);
    @Deprecated
    public static final int BACKOFF_FACTOR = 2;
    @Deprecated
    public static final double BACKOFF_JITTER = 0.1;

    public ExponentialBackOff(long initialDelayMs) {
        this.random$delegate = LazyKt.lazy(random.2.INSTANCE);
        this.effectiveDelay = initialDelayMs;
    }

    public /* synthetic */ ExponentialBackOff(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = RetryUtilKt.access$getINITIAL_DELAY_MS$p();
        }
        this(l);
    }

    private final Random getRandom() {
        Lazy lazy = this.random$delegate;
        return (Random)lazy.getValue();
    }

    @Override
    public void recover(@NotNull Throwable error, int attemptNumber) {
        Intrinsics.checkNotNullParameter(error, "error");
        if (attemptNumber > 1) {
            this.effectiveDelay = this.backOff(this.effectiveDelay, error);
        }
        RetryUtilKt.access$getLOG$p().info("Retrying in " + this.effectiveDelay + "ms");
        if (this.effectiveDelay > 0L) {
            Thread.sleep(this.effectiveDelay);
        }
    }

    private final long backOff(long previousDelay, Throwable cause) {
        long nextDelay = Math.min(previousDelay * (long)2, BACKOFF_LIMIT_MS) + (long)(this.getRandom().nextGaussian() * (double)previousDelay * 0.1);
        if (nextDelay > BACKOFF_LIMIT_MS) {
            throw new Exception("Back off limit " + BACKOFF_LIMIT_MS + "ms exceeded, see nested exception for details", cause);
        }
        return nextDelay;
    }

    public ExponentialBackOff() {
        this(0L, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/pluginverifier/misc/ExponentialBackOff$Companion;", "", "()V", "BACKOFF_FACTOR", "", "BACKOFF_JITTER", "", "BACKOFF_LIMIT_MS", "", "getBACKOFF_LIMIT_MS", "()J", "verifier-repository"})
    private static final class Companion {
        private Companion() {
        }

        public final long getBACKOFF_LIMIT_MS() {
            return BACKOFF_LIMIT_MS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

