/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.ide;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.ide.IdeDownloadProvider;
import com.jetbrains.pluginverifier.ide.repositories.IdeRepository;
import com.jetbrains.pluginverifier.repository.cleanup.DiskSpaceSetting;
import com.jetbrains.pluginverifier.repository.cleanup.LruFileSizeSweepPolicy;
import com.jetbrains.pluginverifier.repository.files.AvailableFile;
import com.jetbrains.pluginverifier.repository.files.FileLock;
import com.jetbrains.pluginverifier.repository.files.FileRepository;
import com.jetbrains.pluginverifier.repository.files.FileRepositoryKt;
import com.jetbrains.pluginverifier.repository.files.FileRepositoryResult;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000e0\rJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeFilesBank;", "", "bankDirectory", "Ljava/nio/file/Path;", "ideRepository", "Lcom/jetbrains/pluginverifier/ide/repositories/IdeRepository;", "diskSpaceSetting", "Lcom/jetbrains/pluginverifier/repository/cleanup/DiskSpaceSetting;", "(Ljava/nio/file/Path;Lcom/jetbrains/pluginverifier/ide/repositories/IdeRepository;Lcom/jetbrains/pluginverifier/repository/cleanup/DiskSpaceSetting;)V", "ideFilesRepository", "Lcom/jetbrains/pluginverifier/repository/files/FileRepository;", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "getAvailableIdeFiles", "", "Lcom/jetbrains/pluginverifier/repository/files/AvailableFile;", "getAvailableIdeVersions", "", "getIdeFile", "Lcom/jetbrains/pluginverifier/ide/IdeFilesBank$Result;", "ideVersion", "getIdeVersionByPath", "file", "toString", "", "Result", "verifier-repository"})
public final class IdeFilesBank {
    @NotNull
    private final Path bankDirectory;
    @NotNull
    private final FileRepository<IdeVersion> ideFilesRepository;

    public IdeFilesBank(@NotNull Path bankDirectory, @NotNull IdeRepository ideRepository, @NotNull DiskSpaceSetting diskSpaceSetting) {
        Intrinsics.checkNotNullParameter(bankDirectory, "bankDirectory");
        Intrinsics.checkNotNullParameter(ideRepository, "ideRepository");
        Intrinsics.checkNotNullParameter(diskSpaceSetting, "diskSpaceSetting");
        this.bankDirectory = bankDirectory;
        this.ideFilesRepository = FileRepositoryKt.addInitialFilesFrom(new FileRepository(new IdeDownloadProvider(this.bankDirectory, ideRepository), new LruFileSizeSweepPolicy(diskSpaceSetting), null, null, 12, null), this.bankDirectory, (Function1)new Function1<Path, IdeVersion>(this){
            final /* synthetic */ IdeFilesBank this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final IdeVersion invoke(@NotNull Path it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return IdeFilesBank.access$getIdeVersionByPath(this.this$0, it);
            }
        });
    }

    private final IdeVersion getIdeVersionByPath(Path file2) {
        IdeVersion ideVersion;
        return FileUtilKt.isDirectory(file2) ? ((ideVersion = IdeVersion.createIdeVersionIfValid(FileUtilKt.getSimpleName(file2))) != null ? (IdeVersion)ideVersion.setProductCodeIfAbsent("IU") : null) : null;
    }

    @NotNull
    public final Set<IdeVersion> getAvailableIdeVersions() {
        return this.ideFilesRepository.getAllExistingKeys();
    }

    @NotNull
    public final List<AvailableFile<IdeVersion>> getAvailableIdeFiles() {
        return this.ideFilesRepository.getAvailableFiles();
    }

    @NotNull
    public final Result getIdeFile(@NotNull IdeVersion ideVersion) throws InterruptedException {
        Result result2;
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        FileRepositoryResult $this$getIdeFile_u24lambda_u240 = this.ideFilesRepository.getFile(ideVersion);
        boolean bl = false;
        FileRepositoryResult fileRepositoryResult = $this$getIdeFile_u24lambda_u240;
        if (fileRepositoryResult instanceof FileRepositoryResult.Found) {
            result2 = new Result.Found(((FileRepositoryResult.Found)$this$getIdeFile_u24lambda_u240).getLockedFile());
        } else if (fileRepositoryResult instanceof FileRepositoryResult.NotFound) {
            result2 = new Result.NotFound(((FileRepositoryResult.NotFound)$this$getIdeFile_u24lambda_u240).getReason());
        } else if (fileRepositoryResult instanceof FileRepositoryResult.Failed) {
            result2 = new Result.Failed(((FileRepositoryResult.Failed)$this$getIdeFile_u24lambda_u240).getReason(), ((FileRepositoryResult.Failed)$this$getIdeFile_u24lambda_u240).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result2;
    }

    @NotNull
    public String toString() {
        return "IDEs at " + this.bankDirectory;
    }

    public static final /* synthetic */ IdeVersion access$getIdeVersionByPath(IdeFilesBank $this, Path file2) {
        return $this.getIdeVersionByPath(file2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeFilesBank$Result;", "", "()V", "Failed", "Found", "NotFound", "Lcom/jetbrains/pluginverifier/ide/IdeFilesBank$Result$Failed;", "Lcom/jetbrains/pluginverifier/ide/IdeFilesBank$Result$Found;", "Lcom/jetbrains/pluginverifier/ide/IdeFilesBank$Result$NotFound;", "verifier-repository"})
    public static abstract class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\r\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeFilesBank$Result$Failed;", "Lcom/jetbrains/pluginverifier/ide/IdeFilesBank$Result;", "reason", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "getException", "()Ljava/lang/Exception;", "getReason", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "verifier-repository"})
        public static final class Failed
        extends Result {
            @NotNull
            private final String reason;
            @NotNull
            private final Exception exception;

            public Failed(@NotNull String reason, @NotNull Exception exception) {
                Intrinsics.checkNotNullParameter(reason, "reason");
                Intrinsics.checkNotNullParameter(exception, "exception");
                super(null);
                this.reason = reason;
                this.exception = exception;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            @NotNull
            public final Exception getException() {
                return this.exception;
            }

            @NotNull
            public final String component1() {
                return this.reason;
            }

            @NotNull
            public final Exception component2() {
                return this.exception;
            }

            @NotNull
            public final Failed copy(@NotNull String reason, @NotNull Exception exception) {
                Intrinsics.checkNotNullParameter(reason, "reason");
                Intrinsics.checkNotNullParameter(exception, "exception");
                return new Failed(reason, exception);
            }

            public static /* synthetic */ Failed copy$default(Failed failed, String string2, Exception exception, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = failed.reason;
                }
                if ((n & 2) != 0) {
                    exception = failed.exception;
                }
                return failed.copy(string2, exception);
            }

            @NotNull
            public String toString() {
                return "Failed(reason=" + this.reason + ", exception=" + this.exception + ")";
            }

            public int hashCode() {
                int result2 = this.reason.hashCode();
                result2 = result2 * 31 + this.exception.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failed)) {
                    return false;
                }
                Failed failed = (Failed)other;
                if (!Intrinsics.areEqual(this.reason, failed.reason)) {
                    return false;
                }
                return Intrinsics.areEqual(this.exception, failed.exception);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeFilesBank$Result$Found;", "Lcom/jetbrains/pluginverifier/ide/IdeFilesBank$Result;", "ideFileLock", "Lcom/jetbrains/pluginverifier/repository/files/FileLock;", "(Lcom/jetbrains/pluginverifier/repository/files/FileLock;)V", "getIdeFileLock", "()Lcom/jetbrains/pluginverifier/repository/files/FileLock;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "verifier-repository"})
        public static final class Found
        extends Result {
            @NotNull
            private final FileLock ideFileLock;

            public Found(@NotNull FileLock ideFileLock) {
                Intrinsics.checkNotNullParameter(ideFileLock, "ideFileLock");
                super(null);
                this.ideFileLock = ideFileLock;
            }

            @NotNull
            public final FileLock getIdeFileLock() {
                return this.ideFileLock;
            }

            @NotNull
            public final FileLock component1() {
                return this.ideFileLock;
            }

            @NotNull
            public final Found copy(@NotNull FileLock ideFileLock) {
                Intrinsics.checkNotNullParameter(ideFileLock, "ideFileLock");
                return new Found(ideFileLock);
            }

            public static /* synthetic */ Found copy$default(Found found, FileLock fileLock, int n, Object object) {
                if ((n & 1) != 0) {
                    fileLock = found.ideFileLock;
                }
                return found.copy(fileLock);
            }

            @NotNull
            public String toString() {
                return "Found(ideFileLock=" + this.ideFileLock + ")";
            }

            public int hashCode() {
                return this.ideFileLock.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Found)) {
                    return false;
                }
                Found found = (Found)other;
                return Intrinsics.areEqual(this.ideFileLock, found.ideFileLock);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/pluginverifier/ide/IdeFilesBank$Result$NotFound;", "Lcom/jetbrains/pluginverifier/ide/IdeFilesBank$Result;", "reason", "", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "verifier-repository"})
        public static final class NotFound
        extends Result {
            @NotNull
            private final String reason;

            public NotFound(@NotNull String reason) {
                Intrinsics.checkNotNullParameter(reason, "reason");
                super(null);
                this.reason = reason;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }

            @NotNull
            public final String component1() {
                return this.reason;
            }

            @NotNull
            public final NotFound copy(@NotNull String reason) {
                Intrinsics.checkNotNullParameter(reason, "reason");
                return new NotFound(reason);
            }

            public static /* synthetic */ NotFound copy$default(NotFound notFound, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = notFound.reason;
                }
                return notFound.copy(string2);
            }

            @NotNull
            public String toString() {
                return "NotFound(reason=" + this.reason + ")";
            }

            public int hashCode() {
                return this.reason.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NotFound)) {
                    return false;
                }
                NotFound notFound = (NotFound)other;
                return Intrinsics.areEqual(this.reason, notFound.reason);
            }
        }
    }
}

