/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.containers.SimpleEntry;
import com.intellij.util.containers.ThreadLocalRandom;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;

@Deprecated
final class ConcurrentIntObjectHashMap<V>
implements ConcurrentIntObjectMap<V> {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int DEFAULT_CAPACITY = 16;
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    private static final int MIN_TRANSFER_STRIDE = 16;
    private static final int RESIZE_STAMP_BITS = 16;
    private static final int MAX_RESIZERS = 65535;
    private static final int RESIZE_STAMP_SHIFT = 16;
    static final int MOVED = -1;
    static final int TREEBIN = -2;
    static final int RESERVED = -3;
    static final int HASH_BITS = Integer.MAX_VALUE;
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    volatile transient Node<V>[] table;
    private volatile transient Node<V>[] nextTable;
    private volatile transient long baseCount;
    private volatile transient int sizeCtl;
    private volatile transient int transferIndex;
    private volatile transient int cellsBusy;
    private volatile transient CounterCell[] counterCells;
    private transient ValuesView<V> values;
    private transient EntrySetView<V> entrySet;
    private static final long SIZECTL;
    private static final long TRANSFERINDEX;
    private static final long BASECOUNT;
    private static final long CELLSBUSY;
    private static final long CELLVALUE;
    private static final long ABASE;
    private static final int ASHIFT;
    private static final MethodHandle putObjectVolatileHandle;
    private static final MethodHandle getObjectVolatileHandle;
    private static final MethodHandle compareAndSwapObjectHandle;
    private static final MethodHandle compareAndSwapIntHandle;
    private static final MethodHandle compareAndSwapLongHandle;
    private static final MethodHandle getAndAddIntHandle;

    static int spread(int h2) {
        return (h2 ^ h2 >>> 16) & Integer.MAX_VALUE;
    }

    private static int tableSizeFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    static <V> Node<V> tabAt(Node<V>[] tab, int i) {
        try {
            Object o = getObjectVolatileHandle.invokeExact(tab, ((long)i << ASHIFT) + ABASE);
            return (Node)o;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static <V> boolean casTabAt(Node<V>[] tab, int i, Node<V> c, Node<V> v) {
        try {
            return compareAndSwapObjectHandle.invokeExact(tab, ((long)i << ASHIFT) + ABASE, c, v);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static <V> void setTabAt(Node<V>[] tab, int i, Node<V> v) {
        try {
            putObjectVolatileHandle.invokeExact(tab, ((long)i << ASHIFT) + ABASE, v);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    ConcurrentIntObjectHashMap() {
    }

    ConcurrentIntObjectHashMap(int initialCapacity) {
        int cap;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.sizeCtl = cap = initialCapacity >= 0x20000000 ? 0x40000000 : ConcurrentIntObjectHashMap.tableSizeFor(initialCapacity + (initialCapacity >>> 1) + 1);
    }

    ConcurrentIntObjectHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, 1);
    }

    ConcurrentIntObjectHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        long size;
        int cap;
        if (!(loadFactor > 0.0f) || initialCapacity < 0 || concurrencyLevel <= 0) {
            throw new IllegalArgumentException();
        }
        if (initialCapacity < concurrencyLevel) {
            initialCapacity = concurrencyLevel;
        }
        this.sizeCtl = cap = (size = (long)(1.0 + (double)((float)initialCapacity / loadFactor))) >= 0x40000000L ? 0x40000000 : ConcurrentIntObjectHashMap.tableSizeFor((int)size);
    }

    @Override
    public int size() {
        long n = this.sumCount();
        return n < 0L ? 0 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
    }

    @Override
    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    @Override
    public V get(int key) {
        Node<V> e;
        int n;
        int h2 = ConcurrentIntObjectHashMap.spread(key);
        Node<V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (e = ConcurrentIntObjectHashMap.tabAt(tab, n - 1 & h2)) != null) {
            int eh = e.hash;
            if (eh == h2) {
                if (e.key == key) {
                    return e.val;
                }
            } else if (eh < 0) {
                Node<V> p = e.find(h2, key);
                return p != null ? (V)p.val : null;
            }
            while ((e = e.next) != null) {
                if (e.hash != h2 || e.key != key) continue;
                return e.val;
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(int key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(@NotNull Object value) {
        if (value == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(0);
        }
        Node<V>[] t2 = this.table;
        if (this.table != null) {
            Node<V> p;
            Traverser<V> it = new Traverser<V>(t2, t2.length, 0, t2.length);
            while ((p = it.advance()) != null) {
                Object v = p.val;
                if (v != value && (v == null || !value.equals(v))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V put(int key, @NotNull V value) {
        if (value == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(1);
        }
        return this.putVal(key, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V putVal(int key, @NotNull V value, boolean onlyIfAbsent) {
        int binCount;
        block19: {
            V oldVal;
            int i;
            if (value == null) {
                ConcurrentIntObjectHashMap.$$$reportNull$$$0(2);
            }
            int hash = ConcurrentIntObjectHashMap.spread(key);
            binCount = 0;
            Node<V>[] tab = this.table;
            while (true) {
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i = n - 1 & hash;
                Node<V> f = ConcurrentIntObjectHashMap.tabAt(tab, i);
                if (f == null) {
                    if (!ConcurrentIntObjectHashMap.casTabAt(tab, i, null, new Node<V>(hash, key, value, null))) continue;
                    break block19;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                oldVal = null;
                Node<V> node = f;
                synchronized (node) {
                    block20: {
                        if (ConcurrentIntObjectHashMap.tabAt(tab, i) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<V> e = f;
                                while (true) {
                                    if (e.key == key) {
                                        oldVal = e.val;
                                        if (!onlyIfAbsent) {
                                            e.val = value;
                                        }
                                        break block20;
                                    }
                                    Node<V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        pred.next = new Node<V>(hash, key, value, null);
                                        break block20;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 2;
                                TreeNode<V> p = ((TreeBin)f).putTreeVal(hash, key, value);
                                if (p != null) {
                                    oldVal = p.val;
                                    if (!onlyIfAbsent) {
                                        p.val = value;
                                    }
                                }
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i);
            }
            if (oldVal != null) {
                return oldVal;
            }
        }
        this.addCount(1L, binCount);
        return null;
    }

    @Override
    public V remove(int key) {
        return this.replaceNode(key, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    V replaceNode(int key, V value, Object cv) {
        int i;
        Node<V> f;
        int n;
        int hash = ConcurrentIntObjectHashMap.spread(key);
        Node<V>[] tab = this.table;
        while (tab != null && (n = tab.length) != 0 && (f = ConcurrentIntObjectHashMap.tabAt(tab, i = n - 1 & hash)) != null) {
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            Object oldVal = null;
            boolean validated = false;
            Node<V> node = f;
            synchronized (node) {
                if (ConcurrentIntObjectHashMap.tabAt(tab, i) == f) {
                    if (fh >= 0) {
                        validated = true;
                        Node<V> e = f;
                        Node<V> pred = null;
                        do {
                            if (e.key == key) {
                                Object ev = e.val;
                                if (cv == null || cv == ev || ev != null && cv.equals(ev)) {
                                    oldVal = ev;
                                    if (value != null) {
                                        e.val = value;
                                    } else if (pred != null) {
                                        pred.next = e.next;
                                    } else {
                                        ConcurrentIntObjectHashMap.setTabAt(tab, i, e.next);
                                    }
                                }
                                break;
                            }
                            pred = e;
                        } while ((e = e.next) != null);
                    } else if (f instanceof TreeBin) {
                        TreeNode p;
                        validated = true;
                        TreeBin t2 = (TreeBin)f;
                        TreeNode r = t2.root;
                        if (r != null && (p = r.findTreeNode(hash, key)) != null) {
                            Object pv = p.val;
                            if (cv == null || cv == pv || pv != null && cv.equals(pv)) {
                                oldVal = pv;
                                if (value != null) {
                                    p.val = value;
                                } else if (t2.removeTreeNode(p)) {
                                    ConcurrentIntObjectHashMap.setTabAt(tab, i, ConcurrentIntObjectHashMap.untreeify(t2.first));
                                }
                            }
                        }
                    }
                }
            }
            if (!validated) continue;
            if (oldVal == null) break;
            if (value == null) {
                this.addCount(-1L, -1);
            }
            return (V)oldVal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        long delta = 0L;
        int i = 0;
        Node<V>[] tab = this.table;
        while (tab != null && i < tab.length) {
            Node<V> f = ConcurrentIntObjectHashMap.tabAt(tab, i);
            if (f == null) {
                ++i;
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                i = 0;
                continue;
            }
            Node<V> node = f;
            synchronized (node) {
                if (ConcurrentIntObjectHashMap.tabAt(tab, i) == f) {
                    Node<V> p;
                    Node<V> node2 = fh >= 0 ? f : (p = f instanceof TreeBin ? ((TreeBin)f).first : null);
                    while (p != null) {
                        --delta;
                        p = p.next;
                    }
                    ConcurrentIntObjectHashMap.setTabAt(tab, i++, null);
                }
            }
        }
        if (delta != 0L) {
            this.addCount(delta, -1);
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ValuesView<V> vs = this.values;
        ValuesView<V> valuesView = vs != null ? vs : (this.values = new ValuesView(this));
        if (valuesView == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(3);
        }
        return valuesView;
    }

    @Override
    @NotNull
    public Set<IntObjectMap.Entry<V>> entrySet() {
        EntrySetView<V> es = this.entrySet;
        EntrySetView<V> entrySetView = es != null ? es : (this.entrySet = new EntrySetView(this));
        if (entrySetView == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(4);
        }
        return entrySetView;
    }

    public int hashCode() {
        int h2 = 0;
        Node<V>[] t2 = this.table;
        if (this.table != null) {
            Node<V> p;
            Traverser<V> it = new Traverser<V>(t2, t2.length, 0, t2.length);
            while ((p = it.advance()) != null) {
                h2 += p.key ^ p.val.hashCode();
            }
        }
        return h2;
    }

    public String toString() {
        Node<V>[] t2 = this.table;
        int f = this.table == null ? 0 : t2.length;
        Traverser<V> it = new Traverser<V>(t2, f, 0, f);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Node<V> p = it.advance();
        if (p != null) {
            while (true) {
                int k = p.key;
                Object v = p.val;
                sb.append(k);
                sb.append('=');
                sb.append((Object)(v == this ? "(this Map)" : v));
                p = it.advance();
                if (p == null) break;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    public boolean equals(Object o) {
        if (o != this) {
            Node<V> p;
            if (!(o instanceof ConcurrentIntObjectMap)) {
                return false;
            }
            IntObjectMap m4 = (IntObjectMap)o;
            Node<V>[] t2 = this.table;
            int f = this.table == null ? 0 : t2.length;
            Traverser<V> it = new Traverser<V>(t2, f, 0, f);
            while ((p = it.advance()) != null) {
                Object val = p.val;
                Object v = m4.get(p.key);
                if (v != null && (v == val || v.equals(val))) continue;
                return false;
            }
            for (IntObjectMap.Entry e : m4.entrySet()) {
                V v;
                int mk = e.getKey();
                Object mv = e.getValue();
                if (mv != null && (v = this.get(mk)) != null && (mv == v || mv.equals(v))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public V putIfAbsent(int key, @NotNull V value) {
        if (value == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(5);
        }
        return this.putVal(key, value, true);
    }

    @Override
    public boolean remove(int key, @NotNull Object value) {
        if (value == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(6);
        }
        return this.replaceNode(key, null, value) != null;
    }

    @Override
    public boolean replace(int key, @NotNull V oldValue, @NotNull V newValue) {
        if (oldValue == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(7);
        }
        if (newValue == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(8);
        }
        return this.replaceNode(key, newValue, oldValue) != null;
    }

    public V replace(int key, @NotNull V value) {
        if (value == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(9);
        }
        return this.replaceNode(key, value, null);
    }

    public V getOrDefault(int key, V defaultValue) {
        V v = this.get(key);
        return v == null ? defaultValue : v;
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public int @NotNull [] keys() {
        Object[] entries2 = new EntrySetView(this).toArray();
        int[] result2 = new int[entries2.length];
        for (int i = 0; i < entries2.length; ++i) {
            IntObjectMap.Entry entry = (IntObjectMap.Entry)entries2[i];
            result2[i] = entry.getKey();
        }
        if (result2 == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(10);
        }
        return result2;
    }

    @Override
    @NotNull
    public Enumeration<V> elements() {
        Node<V>[] t2 = this.table;
        int f = this.table == null ? 0 : t2.length;
        return new ValueIterator<V>(t2, f, 0, f, this);
    }

    public long mappingCount() {
        long n = this.sumCount();
        return Math.max(n, 0L);
    }

    static int resizeStamp(int n) {
        return Integer.numberOfLeadingZeros(n) | 0x8000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<V>[] initTable() {
        Node<V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null && tab.length != 0) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (ConcurrentIntObjectHashMap.compareAndSwapInt(this, SIZECTL, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null || tab.length == 0) {
                    int n = sc > 0 ? sc : 16;
                    Node[] nt = new Node[n];
                    tab = nt;
                    this.table = nt;
                    sc = n - (n >>> 2);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    private void addCount(long x, int check2) {
        long s2;
        long b;
        CounterCell[] as = this.counterCells;
        if (this.counterCells != null || !ConcurrentIntObjectHashMap.compareAndSwapLong(this, BASECOUNT, b = this.baseCount, s2 = b + x)) {
            long v;
            CounterCell a;
            int m4;
            boolean uncontended = true;
            if (as == null || (m4 = as.length - 1) < 0 || (a = as[ThreadLocalRandom.getProbe() & m4]) == null || !(uncontended = ConcurrentIntObjectHashMap.compareAndSwapLong(a, CELLVALUE, v = a.value, v + x))) {
                this.fullAddCount(x, uncontended);
                return;
            }
            if (check2 <= 1) {
                return;
            }
            s2 = this.sumCount();
        }
        if (check2 >= 0) {
            int sc;
            while (s2 >= (long)(sc = this.sizeCtl)) {
                int n;
                Node<V>[] tab = this.table;
                if (this.table == null || (n = tab.length) >= 0x40000000) break;
                int rs = ConcurrentIntObjectHashMap.resizeStamp(n);
                if (sc < 0) {
                    if (sc >>> 16 != rs || sc == rs + 1 || sc == rs + 65535) break;
                    Node<V>[] nt = this.nextTable;
                    if (this.nextTable == null || this.transferIndex <= 0) break;
                    if (ConcurrentIntObjectHashMap.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (ConcurrentIntObjectHashMap.compareAndSwapInt(this, SIZECTL, sc, (rs << 16) + 2)) {
                    this.transfer(tab, null);
                }
                s2 = this.sumCount();
            }
        }
    }

    Node<V>[] helpTransfer(Node<V>[] tab, Node<V> f) {
        if (tab != null && f instanceof ForwardingNode) {
            Node<V>[] nextTab = ((ForwardingNode)f).nextTable;
            if (((ForwardingNode)f).nextTable != null) {
                int sc;
                int rs = ConcurrentIntObjectHashMap.resizeStamp(tab.length);
                while (nextTab == this.nextTable && this.table == tab && (sc = this.sizeCtl) < 0 && sc >>> 16 == rs && sc != rs + 1 && sc != rs + 65535 && this.transferIndex > 0) {
                    if (!ConcurrentIntObjectHashMap.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                    this.transfer(tab, nextTab);
                    break;
                }
                return nextTab;
            }
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryPresize(int size) {
        int sc;
        int c;
        int n = c = size >= 0x20000000 ? 0x40000000 : ConcurrentIntObjectHashMap.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl) >= 0) {
            int n2;
            Node<V>[] tab = this.table;
            if (tab == null || (n2 = tab.length) == 0) {
                n2 = Math.max(sc, c);
                if (!ConcurrentIntObjectHashMap.compareAndSwapInt(this, SIZECTL, sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    Node[] nt = new Node[n2];
                    this.table = nt;
                    sc = n2 - (n2 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = sc;
                    continue;
                }
            }
            if (c <= sc || n2 >= 0x40000000) break;
            if (tab != this.table) continue;
            int rs = ConcurrentIntObjectHashMap.resizeStamp(n2);
            if (sc < 0) {
                if (sc >>> 16 != rs || sc == rs + 1 || sc == rs + 65535) break;
                Node<V>[] nt = this.nextTable;
                if (this.nextTable == null || this.transferIndex <= 0) break;
                if (!ConcurrentIntObjectHashMap.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                this.transfer(tab, nt);
                continue;
            }
            if (!ConcurrentIntObjectHashMap.compareAndSwapInt(this, SIZECTL, sc, (rs << 16) + 2)) continue;
            this.transfer(tab, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(Node<V>[] tab, Node<V>[] nextTab) {
        int n = tab.length;
        int stride = NCPU > 1 ? (n >>> 3) / NCPU : n;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                Node[] nt = new Node[n << 1];
                nextTab = nt;
            }
            catch (Throwable ex) {
                this.sizeCtl = Integer.MAX_VALUE;
                return;
            }
            this.nextTable = nextTab;
            this.transferIndex = n;
        }
        int nextn = nextTab.length;
        ForwardingNode<V> fwd = new ForwardingNode<V>(nextTab);
        boolean advance = true;
        boolean finishing = false;
        int i = 0;
        int bound = 0;
        while (true) {
            if (advance) {
                if (--i >= bound || finishing) {
                    advance = false;
                    continue;
                }
                int nextIndex = this.transferIndex;
                if (nextIndex <= 0) {
                    i = -1;
                    advance = false;
                    continue;
                }
                int nextBound = nextIndex > stride ? nextIndex - stride : 0;
                if (!ConcurrentIntObjectHashMap.compareAndSwapInt(this, TRANSFERINDEX, nextIndex, nextBound)) continue;
                bound = nextBound;
                i = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i < 0 || i >= n || i + n >= nextn) {
                if (finishing) {
                    this.nextTable = null;
                    this.table = nextTab;
                    this.sizeCtl = (n << 1) - (n >>> 1);
                    return;
                }
                int sc = this.sizeCtl;
                if (!ConcurrentIntObjectHashMap.compareAndSwapInt(this, SIZECTL, sc, sc - 1)) continue;
                if (sc - 2 != ConcurrentIntObjectHashMap.resizeStamp(n) << 16) {
                    return;
                }
                advance = true;
                finishing = true;
                i = n;
                continue;
            }
            TreeBin f = ConcurrentIntObjectHashMap.tabAt(tab, i);
            if (f == null) {
                advance = ConcurrentIntObjectHashMap.casTabAt(tab, i, null, fwd);
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                advance = true;
                continue;
            }
            TreeBin treeBin = f;
            synchronized (treeBin) {
                if (ConcurrentIntObjectHashMap.tabAt(tab, i) == f) {
                    Node hn;
                    if (fh >= 0) {
                        Node ln;
                        int runBit = fh & n;
                        TreeBin lastRun = f;
                        Node p = f.next;
                        while (p != null) {
                            int b = p.hash & n;
                            if (b != runBit) {
                                runBit = b;
                                lastRun = p;
                            }
                            p = p.next;
                        }
                        if (runBit == 0) {
                            ln = lastRun;
                            hn = null;
                        } else {
                            hn = lastRun;
                            ln = null;
                        }
                        p = f;
                        while (p != lastRun) {
                            int ph = p.hash;
                            int pk = p.key;
                            Object pv = p.val;
                            if ((ph & n) == 0) {
                                ln = new Node(ph, pk, pv, ln);
                            } else {
                                hn = new Node(ph, pk, pv, hn);
                            }
                            p = p.next;
                        }
                        ConcurrentIntObjectHashMap.setTabAt(nextTab, i, ln);
                        ConcurrentIntObjectHashMap.setTabAt(nextTab, i + n, hn);
                        ConcurrentIntObjectHashMap.setTabAt(tab, i, fwd);
                        advance = true;
                    } else if (f instanceof TreeBin) {
                        TreeBin ln;
                        TreeBin t2 = f;
                        TreeNode lo = null;
                        TreeNode loTail = null;
                        TreeNode hi = null;
                        TreeNode hiTail = null;
                        int lc = 0;
                        int hc = 0;
                        Node e = t2.first;
                        while (e != null) {
                            int h2 = e.hash;
                            TreeNode p = new TreeNode(h2, e.key, e.val, null, null);
                            if ((h2 & n) == 0) {
                                p.prev = loTail;
                                if (p.prev == null) {
                                    lo = p;
                                } else {
                                    loTail.next = p;
                                }
                                loTail = p;
                                ++lc;
                            } else {
                                p.prev = hiTail;
                                if (p.prev == null) {
                                    hi = p;
                                } else {
                                    hiTail.next = p;
                                }
                                hiTail = p;
                                ++hc;
                            }
                            e = e.next;
                        }
                        TreeBin treeBin2 = lc <= 6 ? ConcurrentIntObjectHashMap.untreeify(lo) : (ln = hc != 0 ? new TreeBin(lo) : t2);
                        hn = hc <= 6 ? ConcurrentIntObjectHashMap.untreeify(hi) : (lc != 0 ? new TreeBin(hi) : t2);
                        ConcurrentIntObjectHashMap.setTabAt(nextTab, i, ln);
                        ConcurrentIntObjectHashMap.setTabAt(nextTab, i + n, hn);
                        ConcurrentIntObjectHashMap.setTabAt(tab, i, fwd);
                        advance = true;
                    }
                }
            }
        }
    }

    long sumCount() {
        CounterCell[] as = this.counterCells;
        long sum = this.baseCount;
        if (as != null) {
            for (int i = 0; i < as.length; ++i) {
                CounterCell a = as[i];
                if (a == null) continue;
                sum += a.value;
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fullAddCount(long x, boolean wasUncontended) {
        int h2 = ThreadLocalRandom.getProbe();
        if (h2 == 0) {
            ThreadLocalRandom.localInit();
            h2 = ThreadLocalRandom.getProbe();
            wasUncontended = true;
        }
        boolean collide = false;
        while (true) {
            long v;
            int n;
            CounterCell[] as = this.counterCells;
            if (this.counterCells != null && (n = as.length) > 0) {
                CounterCell a = as[n - 1 & h2];
                if (a == null) {
                    if (this.cellsBusy == 0) {
                        CounterCell r = new CounterCell(x);
                        if (this.cellsBusy == 0 && ConcurrentIntObjectHashMap.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                            boolean created = false;
                            try {
                                int j;
                                int m4;
                                CounterCell[] rs = this.counterCells;
                                if (this.counterCells != null && (m4 = rs.length) > 0 && rs[j = m4 - 1 & h2] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = a.value;
                    if (ConcurrentIntObjectHashMap.compareAndSwapLong(a, CELLVALUE, v, v + x)) return;
                    if (this.counterCells != as || n >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && ConcurrentIntObjectHashMap.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                        try {
                            if (this.counterCells == as) {
                                CounterCell[] rs = new CounterCell[n << 1];
                                for (int i = 0; i < n; ++i) {
                                    rs[i] = as[i];
                                }
                                this.counterCells = rs;
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h2 = ThreadLocalRandom.advanceProbe(h2);
                continue;
            }
            if (this.cellsBusy == 0 && this.counterCells == as && ConcurrentIntObjectHashMap.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                boolean init = false;
                try {
                    if (this.counterCells == as) {
                        CounterCell[] rs = new CounterCell[2];
                        rs[h2 & 1] = new CounterCell(x);
                        this.counterCells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init) continue;
                return;
            }
            v = this.baseCount;
            if (ConcurrentIntObjectHashMap.compareAndSwapLong(this, BASECOUNT, v, v + x)) return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void treeifyBin(Node<V>[] tab, int index) {
        if (tab != null) {
            int n = tab.length;
            if (n < 64) {
                this.tryPresize(n << 1);
            } else {
                Node<V> b = ConcurrentIntObjectHashMap.tabAt(tab, index);
                if (b != null && b.hash >= 0) {
                    Node<V> node = b;
                    synchronized (node) {
                        if (ConcurrentIntObjectHashMap.tabAt(tab, index) == b) {
                            TreeNode hd = null;
                            TreeNode tl = null;
                            Node<V> e = b;
                            while (e != null) {
                                TreeNode p = new TreeNode(e.hash, e.key, e.val, null, null);
                                p.prev = tl;
                                if (p.prev == null) {
                                    hd = p;
                                } else {
                                    tl.next = p;
                                }
                                tl = p;
                                e = e.next;
                            }
                            ConcurrentIntObjectHashMap.setTabAt(tab, index, new TreeBin(hd));
                        }
                    }
                }
            }
        }
    }

    static <V> Node<V> untreeify(Node<V> b) {
        Node hd = null;
        Node tl = null;
        Node<V> q = b;
        while (q != null) {
            Node p = new Node(q.hash, q.key, q.val, null);
            if (tl == null) {
                hd = p;
            } else {
                tl.next = p;
            }
            tl = p;
            q = q.next;
        }
        return hd;
    }

    private static boolean compareAndSwapInt(Object object, long offset, int expected, int value) {
        try {
            return compareAndSwapIntHandle.invokeExact(object, offset, expected, value);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static boolean compareAndSwapLong(Object object, long offset, long expected, long value) {
        try {
            return compareAndSwapLongHandle.invokeExact(object, offset, expected, value);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Override
    @NotNull
    public V cacheOrGet(int key, @NotNull V defaultValue) {
        V v;
        if (defaultValue == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(11);
        }
        if ((v = this.get(key)) != null) {
            V v2 = v;
            if (v2 == null) {
                ConcurrentIntObjectHashMap.$$$reportNull$$$0(12);
            }
            return v2;
        }
        V prev = this.putIfAbsent(key, defaultValue);
        V v3 = prev == null ? defaultValue : prev;
        if (v3 == null) {
            ConcurrentIntObjectHashMap.$$$reportNull$$$0(13);
        }
        return v3;
    }

    static {
        try {
            MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
            Object unsafe = ReflectionUtil.getUnsafe();
            MethodHandle objectFieldOffset = publicLookup.findVirtual(unsafe.getClass(), "objectFieldOffset", MethodType.methodType(Long.TYPE, Field.class));
            Class<ConcurrentIntObjectHashMap> k = ConcurrentIntObjectHashMap.class;
            SIZECTL = objectFieldOffset.invoke(unsafe, k.getDeclaredField("sizeCtl"));
            TRANSFERINDEX = objectFieldOffset.invoke(unsafe, k.getDeclaredField("transferIndex"));
            BASECOUNT = objectFieldOffset.invoke(unsafe, k.getDeclaredField("baseCount"));
            CELLSBUSY = objectFieldOffset.invoke(unsafe, k.getDeclaredField("cellsBusy"));
            Class<CounterCell> ck = CounterCell.class;
            CELLVALUE = objectFieldOffset.invoke(unsafe, ck.getDeclaredField("value"));
            Class<Node[]> ak = Node[].class;
            ABASE = publicLookup.findVirtual(unsafe.getClass(), "arrayBaseOffset", MethodType.methodType(Integer.TYPE, Class.class)).invoke(unsafe, ak);
            int scale = publicLookup.findVirtual(unsafe.getClass(), "arrayIndexScale", MethodType.methodType(Integer.TYPE, Class.class)).invoke(unsafe, ak);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
            putObjectVolatileHandle = publicLookup.findVirtual(unsafe.getClass(), "putObjectVolatile", MethodType.methodType(Void.TYPE, Object.class, Long.TYPE, Object.class)).bindTo(unsafe);
            getObjectVolatileHandle = publicLookup.findVirtual(unsafe.getClass(), "getObjectVolatile", MethodType.methodType(Object.class, Object.class, Long.TYPE)).bindTo(unsafe);
            compareAndSwapObjectHandle = publicLookup.findVirtual(unsafe.getClass(), "compareAndSwapObject", MethodType.methodType(Boolean.TYPE, Object.class, Long.TYPE, Object.class, Object.class)).bindTo(unsafe);
            compareAndSwapIntHandle = publicLookup.findVirtual(unsafe.getClass(), "compareAndSwapInt", MethodType.methodType(Boolean.TYPE, Object.class, Long.TYPE, Integer.TYPE, Integer.TYPE)).bindTo(unsafe);
            compareAndSwapLongHandle = publicLookup.findVirtual(unsafe.getClass(), "compareAndSwapLong", MethodType.methodType(Boolean.TYPE, Object.class, Long.TYPE, Long.TYPE, Long.TYPE)).bindTo(unsafe);
            getAndAddIntHandle = publicLookup.findVirtual(unsafe.getClass(), "getAndAddInt", MethodType.methodType(Integer.TYPE, Object.class, Long.TYPE, Integer.TYPE)).bindTo(unsafe);
        }
        catch (Throwable t2) {
            throw new Error(t2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentIntObjectHashMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentIntObjectHashMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheOrGet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putVal";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "cacheOrGet";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class EntrySetView<V>
    extends CollectionView<V, IntObjectMap.Entry<V>>
    implements Set<IntObjectMap.Entry<V>> {
        EntrySetView(ConcurrentIntObjectHashMap<V> map2) {
            super(map2);
        }

        @Override
        public boolean contains(Object o) {
            Object v;
            IntObjectMap.Entry e;
            Object r;
            return o instanceof IntObjectMap.Entry && (r = this.map.get((e = (IntObjectMap.Entry)o).getKey())) != null && (v = e.getValue()) != null && (v == r || v.equals(r));
        }

        @Override
        public boolean remove(Object o) {
            Object v;
            IntObjectMap.Entry e;
            return o instanceof Map.Entry && (e = (IntObjectMap.Entry)o) != null && (v = e.getValue()) != null && this.map.remove(e.getKey(), v);
        }

        @Override
        @NotNull
        public Iterator<IntObjectMap.Entry<V>> iterator() {
            ConcurrentIntObjectHashMap m4 = this.map;
            Node<V>[] t2 = m4.table;
            int f = m4.table == null ? 0 : t2.length;
            return new EntryIterator(t2, f, 0, f, m4);
        }

        @Override
        public boolean add(IntObjectMap.Entry<V> e) {
            return this.map.putVal(e.getKey(), e.getValue(), false) == null;
        }

        @Override
        public boolean addAll(Collection<? extends IntObjectMap.Entry<V>> c) {
            boolean added = false;
            for (IntObjectMap.Entry<V> e : c) {
                if (!this.add(e)) continue;
                added = true;
            }
            return added;
        }

        @Override
        public int hashCode() {
            int h2 = 0;
            Node<V>[] t2 = this.map.table;
            if (this.map.table != null) {
                Node p;
                Traverser it = new Traverser(t2, t2.length, 0, t2.length);
                while ((p = it.advance()) != null) {
                    h2 += p.hashCode();
                }
            }
            return h2;
        }

        @Override
        public boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }
    }

    static final class ValuesView<V>
    extends CollectionView<V, V>
    implements Collection<V> {
        ValuesView(ConcurrentIntObjectHashMap<V> map2) {
            super(map2);
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            if (o != null) {
                Iterator<V> it = this.iterator();
                while (it.hasNext()) {
                    if (!o.equals(it.next())) continue;
                    it.remove();
                    return true;
                }
            }
            return false;
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            ConcurrentIntObjectHashMap m4 = this.map;
            Node<V>[] t2 = m4.table;
            int f = m4.table == null ? 0 : t2.length;
            return new ValueIterator(t2, f, 0, f, m4);
        }

        @Override
        public boolean add(V e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends V> c) {
            if (c == null) {
                ValuesView.$$$reportNull$$$0(0);
            }
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/util/containers/ConcurrentIntObjectHashMap$ValuesView", "addAll"));
        }
    }

    static abstract class CollectionView<V, E>
    implements Collection<E> {
        final ConcurrentIntObjectHashMap<V> map;
        private static final String oomeMsg = "Required array size too large";

        CollectionView(ConcurrentIntObjectHashMap<V> map2) {
            this.map = map2;
        }

        public ConcurrentIntObjectHashMap<V> getMap() {
            return this.map;
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        @NotNull
        public abstract Iterator<E> iterator();

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public final Object @NotNull [] toArray() {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int n = (int)sz;
            Object[] r = new Object[n];
            int i = 0;
            for (E e : this) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = e;
            }
            Object[] objectArray = i == n ? r : Arrays.copyOf(r, i);
            if (objectArray == null) {
                CollectionView.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        @Override
        public final <T> T @NotNull [] toArray(T @NotNull [] a) {
            long sz;
            if (a == null) {
                CollectionView.$$$reportNull$$$0(1);
            }
            if ((sz = this.map.mappingCount()) > 0x7FFFFFF7L) {
                throw new OutOfMemoryError(oomeMsg);
            }
            int m4 = (int)sz;
            T[] r = a.length >= m4 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), m4);
            int n = r.length;
            int i = 0;
            for (E e : this) {
                if (i == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError(oomeMsg);
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i++] = e;
            }
            if (a == r && i < n) {
                r[i] = null;
                if (r == null) {
                    CollectionView.$$$reportNull$$$0(2);
                }
                return r;
            }
            T[] TArray = i == n ? r : Arrays.copyOf(r, i);
            if (TArray == null) {
                CollectionView.$$$reportNull$$$0(3);
            }
            return TArray;
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<E> it = this.iterator();
            if (it.hasNext()) {
                while (true) {
                    E e;
                    sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }

        @Override
        public final boolean containsAll(@NotNull Collection<?> c) {
            if (c == null) {
                CollectionView.$$$reportNull$$$0(4);
            }
            if (c != this) {
                for (Object e : c) {
                    if (e != null && this.contains(e)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public final boolean removeAll(@NotNull Collection<?> c) {
            if (c == null) {
                CollectionView.$$$reportNull$$$0(5);
            }
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public final boolean retainAll(@NotNull Collection<?> c) {
            if (c == null) {
                CollectionView.$$$reportNull$$$0(6);
            }
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ConcurrentIntObjectHashMap$CollectionView";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ConcurrentIntObjectHashMap$CollectionView";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "containsAll";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAll";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "retainAll";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class EntryIterator<V>
    extends BaseIterator<V>
    implements Iterator<IntObjectMap.Entry<V>> {
        EntryIterator(Node<V>[] tab, int index, int size, int limit, ConcurrentIntObjectHashMap<V> map2) {
            super(tab, index, size, limit, map2);
        }

        @Override
        public IntObjectMap.Entry<V> next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            int k = p.key;
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return new SimpleEntry(k, v);
        }
    }

    static final class ValueIterator<V>
    extends BaseIterator<V>
    implements Iterator<V>,
    Enumeration<V> {
        ValueIterator(Node<V>[] tab, int index, int size, int limit, ConcurrentIntObjectHashMap<V> map2) {
            super(tab, index, size, limit, map2);
        }

        @Override
        public V next() {
            Node p = this.next;
            if (p == null) {
                throw new NoSuchElementException();
            }
            Object v = p.val;
            this.lastReturned = p;
            this.advance();
            return v;
        }

        @Override
        public V nextElement() {
            return this.next();
        }
    }

    static class BaseIterator<V>
    extends Traverser<V> {
        final ConcurrentIntObjectHashMap<V> map;
        Node<V> lastReturned;

        BaseIterator(Node<V>[] tab, int size, int index, int limit, ConcurrentIntObjectHashMap<V> map2) {
            super(tab, size, index, limit);
            this.map = map2;
            this.advance();
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final boolean hasMoreElements() {
            return this.next != null;
        }

        public final void remove() {
            Node<V> p = this.lastReturned;
            if (p == null) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            this.map.replaceNode(p.key, null, p.val);
        }
    }

    static class Traverser<V> {
        Node<V>[] tab;
        Node<V> next;
        TableStack<V> stack;
        TableStack<V> spare;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;

        Traverser(Node<V>[] tab, int size, int index, int limit) {
            this.tab = tab;
            this.baseSize = size;
            this.baseIndex = this.index = index;
            this.baseLimit = limit;
            this.next = null;
        }

        final Node<V> advance() {
            Node<V> e = this.next;
            if (e != null) {
                e = e.next;
            }
            while (true) {
                int i;
                int n;
                Node<V>[] t2;
                block10: {
                    block9: {
                        if (e != null) {
                            this.next = e;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        t2 = this.tab;
                        if (this.tab != null && (n = t2.length) > (i = this.index) && i >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                e = ConcurrentIntObjectHashMap.tabAt(t2, i);
                if (e != null && e.hash < 0) {
                    if (e instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)e).nextTable;
                        e = null;
                        this.pushState(t2, i, n);
                        continue;
                    }
                    e = e instanceof TreeBin ? ((TreeBin)e).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n);
                    continue;
                }
                this.index = i + this.baseSize;
                if (this.index < n) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<V>[] t2, int i, int n) {
            TableStack<V> s2 = this.spare;
            if (s2 != null) {
                this.spare = s2.next;
            } else {
                s2 = new TableStack();
            }
            s2.tab = t2;
            s2.length = n;
            s2.index = i;
            s2.next = this.stack;
            this.stack = s2;
        }

        private void recoverState(int n) {
            int len;
            TableStack<V> s2;
            while ((s2 = this.stack) != null && (this.index += (len = s2.length)) >= n) {
                n = len;
                this.index = s2.index;
                this.tab = s2.tab;
                s2.tab = null;
                TableStack next = s2.next;
                s2.next = this.spare;
                this.stack = next;
                this.spare = s2;
            }
            if (s2 == null && (this.index += this.baseSize) >= n) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static final class TableStack<V> {
        int length;
        int index;
        Node<V>[] tab;
        TableStack<V> next;

        TableStack() {
        }
    }

    static final class TreeBin<V>
    extends Node<V> {
        TreeNode<V> root;
        volatile TreeNode<V> first;
        volatile Thread waiter;
        volatile int lockState;
        static final int WRITER = 1;
        static final int WAITER = 2;
        static final int READER = 4;
        private static final long LOCKSTATE;

        TreeBin(TreeNode<V> b) {
            super(-2, 0, null, null);
            this.first = b;
            TreeNode r = null;
            TreeNode x = b;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (r == null) {
                    x.parent = null;
                    x.red = false;
                    r = x;
                } else {
                    TreeNode xp;
                    int dir2;
                    int h2 = x.hash;
                    TreeNode p = r;
                    do {
                        int ph;
                        dir2 = (ph = p.hash) > h2 ? -1 : (ph < h2 ? 1 : 0);
                        xp = p;
                    } while ((p = dir2 <= 0 ? p.left : p.right) != null);
                    x.parent = xp;
                    if (dir2 <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    r = TreeBin.balanceInsertion(r, x);
                }
                x = next;
            }
            this.root = r;
            assert (TreeBin.checkInvariants(this.root));
        }

        private void lockRoot() {
            if (!ConcurrentIntObjectHashMap.compareAndSwapInt(this, TreeBin.LOCKSTATE, 0, 1)) {
                this.contendedLock();
            }
        }

        private void unlockRoot() {
            this.lockState = 0;
        }

        private void contendedLock() {
            boolean waiting = false;
            while (true) {
                int s2;
                if (((s2 = this.lockState) & 0xFFFFFFFD) == 0) {
                    if (!ConcurrentIntObjectHashMap.compareAndSwapInt(this, TreeBin.LOCKSTATE, s2, 1)) continue;
                    if (waiting) {
                        this.waiter = null;
                    }
                    return;
                }
                if ((s2 & 2) == 0) {
                    if (!ConcurrentIntObjectHashMap.compareAndSwapInt(this, TreeBin.LOCKSTATE, s2, s2 | 2)) continue;
                    waiting = true;
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (!waiting) continue;
                LockSupport.park(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Node<V> find(int h2, int k) {
            Node e = this.first;
            while (e != null) {
                TreeNode<V> p;
                int s2 = this.lockState;
                if ((s2 & 3) != 0) {
                    if (e.key == k) {
                        return e;
                    }
                    e = e.next;
                    continue;
                }
                if (!ConcurrentIntObjectHashMap.compareAndSwapInt(this, TreeBin.LOCKSTATE, s2, s2 + 4)) continue;
                try {
                    TreeNode<V> r = this.root;
                    p = r == null ? null : r.findTreeNode(h2, k);
                }
                finally {
                    Thread w;
                    if (TreeBin.getAndAddInt(this, LOCKSTATE, -4) == 6 && (w = this.waiter) != null) {
                        LockSupport.unpark(w);
                    }
                }
                return p;
            }
            return null;
        }

        private static int getAndAddInt(Object object, long offset, int v) {
            try {
                return getAndAddIntHandle.invokeExact(object, offset, v);
            }
            catch (Throwable t2) {
                throw new RuntimeException(t2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TreeNode<V> putTreeVal(int h2, int k, V v) {
            block18: {
                TreeNode<V> xp;
                int dir2;
                boolean searched = false;
                TreeNode<V> p = this.root;
                do {
                    if (p == null) {
                        this.root = new TreeNode<V>(h2, k, v, null, null);
                        this.first = this.root;
                        break block18;
                    }
                    int ph = p.hash;
                    if (ph > h2) {
                        dir2 = -1;
                    } else if (ph < h2) {
                        dir2 = 1;
                    } else {
                        if (p.key == k) {
                            return p;
                        }
                        if (!searched) {
                            TreeNode q;
                            searched = true;
                            TreeNode ch = p.left;
                            if (ch != null && (q = ch.findTreeNode(h2, k)) != null || (ch = p.right) != null && (q = ch.findTreeNode(h2, k)) != null) {
                                return q;
                            }
                        }
                        dir2 = 0;
                    }
                    xp = p;
                } while ((p = dir2 <= 0 ? p.left : p.right) != null);
                TreeNode<V> f = this.first;
                TreeNode<V> x = new TreeNode<V>(h2, k, v, f, xp);
                this.first = x;
                if (f != null) {
                    f.prev = x;
                }
                if (dir2 <= 0) {
                    xp.left = x;
                } else {
                    xp.right = x;
                }
                if (!xp.red) {
                    x.red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, x);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean removeTreeNode(TreeNode<V> p) {
            TreeNode rl;
            TreeNode next = (TreeNode)p.next;
            TreeNode pred = p.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode<V> r = this.root;
            if (r == null || r.right == null || (rl = r.left) == null || rl.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode pp;
                TreeNode replacement;
                TreeNode pl = p.left;
                TreeNode pr = p.right;
                if (pl != null && pr != null) {
                    TreeNode sl;
                    TreeNode s2 = pr;
                    while ((sl = s2.left) != null) {
                        s2 = sl;
                    }
                    boolean c = s2.red;
                    s2.red = p.red;
                    p.red = c;
                    TreeNode sr = s2.right;
                    TreeNode pp2 = p.parent;
                    if (s2 == pr) {
                        p.parent = s2;
                        s2.right = p;
                    } else {
                        TreeNode sp = s2.parent;
                        p.parent = sp;
                        if (p.parent != null) {
                            if (s2 == sp.left) {
                                sp.left = p;
                            } else {
                                sp.right = p;
                            }
                        }
                        if ((s2.right = pr) != null) {
                            pr.parent = s2;
                        }
                    }
                    p.left = null;
                    p.right = sr;
                    if (p.right != null) {
                        sr.parent = p;
                    }
                    if ((s2.left = pl) != null) {
                        pl.parent = s2;
                    }
                    if ((s2.parent = pp2) == null) {
                        r = s2;
                    } else if (p == pp2.left) {
                        pp2.left = s2;
                    } else {
                        pp2.right = s2;
                    }
                    replacement = sr != null ? sr : p;
                } else {
                    replacement = pl != null ? pl : (pr != null ? pr : p);
                }
                if (replacement != p) {
                    replacement.parent = p.parent;
                    pp = replacement.parent;
                    if (pp == null) {
                        r = replacement;
                    } else if (p == pp.left) {
                        pp.left = replacement;
                    } else {
                        pp.right = replacement;
                    }
                    p.parent = null;
                    p.right = null;
                    p.left = null;
                }
                TreeNode<V> treeNode = this.root = p.red ? r : TreeBin.balanceDeletion(r, replacement);
                if (p == replacement && (pp = p.parent) != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                    p.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            assert (TreeBin.checkInvariants(this.root));
            return false;
        }

        static <V> TreeNode<V> rotateLeft(TreeNode<V> root, TreeNode<V> p) {
            TreeNode r;
            if (p != null && (r = p.right) != null) {
                p.right = r.left;
                TreeNode rl = p.right;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode pp = r.parent = p.parent;
                if (r.parent == null) {
                    root = r;
                    r.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
            return root;
        }

        static <V> TreeNode<V> rotateRight(TreeNode<V> root, TreeNode<V> p) {
            TreeNode l;
            if (p != null && (l = p.left) != null) {
                p.left = l.right;
                TreeNode lr = p.left;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode pp = l.parent = p.parent;
                if (l.parent == null) {
                    root = l;
                    l.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
            return root;
        }

        static <V> TreeNode<V> balanceInsertion(TreeNode<V> root, TreeNode<V> x) {
            x.red = true;
            while (true) {
                TreeNode xpp;
                TreeNode xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeBin.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeBin.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeBin.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeBin.rotateLeft(root, xpp);
            }
        }

        static <V> TreeNode<V> balanceDeletion(TreeNode<V> root, TreeNode<V> x) {
            while (x != null && x != root) {
                TreeNode sr;
                TreeNode sl;
                TreeNode xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root;
                }
                TreeNode xpl = xp.left;
                if (xpl == x) {
                    TreeNode xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeBin.rotateLeft(root, xp);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeBin.rotateRight(root, xpr);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeBin.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeBin.rotateRight(root, xp);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeBin.rotateLeft(root, xpl);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeBin.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        static <V> boolean checkInvariants(TreeNode<V> t2) {
            TreeNode tp = t2.parent;
            TreeNode tl = t2.left;
            TreeNode tr = t2.right;
            TreeNode tb = t2.prev;
            TreeNode tn = (TreeNode)t2.next;
            if (tb != null && tb.next != t2) {
                return false;
            }
            if (tn != null && tn.prev != t2) {
                return false;
            }
            if (tp != null && t2 != tp.left && t2 != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t2 || tl.hash > t2.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t2 || tr.hash < t2.hash)) {
                return false;
            }
            if (t2.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeBin.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeBin.checkInvariants(tr);
        }

        static {
            try {
                Object unsafe = ReflectionUtil.getUnsafe();
                MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
                MethodHandle objectFieldOffset = publicLookup.findVirtual(unsafe.getClass(), "objectFieldOffset", MethodType.methodType(Long.TYPE, Field.class));
                Class<TreeBin> k = TreeBin.class;
                LOCKSTATE = objectFieldOffset.invoke(unsafe, k.getDeclaredField("lockState"));
            }
            catch (Throwable t2) {
                throw new Error(t2);
            }
        }
    }

    static final class TreeNode<V>
    extends Node<V> {
        TreeNode<V> parent;
        TreeNode<V> left;
        TreeNode<V> right;
        TreeNode<V> prev;
        boolean red;

        TreeNode(int hash, int key, V val, Node<V> next, TreeNode<V> parent) {
            super(hash, key, val, next);
            this.parent = parent;
        }

        @Override
        Node<V> find(int h2, int k) {
            return this.findTreeNode(h2, k);
        }

        TreeNode<V> findTreeNode(int h2, int k) {
            TreeNode<V> p = this;
            do {
                TreeNode<V> pl = p.left;
                TreeNode<V> pr = p.right;
                int ph = p.hash;
                if (ph > h2) {
                    p = pl;
                    continue;
                }
                if (ph < h2) {
                    p = pr;
                    continue;
                }
                if (p.key == k) {
                    return p;
                }
                if (pl == null) {
                    p = pr;
                    continue;
                }
                if (pr == null) {
                    p = pl;
                    continue;
                }
                TreeNode<V> q = pr.findTreeNode(h2, k);
                if (q != null) {
                    return q;
                }
                p = pl;
            } while (p != null);
            return null;
        }
    }

    static final class ForwardingNode<V>
    extends Node<V> {
        final Node<V>[] nextTable;

        ForwardingNode(Node<V>[] tab) {
            super(-1, 0, null, null);
            this.nextTable = tab;
        }

        @Override
        Node<V> find(int h2, int k) {
            Node<V>[] tab = this.nextTable;
            block0: while (true) {
                Node<V> e;
                int n;
                if (tab == null || (n = tab.length) == 0 || (e = ConcurrentIntObjectHashMap.tabAt(tab, n - 1 & h2)) == null) {
                    return null;
                }
                do {
                    if (e.key == k) {
                        return e;
                    }
                    if (e.hash >= 0) continue;
                    if (e instanceof ForwardingNode) {
                        tab = ((ForwardingNode)e).nextTable;
                        continue block0;
                    }
                    return e.find(h2, k);
                } while ((e = e.next) != null);
                break;
            }
            return null;
        }
    }

    static final class CounterCell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;

        CounterCell(long x) {
            this.value = x;
        }
    }

    static class Node<V>
    implements IntObjectMap.Entry<V> {
        final int hash;
        final int key;
        volatile V val;
        volatile Node<V> next;

        Node(int hash, int key, V val, Node<V> next) {
            this.hash = hash;
            this.key = key;
            this.val = val;
            this.next = next;
        }

        @Override
        public final int getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public final V getValue() {
            V v = this.val;
            if (v == null) {
                Node.$$$reportNull$$$0(0);
            }
            return v;
        }

        public final int hashCode() {
            return this.key ^ this.val.hashCode();
        }

        public final String toString() {
            return this.key + "=" + this.val;
        }

        public final boolean equals(Object o) {
            V u;
            Object v;
            IntObjectMap.Entry e;
            return o instanceof IntObjectMap.Entry && (e = (IntObjectMap.Entry)o).getKey() == this.key && (v = e.getValue()) != null && (v == (u = this.val) || v.equals(u));
        }

        Node<V> find(int h2, int k) {
            Node<V> e = this;
            do {
                if (e.key != k) continue;
                return e;
            } while ((e = e.next) != null);
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentIntObjectHashMap$Node", "getValue"));
        }
    }
}

