/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.SafeStAXStreamBuilder;
import com.intellij.openapi.util.StaxFactory;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;
import org.jdom.Attribute;
import org.jdom.CloneBase;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.JDOMInterner;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.Filter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JDOMUtil {
    @NonNls
    private static final String X = "x";
    @NonNls
    private static final String Y = "y";
    @NonNls
    private static final String WIDTH = "width";
    @NonNls
    private static final String HEIGHT = "height";
    public static final Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace("xi", "http://www.w3.org/2001/XInclude");
    public static final Pattern CHILDREN_PATTERN = Pattern.compile("/([^/]*)(/[^/]*)?/\\*");
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();

    private JDOMUtil() {
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent) {
        List<Object> list = parent == null ? Collections.emptyList() : parent.getChildren();
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent, @NotNull String name) {
        if (name == null) {
            JDOMUtil.$$$reportNull$$$0(1);
        }
        if (parent != null) {
            List<Element> list = parent.getChildren(name);
            if (list == null) {
                JDOMUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<Element> list = Collections.emptyList();
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static Logger getLogger() {
        return LoggerHolder.LOG;
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2) {
        return JDOMUtil.areElementsEqual(e1, e2, false);
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Objects.equals(e1.getName(), e2.getName()) && JDOMUtil.isAttributesEqual(JDOMUtil.getAttributes(e1), JDOMUtil.getAttributes(e2), ignoreEmptyAttrValues) && JDOMUtil.areElementContentsEqual(e1, e2, ignoreEmptyAttrValues);
    }

    public static int hashCode(@Nullable Element e, boolean ignoreEmptyAttrValues) {
        if (e == null) {
            return 0;
        }
        int hashCode2 = e.getName().hashCode();
        for (Attribute attribute : JDOMUtil.getAttributes(e)) {
            String value = attribute.getValue();
            if (ignoreEmptyAttrValues && (value == null || value.isEmpty())) continue;
            hashCode2 = hashCode2 * 31 * 31 + attribute.getName().hashCode() * 31 + value.hashCode();
        }
        for (Content content : e.getContent(CONTENT_FILTER)) {
            int contentHash = content instanceof Element ? JDOMUtil.hashCode((Element)content, ignoreEmptyAttrValues) : e.getValue().hashCode();
            hashCode2 = hashCode2 * 31 + contentHash;
        }
        return hashCode2;
    }

    public static boolean areElementContentsEqual(@NotNull Element e1, @NotNull Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null) {
            JDOMUtil.$$$reportNull$$$0(4);
        }
        if (e2 == null) {
            JDOMUtil.$$$reportNull$$$0(5);
        }
        return JDOMUtil.contentListsEqual(e1.getContent(CONTENT_FILTER), e2.getContent(CONTENT_FILTER), ignoreEmptyAttrValues);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static Element @NotNull [] getElements(@NotNull Element m4) {
        if (m4 == null) {
            JDOMUtil.$$$reportNull$$$0(6);
        }
        List<Element> list = m4.getChildren();
        Element[] elementArray = list.toArray(new Element[0]);
        if (elementArray == null) {
            JDOMUtil.$$$reportNull$$$0(7);
        }
        return elementArray;
    }

    @NotNull
    public static String legalizeText(@NotNull String str) {
        if (str == null) {
            JDOMUtil.$$$reportNull$$$0(8);
        }
        String string2 = JDOMUtil.legalizeChars(str).toString();
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    public static CharSequence legalizeChars(@NotNull CharSequence str) {
        if (str == null) {
            JDOMUtil.$$$reportNull$$$0(10);
        }
        StringBuilder result2 = new StringBuilder(str.length());
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            JDOMUtil.appendLegalized(result2, str.charAt(i));
        }
        StringBuilder stringBuilder = result2;
        if (stringBuilder == null) {
            JDOMUtil.$$$reportNull$$$0(11);
        }
        return stringBuilder;
    }

    private static void appendLegalized(@NotNull @NonNls StringBuilder sb, char each) {
        if (sb == null) {
            JDOMUtil.$$$reportNull$$$0(12);
        }
        if (each == '<' || each == '>') {
            sb.append(each == '<' ? "&lt;" : "&gt;");
        } else if (!Verifier.isXMLCharacter(each)) {
            sb.append("0x").append(Strings.toUpperCase(Long.toHexString(each)));
        } else {
            sb.append(each);
        }
    }

    private static boolean contentListsEqual(List<Content> c1, List<Content> c2, boolean ignoreEmptyAttrValues) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        ListIterator<Content> l1 = c1.listIterator();
        ListIterator<Content> l2 = c2.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next(), ignoreEmptyAttrValues)) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2, boolean ignoreEmptyAttrValues) {
        if (!(c1 instanceof Element) && !(c2 instanceof Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof Element && c2 instanceof Element && JDOMUtil.areElementsEqual((Element)c1, (Element)c2, ignoreEmptyAttrValues);
    }

    private static boolean isAttributesEqual(@NotNull List<? extends Attribute> l1, @NotNull List<? extends Attribute> l2, boolean ignoreEmptyAttrValues) {
        if (l1 == null) {
            JDOMUtil.$$$reportNull$$$0(13);
        }
        if (l2 == null) {
            JDOMUtil.$$$reportNull$$$0(14);
        }
        if (ignoreEmptyAttrValues) {
            l1 = JDOMUtil.getNotEmptyAttributes(l1);
            l2 = JDOMUtil.getNotEmptyAttributes(l2);
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (JDOMUtil.attributesEqual(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<? extends Attribute> getNotEmptyAttributes(@NotNull List<? extends Attribute> list) {
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(15);
        }
        if (list.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                JDOMUtil.$$$reportNull$$$0(16);
            }
            return list2;
        }
        ArrayList<Attribute> result2 = null;
        for (Attribute attribute : list) {
            String s2 = attribute.getValue();
            if (s2 == null || s2.isEmpty()) continue;
            if (result2 == null) {
                result2 = new ArrayList<Attribute>(list.size());
            }
            result2.add(attribute);
        }
        List<Object> list3 = result2 == null ? Collections.emptyList() : result2;
        if (list3 == null) {
            JDOMUtil.$$$reportNull$$$0(17);
        }
        return list3;
    }

    private static boolean attributesEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        if (a1 == null) {
            JDOMUtil.$$$reportNull$$$0(18);
        }
        if (a2 == null) {
            JDOMUtil.$$$reportNull$$$0(19);
        }
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static Document loadDocumentUsingStaX(@NotNull Reader reader) throws JDOMException, IOException {
        if (reader == null) {
            JDOMUtil.$$$reportNull$$$0(20);
        }
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(reader);
        Document document2 = SafeStAXStreamBuilder.buildDocument(xmlStreamReader);
        xmlStreamReader.close();
        Document document3 = document2;
        if (document3 == null) {
            JDOMUtil.$$$reportNull$$$0(21);
        }
        return document3;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static Element loadUsingStaX(@NotNull InputStream stream, @Nullable SafeJdomFactory factory) throws JDOMException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(22);
        }
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(stream);
        Element element = SafeStAXStreamBuilder.build(xmlStreamReader, true, true, factory == null ? SafeStAXStreamBuilder.FACTORY : factory);
        xmlStreamReader.close();
        Element element2 = element;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(23);
        }
        return element2;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
        }
    }

    @NotNull
    public static Element load(@NotNull CharSequence seq) throws IOException, JDOMException {
        if (seq == null) {
            JDOMUtil.$$$reportNull$$$0(24);
        }
        Element element = JDOMUtil.load(new CharSequenceReader(seq));
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(25);
        }
        return element;
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull Reader reader) throws IOException, JDOMException {
        if (reader == null) {
            JDOMUtil.$$$reportNull$$$0(26);
        }
        return JDOMUtil.loadDocumentUsingStaX(reader);
    }

    @NotNull
    public static Document loadDocument(@NotNull File file2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(27);
        }
        return JDOMUtil.loadDocumentUsingStaX(new InputStreamReader(CharsetToolkit.inputStreamSkippingBOM(new BufferedInputStream(new FileInputStream(file2))), StandardCharsets.UTF_8));
    }

    @NotNull
    public static Element load(@NotNull File file2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(28);
        }
        return JDOMUtil.loadUsingStaX(new FileInputStream(file2), null);
    }

    @NotNull
    public static Element load(@NotNull Path file2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(29);
        }
        try {
            return JDOMUtil.loadUsingStaX(Files.newInputStream(file2, new OpenOption[0]), null);
        }
        catch (ClosedFileSystemException e) {
            throw new IOException("Cannot read file from closed file system: " + file2, e);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull File file2, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(30);
        }
        return JDOMUtil.loadUsingStaX(new FileInputStream(file2), factory);
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull Path file2, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(31);
        }
        try {
            return JDOMUtil.loadUsingStaX(Files.newInputStream(file2, new OpenOption[0]), factory);
        }
        catch (ClosedFileSystemException e) {
            throw new IOException("Cannot read file from closed file system: " + file2, e);
        }
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(32);
        }
        return JDOMUtil.loadDocumentUsingStaX(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(Reader reader) throws JDOMException, IOException {
        Element element;
        if (reader == null) {
            return null;
        }
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(reader);
        try {
            element = SafeStAXStreamBuilder.build(xmlStreamReader, true, true, SafeStAXStreamBuilder.FACTORY);
        }
        catch (Throwable throwable) {
            try {
                xmlStreamReader.close();
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new JDOMException(e.getMessage(), e);
            }
        }
        xmlStreamReader.close();
        return element;
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.loadUsingStaX(stream, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull InputStream stream, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(33);
        }
        return JDOMUtil.loadUsingStaX(stream, factory);
    }

    @NotNull
    public static Element load(@NotNull Class<?> clazz, @NotNull String resource) throws JDOMException, IOException {
        InputStream stream;
        if (clazz == null) {
            JDOMUtil.$$$reportNull$$$0(34);
        }
        if (resource == null) {
            JDOMUtil.$$$reportNull$$$0(35);
        }
        if ((stream = clazz.getResourceAsStream(resource)) == null) {
            throw new FileNotFoundException(resource);
        }
        Element element = JDOMUtil.load(stream);
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(36);
        }
        return element;
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(37);
        }
        return JDOMUtil.loadDocument(URLUtil.openStream(url));
    }

    @NotNull
    public static Element load(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(38);
        }
        Element element = JDOMUtil.load(URLUtil.openStream(url));
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(39);
        }
        return element;
    }

    @NotNull
    public static Element loadResource(@NotNull URL url) throws JDOMException, IOException {
        if (url == null) {
            JDOMUtil.$$$reportNull$$$0(40);
        }
        Element element = JDOMUtil.load(URLUtil.openResourceStream(url));
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(41);
        }
        return element;
    }

    public static void writeDocument(@NotNull Document document2, @NotNull String filePath, String lineSeparator) throws IOException {
        if (document2 == null) {
            JDOMUtil.$$$reportNull$$$0(42);
        }
        if (filePath == null) {
            JDOMUtil.$$$reportNull$$$0(43);
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath));){
            JDOMUtil.writeDocument(document2, stream, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document2, @NotNull File file2, String lineSeparator) throws IOException {
        if (document2 == null) {
            JDOMUtil.$$$reportNull$$$0(44);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(45);
        }
        JDOMUtil.write((Parent)document2, file2, lineSeparator);
    }

    @Deprecated
    public static void write(@NotNull Element element, @NotNull File file2) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(46);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(47);
        }
        FileUtilRt.createParentDirs(file2);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), StandardCharsets.UTF_8));){
            JDOMUtil.writeElement(element, (Writer)writer, JDOMUtil.createOutputter("\n"));
        }
    }

    public static void write(@NotNull Element element, @NotNull Path file2) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(48);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(49);
        }
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file2, new OpenOption[0]);){
            JDOMUtil.writeElement(element, (Writer)writer, JDOMUtil.createOutputter("\n"));
        }
    }

    public static void write(@NotNull Parent element, @NotNull File file2) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(50);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(51);
        }
        JDOMUtil.write(element, file2, "\n");
    }

    public static void write(@NotNull Parent element, @NotNull File file2, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(52);
        }
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(53);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(54);
        }
        FileUtilRt.createParentDirs(file2);
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file2));){
            JDOMUtil.write(element, stream, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document2, @NotNull OutputStream stream, String lineSeparator) throws IOException {
        if (document2 == null) {
            JDOMUtil.$$$reportNull$$$0(55);
        }
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(56);
        }
        JDOMUtil.write((Parent)document2, stream, lineSeparator);
    }

    public static void write(@NotNull Parent element, @NotNull OutputStream stream, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(57);
        }
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(58);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(59);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            if (element instanceof Document) {
                JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
            } else {
                JDOMUtil.writeElement((Element)element, (Writer)writer, lineSeparator);
            }
        }
    }

    @NotNull
    public static String writeDocument(@NotNull Document document2, String lineSeparator) {
        String string2;
        if (document2 == null) {
            JDOMUtil.$$$reportNull$$$0(60);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document2, writer, lineSeparator);
            string2 = writer.toString();
        }
        catch (IOException ignored) {
            return "";
        }
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(61);
        }
        return string2;
    }

    @NotNull
    public static String write(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(62);
        }
        return JDOMUtil.writeElement(element);
    }

    @NotNull
    public static String write(@NotNull Parent element, String lineSeparator) {
        String string2;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(63);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.write(element, writer, lineSeparator);
            string2 = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(64);
        }
        return string2;
    }

    public static void write(Parent element, Writer writer, String lineSeparator) throws IOException {
        if (element instanceof Element) {
            JDOMUtil.writeElement((Element)element, writer, lineSeparator);
        } else if (element instanceof Document) {
            JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
        }
    }

    public static void writeElement(@NotNull Element element, Writer writer, String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(65);
        }
        JDOMUtil.writeElement(element, writer, JDOMUtil.createOutputter(lineSeparator));
    }

    public static void writeElement(@NotNull Element element, @NotNull Writer writer, @NotNull XMLOutputter xmlOutputter) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(66);
        }
        if (writer == null) {
            JDOMUtil.$$$reportNull$$$0(67);
        }
        if (xmlOutputter == null) {
            JDOMUtil.$$$reportNull$$$0(68);
        }
        try {
            xmlOutputter.output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(69);
        }
        return JDOMUtil.writeElement(element, "\n");
    }

    @NotNull
    public static String writeElement(@NotNull Element element, String lineSeparator) {
        String string2;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(70);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeElement(element, (Writer)writer, lineSeparator);
            string2 = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(71);
        }
        return string2;
    }

    @NotNull
    public static String writeChildren(@NotNull Element element, @NotNull String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(72);
        }
        if (lineSeparator == null) {
            JDOMUtil.$$$reportNull$$$0(73);
        }
        StringWriter writer = new StringWriter();
        for (Element child : element.getChildren()) {
            JDOMUtil.writeElement(child, (Writer)writer, lineSeparator);
            writer.append(lineSeparator);
        }
        String string2 = writer.toString();
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(74);
        }
        return string2;
    }

    public static void writeDocument(@NotNull Document document2, @NotNull Writer writer, String lineSeparator) throws IOException {
        if (document2 == null) {
            JDOMUtil.$$$reportNull$$$0(75);
        }
        if (writer == null) {
            JDOMUtil.$$$reportNull$$$0(76);
        }
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document2, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(document2.getRootElement(), "");
        }
    }

    @NotNull
    public static Format createFormat(@Nullable String lineSeparator) {
        Format format2 = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
        if (format2 == null) {
            JDOMUtil.$$$reportNull$$$0(77);
        }
        return format2;
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        return new MyXMLOutputter(JDOMUtil.createFormat(lineSeparator));
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeText(@NotNull String text) {
        if (text == null) {
            JDOMUtil.$$$reportNull$$$0(78);
        }
        return JDOMUtil.escapeText(text, false, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text == null) {
            JDOMUtil.$$$reportNull$$$0(79);
        }
        return JDOMUtil.escapeText(text, false, escapeSpaces, escapeLineEnds);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text == null) {
            JDOMUtil.$$$reportNull$$$0(80);
        }
        StringBuilder buffer = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            buffer = XmlStringUtil.appendEscapedSymbol(text, buffer, i, quotation, ch);
        }
        String string2 = buffer == null ? text : buffer.toString();
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(81);
        }
        return string2;
    }

    private static void printDiagnostics(@NotNull Element element, String prefix) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(82);
        }
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        for (Element child : element.getChildren()) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(83);
        }
        boolean hasNullAttributes = false;
        StringBuilder buf = new StringBuilder(element.getName());
        List<Attribute> attributes = JDOMUtil.getAttributes(element);
        int length = attributes.size();
        if (length > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                hasNullAttributes = true;
            }
            buf.append("]");
        }
        return new ElementInfo(buf, hasNullAttributes);
    }

    public static void updateFileSet(File @NotNull [] oldFiles, String @NotNull [] newFilePaths, Document @NotNull [] newFileDocuments, String lineSeparator) throws IOException {
        if (oldFiles == null) {
            JDOMUtil.$$$reportNull$$$0(84);
        }
        if (newFilePaths == null) {
            JDOMUtil.$$$reportNull$$$0(85);
        }
        if (newFileDocuments == null) {
            JDOMUtil.$$$reportNull$$$0(86);
        }
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        for (String newFilePath : newFilePaths) {
            File file2 = new File(newFilePath);
            if (!file2.exists() || file2.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file3 : oldFiles) {
            if (!file3.exists() || file3.canWrite()) continue;
            throw new IOException("File \"" + file3.getAbsolutePath() + "\" is not writeable");
        }
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (int i = 0; i < newFilePaths.length; ++i) {
            String newFilePath = newFilePaths[i];
            JDOMUtil.writeDocument(newFileDocuments[i], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result2 = oldFile.delete();
            if (result2) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || !element.hasAttributes() && element.getContent().isEmpty();
    }

    public static boolean isEmpty(@Nullable Element element, int attributeCount) {
        return element == null || JDOMUtil.getAttributes(element).size() == attributeCount && element.getContent().isEmpty();
    }

    @NotNull
    public static List<Attribute> getAttributes(@NotNull Element e) {
        if (e == null) {
            JDOMUtil.$$$reportNull$$$0(87);
        }
        List<Attribute> list = e.hasAttributes() ? e.getAttributes() : Collections.emptyList();
        if (list == null) {
            JDOMUtil.$$$reportNull$$$0(88);
        }
        return list;
    }

    @Contract(value="_, !null -> !null; !null, _ -> !null")
    @Nullable
    public static Element merge(@Nullable Element to, @Nullable Element from) {
        if (from == null) {
            return to;
        }
        if (to == null) {
            return from;
        }
        Iterator<CloneBase> iterator2 = from.getChildren().iterator();
        while (iterator2.hasNext()) {
            Element configuration = iterator2.next();
            iterator2.remove();
            to.addContent(configuration);
        }
        iterator2 = JDOMUtil.getAttributes(from).iterator();
        while (iterator2.hasNext()) {
            Attribute attribute = (Attribute)iterator2.next();
            iterator2.remove();
            to.setAttribute(attribute);
        }
        return to;
    }

    @NotNull
    public static Element deepMerge(@NotNull Element to, @NotNull Element from) {
        if (to == null) {
            JDOMUtil.$$$reportNull$$$0(89);
        }
        if (from == null) {
            JDOMUtil.$$$reportNull$$$0(90);
        }
        Iterator<CloneBase> iterator2 = from.getChildren().iterator();
        while (iterator2.hasNext()) {
            Element child = iterator2.next();
            iterator2.remove();
            Element existingChild = to.getChild(child.getName());
            if (existingChild != null && JDOMUtil.isEmpty(existingChild)) {
                to.removeChild(child.getName());
                existingChild = null;
            }
            if (existingChild == null || existingChild.getChildren().isEmpty() || !JDOMUtil.isAttributesEqual(JDOMUtil.getAttributes(existingChild), JDOMUtil.getAttributes(child), false)) {
                to.addContent(child);
                continue;
            }
            JDOMUtil.deepMerge(existingChild, child);
        }
        iterator2 = JDOMUtil.getAttributes(from).iterator();
        while (iterator2.hasNext()) {
            Attribute attribute = (Attribute)iterator2.next();
            iterator2.remove();
            to.setAttribute(attribute);
        }
        Element element = to;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(91);
        }
        return element;
    }

    @Nullable
    public static Element reduceChildren(@NotNull String name, @NotNull Element parent) {
        List<Element> children2;
        Iterator<Element> it;
        if (name == null) {
            JDOMUtil.$$$reportNull$$$0(92);
        }
        if (parent == null) {
            JDOMUtil.$$$reportNull$$$0(93);
        }
        if (!(it = (children2 = parent.getChildren(name)).iterator()).hasNext()) {
            return null;
        }
        Element accumulator = it.next();
        while (it.hasNext()) {
            JDOMUtil.merge(accumulator, it.next());
            it.remove();
        }
        return accumulator;
    }

    @NotNull
    public static Element internElement(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(94);
        }
        Element element2 = JDOMInterner.INSTANCE.internElement(element);
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(95);
        }
        return element2;
    }

    @NotNull
    public static String removeControlChars(@NotNull String text) {
        if (text == null) {
            JDOMUtil.$$$reportNull$$$0(96);
        }
        StringBuilder result2 = null;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Verifier.isXMLCharacter(c)) {
                if (result2 != null) continue;
                result2 = new StringBuilder(text.length());
                result2.append(text, 0, i);
                continue;
            }
            if (result2 == null) continue;
            result2.append(c);
        }
        String string2 = result2 == null ? text : result2.toString();
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(97);
        }
        return string2;
    }

    @Nullable
    public static Point getLocation(@Nullable Element element) {
        return element == null ? null : JDOMUtil.getLocation(element, X, Y);
    }

    @Nullable
    public static Point getLocation(@NotNull Element element, @NotNull String x, @NotNull String y) {
        String sX;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(98);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(99);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(100);
        }
        if ((sX = element.getAttributeValue(x)) == null) {
            return null;
        }
        String sY = element.getAttributeValue(y);
        if (sY == null) {
            return null;
        }
        try {
            return new Point(Integer.parseInt(sX), Integer.parseInt(sY));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setLocation(@NotNull Element element, @NotNull Point location) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(101);
        }
        if (location == null) {
            JDOMUtil.$$$reportNull$$$0(102);
        }
        return JDOMUtil.setLocation(element, X, Y, location);
    }

    @NotNull
    public static Element setLocation(@NotNull Element element, @NotNull String x, @NotNull String y, @NotNull Point location) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(103);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(104);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(105);
        }
        if (location == null) {
            JDOMUtil.$$$reportNull$$$0(106);
        }
        Element element2 = element.setAttribute(x, Integer.toString(location.x)).setAttribute(y, Integer.toString(location.y));
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(107);
        }
        return element2;
    }

    @Nullable
    public static Dimension getSize(@Nullable Element element) {
        return element == null ? null : JDOMUtil.getSize(element, WIDTH, HEIGHT);
    }

    @Nullable
    public static Dimension getSize(@NotNull Element element, @NotNull String width, @NotNull String height) {
        String sWidth;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(108);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(109);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(110);
        }
        if ((sWidth = element.getAttributeValue(width)) == null) {
            return null;
        }
        String sHeight = element.getAttributeValue(height);
        if (sHeight == null) {
            return null;
        }
        try {
            int iWidth = Integer.parseInt(sWidth);
            if (iWidth <= 0) {
                return null;
            }
            int iHeight = Integer.parseInt(sHeight);
            if (iHeight <= 0) {
                return null;
            }
            return new Dimension(iWidth, iHeight);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setSize(@NotNull Element element, @NotNull Dimension size) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(111);
        }
        if (size == null) {
            JDOMUtil.$$$reportNull$$$0(112);
        }
        return JDOMUtil.setSize(element, WIDTH, HEIGHT, size);
    }

    @NotNull
    public static Element setSize(@NotNull Element element, @NotNull String width, @NotNull String height, @NotNull Dimension size) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(113);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(114);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(115);
        }
        if (size == null) {
            JDOMUtil.$$$reportNull$$$0(116);
        }
        Element element2 = element.setAttribute(width, Integer.toString(size.width)).setAttribute(height, Integer.toString(size.height));
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(117);
        }
        return element2;
    }

    @Nullable
    public static Rectangle getBounds(@Nullable Element element) {
        return element == null ? null : JDOMUtil.getBounds(element, X, Y, WIDTH, HEIGHT);
    }

    @Nullable
    public static Rectangle getBounds(@NotNull Element element, @NotNull String x, @NotNull String y, @NotNull String width, @NotNull String height) {
        String sX;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(118);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(119);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(120);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(121);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(122);
        }
        if ((sX = element.getAttributeValue(x)) == null) {
            return null;
        }
        String sY = element.getAttributeValue(y);
        if (sY == null) {
            return null;
        }
        String sWidth = element.getAttributeValue(width);
        if (sWidth == null) {
            return null;
        }
        String sHeight = element.getAttributeValue(height);
        if (sHeight == null) {
            return null;
        }
        try {
            int iWidth = Integer.parseInt(sWidth);
            if (iWidth <= 0) {
                return null;
            }
            int iHeight = Integer.parseInt(sHeight);
            if (iHeight <= 0) {
                return null;
            }
            return new Rectangle(Integer.parseInt(sX), Integer.parseInt(sY), iWidth, iHeight);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setBounds(@NotNull Element element, @NotNull Rectangle bounds) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(123);
        }
        if (bounds == null) {
            JDOMUtil.$$$reportNull$$$0(124);
        }
        return JDOMUtil.setBounds(element, X, Y, WIDTH, HEIGHT, bounds);
    }

    @NotNull
    public static Element setBounds(@NotNull Element element, @NotNull String x, @NotNull String y, @NotNull String width, @NotNull String height, @NotNull Rectangle bounds) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(125);
        }
        if (x == null) {
            JDOMUtil.$$$reportNull$$$0(126);
        }
        if (y == null) {
            JDOMUtil.$$$reportNull$$$0(127);
        }
        if (width == null) {
            JDOMUtil.$$$reportNull$$$0(128);
        }
        if (height == null) {
            JDOMUtil.$$$reportNull$$$0(129);
        }
        if (bounds == null) {
            JDOMUtil.$$$reportNull$$$0(130);
        }
        Element element2 = element.setAttribute(x, Integer.toString(bounds.x)).setAttribute(y, Integer.toString(bounds.y)).setAttribute(width, Integer.toString(bounds.width)).setAttribute(height, Integer.toString(bounds.height));
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(131);
        }
        return element2;
    }

    public static void copyMissingContent(@NotNull Element source2, @NotNull Element target) {
        if (source2 == null) {
            JDOMUtil.$$$reportNull$$$0(132);
        }
        if (target == null) {
            JDOMUtil.$$$reportNull$$$0(133);
        }
        Element targetClone = target.clone();
        for (Attribute attribute : source2.getAttributes()) {
            if (JDOMUtil.hasAttribute(targetClone, attribute.getName())) continue;
            target.setAttribute(attribute.clone());
        }
        for (Content content : source2.getContent()) {
            if (JDOMUtil.hasContent(targetClone, content)) continue;
            target.addContent(content.clone());
        }
    }

    private static boolean hasAttribute(@NotNull Element element, @NotNull String name) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(134);
        }
        if (name == null) {
            JDOMUtil.$$$reportNull$$$0(135);
        }
        return element.getAttribute(name) != null;
    }

    private static boolean hasContent(@NotNull Element element, @NotNull Content content) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(136);
        }
        if (content == null) {
            JDOMUtil.$$$reportNull$$$0(137);
        }
        if (content instanceof Element) {
            return !element.getChildren(((Element)content).getName()).isEmpty();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 1: 
            case 92: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l2";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 22: 
            case 32: 
            case 33: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 37: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 42: 
            case 44: 
            case 55: 
            case 60: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 57: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 69: 
            case 70: 
            case 72: 
            case 82: 
            case 83: 
            case 94: 
            case 98: 
            case 101: 
            case 103: 
            case 108: 
            case 111: 
            case 113: 
            case 118: 
            case 123: 
            case 125: 
            case 134: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 54: 
            case 59: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 67: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlOutputter";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFiles";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilePaths";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileDocuments";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 99: 
            case 104: 
            case 119: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = X;
                break;
            }
            case 100: 
            case 105: 
            case 120: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = Y;
                break;
            }
            case 102: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 109: 
            case 114: 
            case 121: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = WIDTH;
                break;
            }
            case 110: 
            case 115: 
            case 122: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = HEIGHT;
                break;
            }
            case 112: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 124: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeChars";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotEmptyAttributes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDocumentUsingStaX";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUsingStaX";
                break;
            }
            case 25: 
            case 36: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "loadResource";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "writeDocument";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "writeElement";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChildren";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormat";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeText";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "deepMerge";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "internElement";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "removeControlChars";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocation";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "setSize";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "setBounds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areElementContentsEqual";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "legalizeText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "legalizeChars";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendLegalized";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAttributesEqual";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNotEmptyAttributes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "attributesEqual";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadDocumentUsingStaX";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadUsingStaX";
                break;
            }
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 26: 
            case 27: 
            case 32: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "loadDocument";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "loadResource";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 55: 
            case 56: 
            case 60: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "writeDocument";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "writeElement";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "writeChildren";
                break;
            }
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "printDiagnostics";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "updateFileSet";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "deepMerge";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "reduceChildren";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "internElement";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "removeControlChars";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "setSize";
                break;
            }
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getBounds";
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "setBounds";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "copyMissingContent";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "hasContent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ElementInfo {
        @NotNull
        final CharSequence name;
        final boolean hasNullAttributes;

        private ElementInfo(@NotNull CharSequence name, boolean attributes) {
            if (name == null) {
                ElementInfo.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.hasNullAttributes = attributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/util/JDOMUtil$ElementInfo", "<init>"));
        }
    }

    public static interface ElementOutputFilter {
        public boolean accept(@NotNull Element var1, int var2);
    }

    private static final class MyXMLOutputter
    extends XMLOutputter {
        MyXMLOutputter(@NotNull Format format2) {
            if (format2 == null) {
                MyXMLOutputter.$$$reportNull$$$0(0);
            }
            super(format2);
        }

        @Override
        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(1);
            }
            String string2 = JDOMUtil.escapeText(str, false, true);
            if (string2 == null) {
                MyXMLOutputter.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Override
        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(3);
            }
            String string2 = JDOMUtil.escapeText(str, false, false);
            if (string2 == null) {
                MyXMLOutputter.$$$reportNull$$$0(4);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeAttributeEntities";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeElementEntities";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeAttributeEntities";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeElementEntities";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class EmptyTextFilter
    implements Filter<Content> {
        private EmptyTextFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }

    private static final class LoggerHolder {
        private static final Logger LOG = Logger.getInstance(JDOMUtil.class);

        private LoggerHolder() {
        }
    }
}

