/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.highlighting;

import com.intellij.openapi.diff.ex.DiffFragment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class List2D {
    private final List<List<DiffFragment>> myRows = new ArrayList<List<DiffFragment>>();
    private List<DiffFragment> myCurrentRow = null;

    List2D() {
    }

    public void add(DiffFragment element) {
        this.ensureRowExists();
        this.myCurrentRow.add(element);
    }

    private void ensureRowExists() {
        if (this.myCurrentRow == null) {
            this.myCurrentRow = new ArrayList<DiffFragment>();
            this.myRows.add(this.myCurrentRow);
        }
    }

    public void newRow() {
        this.myCurrentRow = null;
    }

    public DiffFragment[][] toArray() {
        DiffFragment[][] result2 = new DiffFragment[this.myRows.size()][];
        for (int i = 0; i < result2.length; ++i) {
            List<DiffFragment> row = this.myRows.get(i);
            result2[i] = new DiffFragment[row.size()];
            System.arraycopy(row.toArray(), 0, result2[i], 0, row.size());
        }
        return result2;
    }

    public void addAll(DiffFragment[] line) {
        this.ensureRowExists();
        Collections.addAll(this.myCurrentRow, line);
    }
}

