/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.version;

import com.jetbrains.plugin.structure.intellij.utils.StringUtil;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B%\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00020\u0005\"\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0011\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0001H\u0096\u0002J\u0013\u0010\u0010\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugin/structure/intellij/version/IdeVersionImpl;", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "productCode", "", "components", "", "", "isSnapshot", "", "(Ljava/lang/String;[IZ)V", "myComponents", "asString", "includeProductCode", "includeSnapshotMarker", "compareTo", "other", "equals", "", "getBaselineVersion", "getBuild", "getComponents", "getProductCode", "hashCode", "toString", "Companion", "structure-intellij_main"})
public final class IdeVersionImpl
extends IdeVersion {
    private final int[] myComponents;
    private final String productCode;
    private final boolean isSnapshot;
    private static final String BUILD_NUMBER = "__BUILD_NUMBER__";
    private static final String STAR = "*";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String FALLBACK_VERSION = "999.SNAPSHOT";
    private static final int SNAPSHOT_VALUE = Integer.MAX_VALUE;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(@NotNull IdeVersion other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        if (!(other instanceof IdeVersionImpl)) {
            if (this.getBaselineVersion() != other.getBaselineVersion()) {
                return this.getBaselineVersion() - other.getBaselineVersion();
            }
            if (this.getBuild() != other.getBuild()) {
                return this.getBuild() - other.getBuild();
            }
            if (this.isSnapshot != other.isSnapshot()) {
                return this.isSnapshot ? 1 : -1;
            }
            return 0;
        }
        int n = 0;
        int[] c1 = this.myComponents;
        int[] c2 = ((IdeVersionImpl)other).myComponents;
        int n2 = Math.min(c1.length, c2.length) - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (c1[i] == c2[i] && c1[i] == IdeVersionImpl.Companion.getSNAPSHOT_VALUE()) {
                    return 0;
                }
                if (c1[i] == IdeVersionImpl.Companion.getSNAPSHOT_VALUE()) {
                    return 1;
                }
                if (c2[i] == IdeVersionImpl.Companion.getSNAPSHOT_VALUE()) {
                    return -1;
                }
                int result = c1[i] - c2[i];
                if (result != 0) {
                    return result;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return c1.length - c2.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String asString(boolean includeProductCode, boolean includeSnapshotMarker) {
        StringBuilder builder = new StringBuilder();
        if (includeProductCode && !StringUtil.isEmpty(this.productCode)) {
            builder.append(this.productCode).append('-');
        }
        builder.append(this.myComponents[0]);
        int n = 1;
        int n2 = this.myComponents.length - 1;
        if (n <= n2) {
            while (true) {
                void i;
                if (this.myComponents[i] != IdeVersionImpl.Companion.getSNAPSHOT_VALUE()) {
                    builder.append('.').append(this.myComponents[i]);
                } else if (includeSnapshotMarker) {
                    builder.append('.').append(this.isSnapshot ? IdeVersionImpl.Companion.getSNAPSHOT() : IdeVersionImpl.Companion.getSTAR());
                }
                if (i == n2) break;
                ++i;
            }
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    @Override
    @NotNull
    public int[] getComponents() {
        return (int[])this.myComponents.clone();
    }

    @Override
    public int getBaselineVersion() {
        return this.myComponents[0];
    }

    @Override
    @NotNull
    public String getProductCode() {
        return this.productCode;
    }

    @NotNull
    public String toString() {
        String string = this.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"asString()");
        return string;
    }

    @Override
    public int getBuild() {
        return this.myComponents[1];
    }

    @Override
    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        IdeVersionImpl that = (IdeVersionImpl)other;
        return Intrinsics.areEqual((Object)this.productCode, (Object)that.productCode) && this.isSnapshot == that.isSnapshot && Arrays.equals(this.myComponents, that.myComponents);
    }

    public int hashCode() {
        int result = this.productCode.hashCode();
        result = 31 * result + Arrays.hashCode(this.myComponents);
        result = 31 * result + (this.isSnapshot ? 1 : 0);
        return result;
    }

    private IdeVersionImpl(String productCode, int[] components, boolean isSnapshot) {
        this.productCode = productCode;
        this.isSnapshot = isSnapshot;
        this.myComponents = components;
    }

    /* synthetic */ IdeVersionImpl(String string, int[] nArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(string, nArray, bl);
    }

    static {
        BUILD_NUMBER = BUILD_NUMBER;
        STAR = STAR;
        SNAPSHOT = SNAPSHOT;
        FALLBACK_VERSION = FALLBACK_VERSION;
        SNAPSHOT_VALUE = Integer.MAX_VALUE;
    }

    public /* synthetic */ IdeVersionImpl(@NotNull String productCode, @NotNull int[] components, boolean isSnapshot, DefaultConstructorMarker $constructor_marker) {
        this(productCode, components, isSnapshot);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/plugin/structure/intellij/version/IdeVersionImpl$Companion;", "", "()V", "BUILD_NUMBER", "", "getBUILD_NUMBER", "()Ljava/lang/String;", "FALLBACK_VERSION", "getFALLBACK_VERSION", "SNAPSHOT", "getSNAPSHOT", "SNAPSHOT_VALUE", "", "getSNAPSHOT_VALUE", "()I", "STAR", "getSTAR", "fromString", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersionImpl;", "version", "getBaseLineForHistoricBuilds", "bn", "parseBuildNumber", "code", "structure-intellij_main"})
    public static final class Companion {
        private final String getBUILD_NUMBER() {
            return BUILD_NUMBER;
        }

        private final String getSTAR() {
            return STAR;
        }

        private final String getSNAPSHOT() {
            return SNAPSHOT;
        }

        private final String getFALLBACK_VERSION() {
            return FALLBACK_VERSION;
        }

        private final int getSNAPSHOT_VALUE() {
            return SNAPSHOT_VALUE;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IdeVersionImpl fromString(@NotNull String version) throws IllegalArgumentException {
            String productCode;
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            if (StringsKt.isBlank((CharSequence)version)) {
                throw (Throwable)new IllegalArgumentException("Ide-version string must not be empty");
            }
            if (Intrinsics.areEqual((Object)this.getBUILD_NUMBER(), (Object)version) || Intrinsics.areEqual((Object)this.getSNAPSHOT(), (Object)version)) {
                IdeVersionImpl fallback = this.fromString(this.getFALLBACK_VERSION());
                int[] nArray = fallback.myComponents;
                int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
                boolean bl = true;
                return new IdeVersionImpl("", nArray2, bl, null);
            }
            String code = version;
            int productSeparator = StringsKt.lastIndexOf$default((CharSequence)code, (char)'-', (int)0, (boolean)false, (int)6, null);
            if (productSeparator > 0) {
                String string = code;
                int n = 0;
                String string2 = string.substring(n, productSeparator);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                productCode = string2;
                string = code;
                n = productSeparator + 1;
                String string3 = string.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                code = string3;
            } else {
                productCode = "";
            }
            int baselineVersionSeparator = StringsKt.indexOf$default((CharSequence)code, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (baselineVersionSeparator > 0) {
                String string = code;
                int n = 0;
                String string4 = string;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, baselineVersionSeparator);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String baselineVersionString = string5;
                CharSequence $receiver$iv = baselineVersionString;
                CharSequence $receiver$iv$iv = $receiver$iv;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
                boolean startFound$iv$iv22 = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int bl = !startFound$iv$iv22 ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $receiver$iv$iv.charAt(bl);
                    boolean bl2 = match$iv$iv = it <= ' ';
                    if (!startFound$iv$iv22) {
                        if (!match$iv$iv) {
                            startFound$iv$iv22 = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (($receiver$iv = (CharSequence)((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0) {
                    throw (Throwable)new IllegalArgumentException("Invalid version number: " + version);
                }
                List components = StringsKt.split$default((CharSequence)code, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
                ArrayList<Integer> intComponentsList = new ArrayList<Integer>();
                boolean isSnapshot = false;
                for (String component : components) {
                    int n2 = this.parseBuildNumber(version, component);
                    intComponentsList.add(n2);
                    if (n2 != this.getSNAPSHOT_VALUE()) continue;
                    if (!Intrinsics.areEqual((Object)component, (Object)this.getSNAPSHOT())) break;
                    isSnapshot = true;
                    break;
                }
                if (intComponentsList.size() < 2) {
                    throw (Throwable)new IllegalArgumentException("Invalid version number " + version + ": build not specified");
                }
                int[] intComponents = new int[intComponentsList.size()];
                int startFound$iv$iv22 = 0;
                int n3 = ((Collection)intComponentsList).size();
                while (startFound$iv$iv22 < n3) {
                    void i;
                    Object e = intComponentsList.get((int)i);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"intComponentsList[i]");
                    intComponents[i] = ((Number)e).intValue();
                    ++i;
                }
                int[] nArray = Arrays.copyOf(intComponents, intComponents.length);
                boolean bl = isSnapshot;
                return new IdeVersionImpl(productCode, nArray, bl, null);
            }
            int buildNumber = this.parseBuildNumber(version, code);
            if (buildNumber <= 2000) {
                return new IdeVersionImpl(productCode, new int[]{buildNumber, 0}, false, 4, null);
            }
            int baselineVersion = this.getBaseLineForHistoricBuilds(buildNumber);
            return new IdeVersionImpl(productCode, new int[]{baselineVersion, buildNumber}, false, 4, null);
        }

        private final int parseBuildNumber(String version, String code) {
            if (Intrinsics.areEqual((Object)this.getSNAPSHOT(), (Object)code) || Intrinsics.areEqual((Object)this.getSTAR(), (Object)code) || Intrinsics.areEqual((Object)this.getBUILD_NUMBER(), (Object)code)) {
                return this.getSNAPSHOT_VALUE();
            }
            try {
                return Integer.parseInt(code);
            }
            catch (NumberFormatException e) {
                throw (Throwable)new IllegalArgumentException("Invalid version number: " + version);
            }
        }

        private final int getBaseLineForHistoricBuilds(int bn) {
            if (bn >= 10000) {
                return 88;
            }
            if (bn >= 9500) {
                return 85;
            }
            if (bn >= 9100) {
                return 81;
            }
            if (bn >= 8000) {
                return 80;
            }
            if (bn >= 7500) {
                return 75;
            }
            if (bn >= 7200) {
                return 72;
            }
            if (bn >= 6900) {
                return 69;
            }
            if (bn >= 6500) {
                return 65;
            }
            if (bn >= 6000) {
                return 60;
            }
            if (bn >= 5000) {
                return 55;
            }
            if (bn >= 4000) {
                return 50;
            }
            return 40;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

