/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.version;

import com.jetbrains.plugin.structure.intellij.version.IdeVersionImpl;
import org.jetbrains.annotations.NotNull;

public abstract class IdeVersion
implements Comparable<IdeVersion> {
    @NotNull
    public static IdeVersion createIdeVersion(@NotNull String version) throws IllegalArgumentException {
        return IdeVersionImpl.Companion.fromString(version);
    }

    public static boolean isValidIdeVersion(@NotNull String version) {
        try {
            IdeVersionImpl.Companion.fromString(version);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public abstract String asString(boolean var1, boolean var2);

    public String asString() {
        return this.asString(true, true);
    }

    public String asStringWithoutProductCode() {
        return this.asString(false, true);
    }

    public String asStringWithoutProductCodeAndSnapshot() {
        return this.asString(false, false);
    }

    @NotNull
    public abstract String getProductCode();

    public abstract int getBaselineVersion();

    public abstract int getBuild();

    public abstract boolean isSnapshot();

    public abstract int[] getComponents();
}

