/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.utils;

import com.jetbrains.plugin.structure.intellij.utils.StringUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class URLUtil {
    public static final String SCHEME_SEPARATOR = "://";
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_SEPARATOR = "!/";

    private URLUtil() {
    }

    @NotNull
    public static InputStream openStream(@NotNull URL url) throws IOException {
        String protocol = url.getProtocol();
        return protocol.equals(JAR_PROTOCOL) ? URLUtil.openRecursiveJarStream(url) : url.openStream();
    }

    @NotNull
    public static URL fileToUrl(@NotNull File file) throws IOException {
        return file.getCanonicalFile().toURI().toURL();
    }

    public static boolean resourceExists(@NotNull URL url) {
        try {
            InputStream inputStream = URLUtil.openStream(url);
            inputStream.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @NotNull
    public static InputStream openResourceStream(URL url) throws IOException {
        try {
            return URLUtil.openStream(url);
        }
        catch (FileNotFoundException ex) {
            InputStream resourceStream;
            int pos;
            String protocol = url.getProtocol();
            String file = null;
            if (protocol.equals(FILE_PROTOCOL)) {
                file = url.getFile();
            } else if (protocol.equals(JAR_PROTOCOL) && (pos = url.getFile().indexOf("!")) >= 0) {
                file = url.getFile().substring(pos + 1);
            }
            if (file != null && file.startsWith("/") && (resourceStream = URLUtil.class.getResourceAsStream(file)) != null) {
                return resourceStream;
            }
            throw ex;
        }
    }

    @NotNull
    public static String unquote(@NotNull String urlString) {
        urlString = urlString.replace('/', File.separatorChar);
        return URLUtil.unescapePercentSequences(urlString);
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    @NotNull
    public static File urlToFile(@NotNull URL url) throws URISyntaxException, MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            String str = url.toString();
            if (str.indexOf(32) > 0) {
                return new File(new URL(StringUtil.replace(str, " ", "%20")).toURI());
            }
            throw e;
        }
    }

    @NotNull
    public static String unescapePercentSequences(@NotNull String s) {
        if (s.indexOf(37) == -1) {
            return s;
        }
        StringBuilder decoded = new StringBuilder();
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '%') {
                ArrayList<Integer> bytes = new ArrayList<Integer>();
                while (i + 2 < len && s.charAt(i) == '%') {
                    int d1 = URLUtil.decode(s.charAt(i + 1));
                    int d2 = URLUtil.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    bytes.add((d1 & 0xF) << 4 | d2 & 0xF);
                    i += 3;
                }
                if (!bytes.isEmpty()) {
                    byte[] bytesArray = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        bytesArray[j] = ((Integer)bytes.get(j)).byteValue();
                    }
                    decoded.append(new String(bytesArray, Charset.forName("UTF-8")));
                    continue;
                }
            }
            decoded.append(c);
            ++i;
        }
        return decoded.toString();
    }

    @NotNull
    private static InputStream openRecursiveJarStream(@NotNull URL url) throws IOException {
        String[] paths = URLUtil.splitUrl(url.toExternalForm());
        if (paths.length == 0) {
            throw new MalformedURLException(url.toExternalForm());
        }
        File baseJarFile = new File(URLUtil.unquote(paths[0]));
        ZipInputStream baseJarStream = new ZipInputStream(new BufferedInputStream(FileUtils.openInputStream((File)baseJarFile)));
        if (paths.length == 1) {
            return baseJarStream;
        }
        return URLUtil.openRecursiveJarStream(baseJarStream, Arrays.copyOfRange(paths, 1, paths.length));
    }

    @NotNull
    private static InputStream openRecursiveJarStream(@NotNull ZipInputStream baseZipStream, @NotNull String[] innerJarEntries) throws IOException {
        ZipInputStream currentStream = baseZipStream;
        for (int i = 0; i < innerJarEntries.length; ++i) {
            String entryName = innerJarEntries[i];
            ZipEntry entry = URLUtil.findEntryByName(currentStream, entryName);
            if (entry == null) {
                baseZipStream.close();
                throw new FileNotFoundException(Arrays.toString(innerJarEntries));
            }
            if (URLUtil.isJarOrZipEntry(entryName)) {
                currentStream = new ZipInputStream(currentStream);
                continue;
            }
            if (i == innerJarEntries.length - 1) continue;
            baseZipStream.close();
            throw new FileNotFoundException("Entry " + entryName + " is neither .zip nor .jar archive: " + Arrays.toString(innerJarEntries));
        }
        return currentStream;
    }

    @Nullable
    private static ZipEntry findEntryByName(ZipInputStream zipStream, String entryName) throws IOException {
        ZipEntry e;
        while ((e = zipStream.getNextEntry()) != null) {
            if (!e.getName().equals(entryName)) continue;
            return e;
        }
        return null;
    }

    private static boolean isJarOrZipEntry(String entry) {
        return StringUtil.endsWithIgnoreCase(entry, ".jar") || StringUtil.endsWithIgnoreCase(entry, ".zip");
    }

    @NotNull
    public static URL getJarEntryURL(@NotNull File file, @NotNull String pathInJar) throws MalformedURLException {
        String fileURL = URLUtil.getFileEscapedUri(file);
        return new URL("jar:" + fileURL + JAR_SEPARATOR + StringUtil.trimLeading(pathInJar, '/'));
    }

    @NotNull
    public static String[] splitUrl(@NotNull String path) {
        while (path.startsWith("jar:")) {
            path = StringUtil.trimStart(path, "jar:");
        }
        while (path.startsWith("file:")) {
            path = StringUtil.trimStart(path, "file:");
        }
        return path.split("\\!/");
    }

    @NotNull
    public static String getFileEscapedUri(@NotNull File file) {
        return StringUtil.replace(file.toURI().toASCIIString(), "!", "%21");
    }
}

