/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.utils;

import com.google.common.io.ByteStreams;
import com.jetbrains.plugin.structure.intellij.utils.StringUtil;
import com.jetbrains.plugin.structure.intellij.utils.URLUtil;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.io.IOUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.filter.AbstractFilter;
import org.jdom2.filter.Filter;
import org.jdom2.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class JDOMUtil {
    private static final EmptyTextFilter CONTENT_FILTER = new EmptyTextFilter();
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];

    private JDOMUtil() {
    }

    private static boolean areElementsEqual(Element e1, Element e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return StringUtil.equal(e1.getName(), e2.getName()) && JDOMUtil.attListsEqual(e1.getAttributes(), e2.getAttributes()) && JDOMUtil.contentListsEqual(e1.getContent((Filter)CONTENT_FILTER), e2.getContent((Filter)CONTENT_FILTER));
    }

    private static boolean contentListsEqual(List c1, List c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        ListIterator l1 = c1.listIterator();
        ListIterator l2 = c2.listIterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next())) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2) {
        if (!(c1 instanceof Element) && !(c2 instanceof Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof Element && c2 instanceof Element && JDOMUtil.areElementsEqual((Element)c1, (Element)c2);
    }

    private static boolean attListsEqual(@NotNull List a1, @NotNull List a2) {
        if (a1.size() != a2.size()) {
            return false;
        }
        for (int i = 0; i < a1.size(); ++i) {
            if (JDOMUtil.attEqual((Attribute)a1.get(i), (Attribute)a2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean attEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    @NotNull
    public static Document loadDocument(URL url) throws JDOMException, IOException {
        InputStream stream = URLUtil.openStream(url);
        try {
            Document document = JDOMUtil.loadDocument(stream);
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        InputStream copied = JDOMUtil.copyInputStream(stream);
        InputStreamReader reader = new InputStreamReader(copied, Charset.forName("UTF-8"));
        try {
            SAXBuilder saxBuilder = new SAXBuilder();
            saxBuilder.setEntityResolver(new EntityResolver(){

                @Override
                @NotNull
                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new CharArrayReader(EMPTY_CHAR_ARRAY));
                }
            });
            Document document = saxBuilder.build((Reader)reader);
            return document;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    @NotNull
    public static Document loadResourceDocument(URL url) throws JDOMException, IOException {
        InputStream stream = URLUtil.openResourceStream(url);
        try {
            Document document = JDOMUtil.loadDocument(stream);
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public static boolean isEmpty(@NotNull Element element) {
        return element.getAttributes().isEmpty() && element.getContent().isEmpty();
    }

    @NotNull
    private static InputStream copyInputStream(@NotNull InputStream is) throws IOException {
        return new ByteArrayInputStream(ByteStreams.toByteArray((InputStream)is));
    }

    private static class EmptyTextFilter
    extends AbstractFilter {
        private EmptyTextFilter() {
        }

        public Object filter(Object obj) {
            if (obj instanceof Text && ((Text)obj).getText().trim().isEmpty()) {
                return null;
            }
            return obj;
        }
    }
}

